/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.webserver;

import java.net.Socket;
import jeus.ejb.webserver.CustomRequestHandler;
import jeus.ejb.webserver.RequestHandler;
import jeus.ejb.webserver.WebServerException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB10;

public class HandlerThread
implements Runnable {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.webserver");
    private RequestHandler httpHandler = new CustomRequestHandler();
    private Socket socket;

    public void run() {
        this.acceptRequests();
    }

    public void resumeNew(Socket socket) throws WebServerException {
        try {
            this.httpHandler.setSocket(socket);
            this.socket = socket;
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB10._6301_LEVEL)) {
                logger.logp(JeusMessage_EJB10._6301_LEVEL, "HandlerThread", "resumeNew", JeusMessage_EJB10._6301, ex);
            }
            throw new WebServerException(JeusMessage_EJB10._6301, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptRequests() {
        try {
            this.httpHandler.processRequest();
        }
        catch (Throwable ex) {
        }
        finally {
            try {
                this.socket.shutdownInput();
            }
            catch (Throwable t) {}
            try {
                this.socket.shutdownOutput();
            }
            catch (Throwable t) {}
            try {
                this.socket.close();
            }
            catch (Throwable t) {}
        }
    }
}

