/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.webserver;

import java.io.IOException;
import java.net.Socket;
import javax.management.ObjectName;
import jeus.ejb.webserver.HandlerThread;
import jeus.ejb.webserver.WebServerException;
import jeus.util.JeusPort;
import jeus.util.PooledExecutorFactory;
import jeus.util.concurrent50.concurrent.ThreadPoolExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB10;
import jeus.util.net.JeusSocketDispatcher;
import jeus.util.net.VirtualListener;

public class WebLinkManager
implements VirtualListener {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.webserver");
    private final int port = JeusPort.ClassFTP;
    public boolean exported = false;
    private ThreadPoolExecutor pooledExecutor;

    public WebLinkManager(int backlog, int threadPoolSize, ObjectName objectName) throws WebServerException {
        try {
            this.pooledExecutor = (ThreadPoolExecutor)PooledExecutorFactory.createPooledExecutor((String)"WebLinkManager", (int)threadPoolSize);
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB10._6401_LEVEL)) {
                logger.logp(JeusMessage_EJB10._6401_LEVEL, "WebLinkManager", "<init>", JeusMessage_EJB10._6401, (Object)Integer.toString(this.port), ex);
            }
            throw new WebServerException(JeusMessage_EJB10._6401, Integer.toString(this.port), ex);
        }
    }

    public void export() throws IOException {
        JeusSocketDispatcher.registerHandler((VirtualListener)this);
        this.exported = true;
    }

    public void unexport() {
        JeusSocketDispatcher.unregisterHandler((VirtualListener)this);
        this.pooledExecutor.shutdownNow();
        this.exported = false;
    }

    public String getId() {
        return String.valueOf(this.port);
    }

    public void onSocket(Socket socket) throws IOException {
        if (!this.exported) {
            try {
                socket.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return;
        }
        HandlerThread thread = new HandlerThread();
        thread.resumeNew(socket);
        try {
            this.pooledExecutor.execute((Runnable)thread);
        }
        catch (Throwable t) {
            try {
                socket.close();
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
    }
}

