/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.webserver;

import java.io.IOException;
import javax.management.ObjectName;
import jeus.ejb.webserver.WebLinkManager;
import jeus.ejb.webserver.WebServerException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB10;

public class WebServer {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.webserver");
    private WebLinkManager acceptThread;
    private int threadPoolSize = 5;
    private int backlog = 50;

    public WebServer(ObjectName objectName) throws WebServerException {
        try {
            this.acceptThread = new WebLinkManager(this.backlog, this.threadPoolSize, objectName);
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB10._6451_LEVEL)) {
                logger.logp(JeusMessage_EJB10._6451_LEVEL, "WebServer", "<init>", JeusMessage_EJB10._6451, ex);
            }
            throw new WebServerException(JeusMessage_EJB10._6451, ex);
        }
    }

    public void export() throws WebServerException {
        try {
            this.acceptThread.export();
        }
        catch (IOException ioe) {
            throw new WebServerException(ioe.toString(), (Throwable)ioe);
        }
        if (logger.isLoggable(JeusMessage_EJB10._6452_LEVEL)) {
            logger.logp(JeusMessage_EJB10._6452_LEVEL, "WebServer", "export", JeusMessage_EJB10._6452);
        }
    }

    public void unexport() {
        this.acceptThread.unexport();
        if (logger.isLoggable(JeusMessage_EJB10._6453_LEVEL)) {
            logger.logp(JeusMessage_EJB10._6453_LEVEL, "WebServer", "unexport", JeusMessage_EJB10._6453);
        }
    }
}

