/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.common;

import java.util.HashMap;
import java.util.Map;

public class DBMSType {
    private static final Map<String, DBMSType> allTypes = new HashMap<String, DBMSType>();
    public static final DBMSType ORACLE = new DBMSType("oracle");
    public static final DBMSType SYBASE = new DBMSType("sybase");
    public static final DBMSType MSSQL = new DBMSType("mssql");
    public static final DBMSType DB2 = new DBMSType("db2");
    public static final DBMSType TIBERO = new DBMSType("tibero");
    public static final DBMSType INFORMIX = new DBMSType("informix");
    public static final DBMSType MYSQL = new DBMSType("mysql");
    public static final DBMSType OTHERS = new DBMSType("others");
    private String name;

    public static DBMSType getType(String vendorName) {
        return allTypes.get(vendorName);
    }

    private DBMSType(String name) {
        this.name = name;
        allTypes.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBMSType dbmsType = (DBMSType)o;
        return this.name.equalsIgnoreCase(dbmsType.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

