/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import jeus.jdbc.common.JeusCachePooledConnection;
import jeus.jdbc.common.JeusConnection;
import jeus.jdbc.common.JeusConnectionImpl;
import jeus.jdbc.common.JeusPreparedStatement;
import jeus.jdbc.util.CacheHashtable;

public class JeusCacheConnection
extends JeusConnectionImpl {
    private CacheHashtable cache;

    public JeusCacheConnection(Connection connection, CacheHashtable cache, JeusCachePooledConnection pcon) {
        super(connection, pcon);
        this.cache = cache;
    }

    public JeusCacheConnection(Connection con, CacheHashtable cache, JeusCachePooledConnection pcon, long stmtQueryTimeout) {
        super(con, pcon, stmtQueryTimeout);
        this.cache = cache;
    }

    public PreparedStatement prepareStatement(String key) throws SQLException {
        this.checkClosed();
        JeusPreparedStatement jps = (JeusPreparedStatement)this.cache.get(key);
        if (jps == null) {
            jps = new JeusPreparedStatement(super.prepareStatement(key), (JeusConnection)this);
            this.cache.put(key, jps);
        }
        return jps;
    }

    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2) throws SQLException {
        this.checkClosed();
        String key = arg0 + "$$" + arg1 + "$$" + arg2;
        JeusPreparedStatement jps = (JeusPreparedStatement)this.cache.get(key);
        if (jps == null) {
            jps = new JeusPreparedStatement(super.prepareStatement(arg0, arg1, arg2), (JeusConnection)this);
            this.cache.put(key, jps);
        }
        return jps;
    }

    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        this.checkClosed();
        String key = arg0 + "$$" + arg1;
        JeusPreparedStatement jps = (JeusPreparedStatement)this.cache.get(key);
        if (jps == null) {
            jps = new JeusPreparedStatement(super.prepareStatement(arg0, arg1), (JeusConnection)this);
            this.cache.put(key, jps);
        }
        return jps;
    }

    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        this.checkClosed();
        String key = arg0 + this.getArrayKey(arg1);
        JeusPreparedStatement jps = (JeusPreparedStatement)this.cache.get(key);
        if (jps == null) {
            jps = new JeusPreparedStatement(super.prepareStatement(arg0, arg1), (JeusConnection)this);
            this.cache.put(key, jps);
        }
        return jps;
    }

    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        this.checkClosed();
        String key = arg0 + "$$" + arg1 + "$$" + arg2 + "$$" + arg3;
        JeusPreparedStatement jps = (JeusPreparedStatement)this.cache.get(key);
        if (jps == null) {
            jps = new JeusPreparedStatement(super.prepareStatement(arg0, arg1, arg2, arg3), (JeusConnection)this);
            this.cache.put(key, jps);
        }
        return jps;
    }

    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        this.checkClosed();
        String key = arg0 + this.getArrayKey(arg1);
        JeusPreparedStatement jps = (JeusPreparedStatement)this.cache.get(key);
        if (jps == null) {
            jps = new JeusPreparedStatement(super.prepareStatement(arg0, arg1), (JeusConnection)this);
            this.cache.put(key, jps);
        }
        return jps;
    }

    private String getArrayKey(int[] arg1) {
        StringBuffer result = new StringBuffer();
        for (int anArg1 : arg1) {
            result.append("$$");
            result.append(anArg1);
        }
        return result.toString();
    }

    private String getArrayKey(String[] arg1) {
        StringBuffer result = new StringBuffer();
        for (String anArg1 : arg1) {
            result.append("$$");
            result.append(anArg1);
        }
        return result.toString();
    }

    public void close() throws SQLException {
        this.cache = null;
        super.close();
    }
}

