/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.common;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import jeus.jdbc.common.JeusConnection;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.JDBCResource;
import jeus.util.logging.JeusLogger;
import jeus.util.trace.ManagedResource;

public class JeusConnectionImpl
implements JeusConnection {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");
    protected final JeusPooledConnection jeusPooledConn;
    protected final Connection actualConn;
    private int queryTimeout = 0;
    private int fetchSize = -1;
    private final JDBCResource managedResource;
    private boolean isClosed;
    private Throwable trace;

    public JeusConnectionImpl(Connection delegated, JeusPooledConnection pcon) {
        this.actualConn = delegated;
        this.managedResource = new JDBCResource(this);
        this.jeusPooledConn = pcon;
    }

    public JeusConnectionImpl(Connection delegated, JeusPooledConnection pcon, long queryTimeout) {
        this(delegated, pcon);
        this.queryTimeout = (int)(queryTimeout / 1000L);
    }

    public void setDefaultRowPrefetch(int i) {
        this.fetchSize = i;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("This connection has been already closed");
        }
    }

    public void setReadOnly(boolean arg0) throws SQLException {
        this.checkClosed();
        this.actualConn.setReadOnly(arg0);
    }

    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.actualConn.isReadOnly();
    }

    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.trace != null) {
            this.jeusPooledConn.unsetConnectionTrace(this);
        }
        this.jeusPooledConn.closeConnectionHandle(this);
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        this.checkClosed();
        Statement st = this.actualConn.createStatement(arg0, arg1, arg2);
        this.setStmtInfo(st);
        return st;
    }

    private void setStmtInfo(Statement st) throws SQLException {
        if (this.queryTimeout > 0) {
            st.setQueryTimeout(this.queryTimeout);
        }
        if (this.fetchSize > 0) {
            st.setFetchSize(this.fetchSize);
        }
    }

    public Statement createStatement() throws SQLException {
        this.checkClosed();
        Statement st = this.actualConn.createStatement();
        this.setStmtInfo(st);
        return st;
    }

    public Statement createStatement(int arg0, int arg1) throws SQLException {
        this.checkClosed();
        Statement st = this.actualConn.createStatement(arg0, arg1);
        this.setStmtInfo(st);
        return st;
    }

    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        this.checkClosed();
        PreparedStatement ps = this.actualConn.prepareStatement(arg0, arg1);
        this.setStmtInfo(ps);
        return ps;
    }

    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        this.checkClosed();
        PreparedStatement ps = this.actualConn.prepareStatement(arg0, arg1);
        this.setStmtInfo(ps);
        return ps;
    }

    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        this.checkClosed();
        PreparedStatement ps = this.actualConn.prepareStatement(arg0, arg1, arg2, arg3);
        this.setStmtInfo(ps);
        return ps;
    }

    public PreparedStatement prepareStatement(String arg0) throws SQLException {
        this.checkClosed();
        PreparedStatement ps = this.actualConn.prepareStatement(arg0);
        this.setStmtInfo(ps);
        return ps;
    }

    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        this.checkClosed();
        PreparedStatement ps = this.actualConn.prepareStatement(arg0, arg1);
        this.setStmtInfo(ps);
        return ps;
    }

    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2) throws SQLException {
        this.checkClosed();
        PreparedStatement ps = this.actualConn.prepareStatement(arg0, arg1, arg2);
        this.setStmtInfo(ps);
        return ps;
    }

    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        this.checkClosed();
        CallableStatement cs = this.actualConn.prepareCall(arg0, arg1, arg2);
        this.setStmtInfo(cs);
        return cs;
    }

    public CallableStatement prepareCall(String arg0) throws SQLException {
        this.checkClosed();
        CallableStatement cs = this.actualConn.prepareCall(arg0);
        this.setStmtInfo(cs);
        return cs;
    }

    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        this.checkClosed();
        CallableStatement cs = this.actualConn.prepareCall(arg0, arg1, arg2, arg3);
        this.setStmtInfo(cs);
        return cs;
    }

    public String nativeSQL(String arg0) throws SQLException {
        this.checkClosed();
        return this.actualConn.nativeSQL(arg0);
    }

    public void setAutoCommit(boolean arg0) throws SQLException {
        this.checkClosed();
        this.actualConn.setAutoCommit(arg0);
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.actualConn.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.checkClosed();
        this.actualConn.commit();
    }

    public void rollback(Savepoint arg0) throws SQLException {
        this.checkClosed();
        this.actualConn.rollback(arg0);
    }

    public void rollback() throws SQLException {
        this.checkClosed();
        this.actualConn.rollback();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return this.actualConn.getMetaData();
    }

    public void setCatalog(String arg0) throws SQLException {
        this.checkClosed();
        this.actualConn.setCatalog(arg0);
    }

    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.actualConn.getCatalog();
    }

    public void setTransactionIsolation(int arg0) throws SQLException {
        this.checkClosed();
        this.actualConn.setTransactionIsolation(arg0);
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return this.actualConn.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.actualConn.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.actualConn.clearWarnings();
    }

    public Map getTypeMap() throws SQLException {
        this.checkClosed();
        return this.actualConn.getTypeMap();
    }

    public void setTypeMap(Map arg0) throws SQLException {
        this.checkClosed();
        this.actualConn.setTypeMap(arg0);
    }

    public void setHoldability(int arg0) throws SQLException {
        this.checkClosed();
        this.actualConn.setHoldability(arg0);
    }

    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.actualConn.getHoldability();
    }

    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        return this.actualConn.setSavepoint();
    }

    public Savepoint setSavepoint(String arg0) throws SQLException {
        this.checkClosed();
        return this.actualConn.setSavepoint(arg0);
    }

    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        this.checkClosed();
        this.actualConn.releaseSavepoint(arg0);
    }

    public Connection getActualHandle() {
        return this.actualConn;
    }

    public ManagedResource getManagedResource() {
        return this.managedResource;
    }

    public String getConnectionId() {
        return this.jeusPooledConn.getConnectionId();
    }

    public String toString() {
        return "JeusConnection@" + Integer.toHexString(this.hashCode()) + "[PHY_ID=" + this.jeusPooledConn.getConnectionId() + ",actual=" + this.actualConn + "]";
    }

    public void setConnectionTrace(Throwable trace) {
        this.trace = trace;
    }

    public Throwable getConnectionTrace() {
        return this.trace;
    }
}

