/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import java.util.Hashtable;
import java.util.Properties;
import javax.annotation.Resource;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import jeus.container.resource.ResourceRefHelper;
import jeus.jdbc.connectionpool.ClusterDataSourceWrapper;
import jeus.jdbc.connectionpool.ClusteredConnectionPool;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.info.ClusterDataSourceInfo;
import jeus.jndi.jns.common.PropertyReference;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public class ClusterDataSourceFactory
implements ObjectFactory {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");
    private static Hashtable pools = new Hashtable(10);
    private static Object sync = new Object();

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        String exportName = null;
        try {
            if (!(obj instanceof PropertyReference)) {
                throw new Exception("Invalid reference object - " + obj);
            }
            PropertyReference ref = (PropertyReference)obj;
            ClusterDataSourceInfo poolInfo = (ClusterDataSourceInfo)ref.get(0).getContent();
            exportName = poolInfo.getExportName();
            ClusteredConnectionPool pool = (ClusteredConnectionPool)pools.get(exportName);
            if (pool == null) {
                pool = ClusterDataSourceFactory.innerCreateConnectionPool(ref, exportName, env);
            }
            Properties properties = ref.getProperties();
            boolean shareable = ResourceRefHelper.fetchShareable(properties);
            Resource.AuthenticationType resAuthType = ResourceRefHelper.fetchAppAuth(properties);
            return new ClusterDataSourceWrapper(pool, shareable, resAuthType);
        }
        catch (ConnectionPoolException t) {
            if (logger.isLoggable(JeusMessage_JDBC._323_LEVEL)) {
                logger.logp(JeusMessage_JDBC._323_LEVEL, "ClusterDataSourceFactory", "getObjectInstance", JeusMessage_JDBC._323, exportName);
            }
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClusteredConnectionPool innerCreateConnectionPool(Reference ref, String exportName, Hashtable env) throws ConnectionPoolException {
        ClusteredConnectionPool pool;
        Object object = sync;
        synchronized (object) {
            pool = (ClusteredConnectionPool)pools.get(exportName);
            if (pool != null) {
                return pool;
            }
            String className = ref.getClassName();
            try {
                pool = (ClusteredConnectionPool)Class.forName(className).newInstance();
                pool.initialize(ref, env);
            }
            catch (Throwable e) {
                if (logger.isLoggable(JeusMessage_JDBC._321_LEVEL)) {
                    logger.logp(JeusMessage_JDBC._321_LEVEL, "ClusterDataSourceFactory", "innerCreateConnectionPool", JeusMessage_JDBC._321, (Object)exportName);
                }
                throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._321, (Object)exportName), e);
            }
            pools.put(exportName, pool);
        }
        return pool;
    }

    public static ClusteredConnectionPool getClusteredConnectionPool(String exportName) {
        return (ClusteredConnectionPool)pools.get(exportName);
    }
}

