/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Resource;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import jeus.ejb.io.IndirectlySerializable;
import jeus.ejb.io.SerializableObjectFactory;
import jeus.jdbc.JEUSDataSource;
import jeus.jdbc.connectionpool.ClusteredConnectionPool;
import jeus.jdbc.connectionpool.SerializableDataSourceFactory;

public class ClusterDataSourceWrapper
implements JEUSDataSource,
IndirectlySerializable {
    private final ClusteredConnectionPool clusteredPool;
    private final boolean shareable;
    private final Resource.AuthenticationType resAuthType;

    public ClusterDataSourceWrapper(ClusteredConnectionPool pool, boolean shareable, Resource.AuthenticationType resAuthType) {
        this.clusteredPool = pool;
        this.shareable = shareable;
        this.resAuthType = resAuthType;
    }

    ClusteredConnectionPool getConnectionPool() {
        return this.clusteredPool;
    }

    public Connection getConnection() throws SQLException {
        return this.clusteredPool.getConnection(null, null, this.shareable);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.clusteredPool.getConnection(username, password, this.shareable);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.clusteredPool.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.clusteredPool.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.clusteredPool.setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this.clusteredPool.getLoginTimeout();
    }

    public int getType() {
        return this.clusteredPool.getType();
    }

    public String getDriverVendorName() {
        return this.clusteredPool.getDriverVendorName();
    }

    public boolean isHandleNullTransaction() {
        return false;
    }

    public SerializableObjectFactory getSerializableObjectFactory() {
        return new SerializableDataSourceFactory(this);
    }

    public XAConnection getRawXAConnection() throws SQLException {
        return null;
    }

    public void closeRawXAConnection(XAConnection con, boolean abnormalClose) throws SQLException {
    }

    public DataSource getDelegateDataSource() {
        return null;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer(64);
        strBuf.append(this.clusteredPool.getExportName());
        strBuf.append(";list=[");
        strBuf.append(this.clusteredPool.getDataSourceList());
        strBuf.append("], shareable=");
        strBuf.append(this.shareable);
        return strBuf.toString();
    }
}

