/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import com.sybase.jdbc2.jdbc.SybDriver;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import jeus.jdbc.common.JeusConnection;
import jeus.jdbc.common.JeusConnectionImpl;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.ConnectionEventListenerImpl;
import jeus.jdbc.connectionpool.ConnectionPool;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.connectionpool.JeusSQLException;
import jeus.jdbc.connectionpool.PooledConnectionProviderImpl;
import jeus.jdbc.datasource.DBDSBinder;
import jeus.jdbc.datasource.DataSourceConstants;
import jeus.jdbc.helper.ConnectionPoolDBAHelper;
import jeus.jdbc.helper.LogicalConnectionPreparerImpl;
import jeus.jdbc.helper.PeriodicConnectionChecker;
import jeus.jdbc.info.CPInfo;
import jeus.jdbc.info.ConnectionPoolInfo;
import jeus.jdbc.info.DynamicPoolStatsAndInfo;
import jeus.jdbc.info.PooledConnectionInfo;
import jeus.jdbc.vendorhook.VendorHookFactory;
import jeus.jdbc.vendorhook.VendorSpecificHook;
import jeus.jdbc.xa.JDBCLocalXAResourceWrapper;
import jeus.jdbc.xa.XAControlConnection;
import jeus.jndi.jns.common.PropertyReference;
import jeus.jndi.objectfactory.SerializableRefAddr;
import jeus.management.j2ee.statistics.RangeStatisticImpl;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.security.util.LoginUtil;
import jeus.server.enginecontainer.InvocationManagerCenter;
import jeus.transaction.TMCommonService;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TransactionImpl;
import jeus.transaction.TransactionLocal;
import jeus.transaction.TxHelper;
import jeus.transaction.resources.LocalXAResourceWrapper;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;
import jeus.util.properties.JeusJDBCProperties;

public class ConnectionPoolImpl
implements ConnectionPool {
    private PooledConnectionProviderImpl pooledConnectionProvider;
    private ConnectionPoolDBAHelper poolDBAHelper;
    private Object datasrc;
    private ConnectionPoolInfo info;
    private DataSource nullTxDelegator;
    private Object initializerHandback;
    private Reference ref;
    private VendorSpecificHook vendorHook;
    private LogicalConnectionPreparerImpl logicalConnectionPreparer;
    private PeriodicConnectionChecker periodicChecker;
    private DynamicPoolStatsAndInfo stats;
    private final AtomicBoolean working = new AtomicBoolean(false);
    private final AtomicBoolean onReconfig = new AtomicBoolean(false);
    private final AtomicBoolean failed = new AtomicBoolean(false);
    private static final JeusLogger logger;
    private boolean isLocalXAPool = false;
    private boolean isXAPool = false;
    private boolean jtaSupported;
    private static TransactionManager txManager;
    private TransactionLocal<JeusPooledConnection> sharedPhysicalConnection = null;
    private boolean useConnectionTrace;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConnectionPoolImpl(ConnectionPoolInfo info) {
        this.info = info;
    }

    public ConnectionPoolImpl() throws ConnectionPoolException {
        this(null);
    }

    public void initialize(Reference ref, Hashtable env) throws ConnectionPoolException {
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            this.ref = ref;
            this.info = (ConnectionPoolInfo)ref.get(0).getContent();
            String nullTxDelegate = this.info.getNullTxDelegate();
            int type = this.info.getPoolType();
            if (this.info.isDelegationRequired() && (type == 2 || type == 3) && !nullTxDelegate.equals("")) {
                this.nullTxDelegator = (DataSource)new InitialContext(env).lookup(nullTxDelegate);
            }
            if (this.info.isDbaRequired()) {
                int dbaTo = this.info.getDbaTimeout();
                this.poolDBAHelper = new ConnectionPoolDBAHelper(this.info.getMaxPoolSize(), this.info.getDBMSType(), dbaTo);
                this.poolDBAHelper.setDBADelegate(env, dbaTo, this.info.getExportName(), this.info.getDbaDelegate());
            }
            this.initialize();
        }
        catch (Throwable th) {
            if (logger.isLoggable(JeusMessage_JDBC._4_LEVEL)) {
                logger.logp(JeusMessage_JDBC._4_LEVEL, "ConnectionPool", "initialize", JeusMessage_JDBC._4, (Object)this.info.getExportName());
            }
            if (th instanceof ConnectionPoolException) {
                throw (ConnectionPoolException)((Object)th);
            }
            throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._4, (Object)this.info.getExportName()), th);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    public void initialize() throws ConnectionPoolException {
        try {
            this.isLocalXAPool = this.info.getPoolType() == 3;
            boolean bl = this.isXAPool = this.info.getPoolType() == 2;
            if (this.isLocalXAPool || this.isXAPool) {
                this.sharedPhysicalConnection = new TransactionLocal();
                this.jtaSupported = true;
            }
            this.info.setUpDataSource();
            this.datasrc = this.info.getDataSource();
            this.stats = new DynamicPoolStatsAndInfo(this.info);
            this.vendorHook = VendorHookFactory.createHook(this.info.getDBMSType());
            this.vendorHook.initializeHook(this.datasrc, this.info);
            this.logicalConnectionPreparer = new LogicalConnectionPreparerImpl(this);
            this.pooledConnectionProvider = new PooledConnectionProviderImpl(this, this.stats);
            this.pooledConnectionProvider.initProvider();
            long checkQueryPeriod = this.info.getCheckQueryPeriod();
            if (checkQueryPeriod > 0L) {
                this.periodicChecker = new PeriodicConnectionChecker(checkQueryPeriod, this);
                this.periodicChecker.startPeriodicChecker();
            }
            this.useConnectionTrace = this.info.getUseConnectionTrace();
            this.working.set(true);
        }
        catch (Throwable ex) {
            if (this.pooledConnectionProvider != null) {
                this.pooledConnectionProvider.destroy();
            }
            logger.logp(JeusMessage_JDBC._4_LEVEL, "ConnectionPool", "initialize", JeusMessage_JDBC._4, (Object)this.info.getExportName());
            throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._4, (Object)this.info.getExportName()), ex);
        }
    }

    public Connection getConnectionToCheck() throws SQLException {
        this.checkWorkingNow();
        return this.innerGetConnection(null, null, true, false);
    }

    public JeusPooledConnection getPooledConnectionDirectly() throws SQLException {
        return this.pooledConnectionProvider.getPooledConnection(null, null, true);
    }

    public void returnPooledConnectionDirectly(JeusPooledConnection pcon) {
        this.pooledConnectionProvider.returnConnection(pcon);
    }

    public void abandonPooledConnection(JeusPooledConnection pcon) {
    }

    public void clearAbandonedConnections() {
    }

    public void abandonAllPooledConnections() {
    }

    public JeusPooledConnection createNewPooledConnection() throws SQLException {
        return this.pooledConnectionProvider.createNewPooledConnection();
    }

    public ConnectionPoolDBAHelper getDBAHelper() {
        return this.poolDBAHelper;
    }

    public boolean isHandleNullTransaction() {
        return this.info.isDelegationRequired() && this.nullTxDelegator != null;
    }

    public String getDriverVendorName() {
        return this.info.getDriverVendorName();
    }

    public void connectionClosed(JeusPooledConnection con) {
        this.closeConnection(con, false, false);
    }

    public void connectionErrorOccurred(JeusPooledConnection con) {
        this.closeConnection(con, true, false);
    }

    private void closeConnection(JeusPooledConnection pcon, boolean abnormalClose, boolean rawXAConnection) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "trying to close connection from physical connection " + pcon + ", datasource = " + this.info.getExportName());
        }
        pcon.changeToIdle();
        if (!abnormalClose && this.poolDBAHelper != null) {
            abnormalClose = pcon.isForcedClosed();
        }
        if (!rawXAConnection) {
            this.logicalConnectionPreparer.stripConnectionHandleResource(pcon, abnormalClose);
            pcon.removeConnectionEventListener();
        }
        this.returnOrKillConnection(pcon, abnormalClose, rawXAConnection);
    }

    private void returnOrKillConnection(JeusPooledConnection pcon, boolean abnormalClose, boolean rawXAConnection) {
        if (pcon.isDisposable()) {
            this.pooledConnectionProvider.closeConnection(pcon);
            return;
        }
        if (abnormalClose) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "close the physical connection " + pcon, (Throwable)new Exception("errored or forced closing"));
            }
            try {
                logger.log(Level.FINE, "Trying to replace a connection : " + pcon + ", ds = " + this.info.getExportName());
                pcon.setAbnormallyClosed(true);
                this.pooledConnectionProvider.connectionAbnormallyClosed(pcon);
            }
            catch (Throwable ex) {
                if (logger.isLoggable(JeusMessage_JDBC._354_LEVEL)) {
                    logger.log(JeusMessage_JDBC._354_LEVEL, JeusMessage_JDBC._354, ex);
                }
            }
        } else if (rawXAConnection || !this.jtaSupported || !pcon.isShared() || !TxHelper.isTransactionActive()) {
            this.pooledConnectionProvider.returnConnection(pcon);
        }
    }

    public Connection getConnection(String username, String password, boolean shareable) throws SQLException {
        this.checkWorkingNow();
        this.checkTransactionTimeout();
        if ((this.isXAPool || this.isLocalXAPool) && this.nullTxDelegator != null && TMCommonService.isAssociatedWithNullTransaction()) {
            return this.nullTxDelegator.getConnection(username, password);
        }
        return this.innerGetConnection(username, password, false, shareable);
    }

    private Connection innerGetConnection(String username, String password, boolean returnNullOnEmptyQueue, boolean shareable) throws SQLException {
        JeusPooledConnection pcon = null;
        JeusConnectionImpl connection = null;
        try {
            Transaction tx = txManager.getTransaction();
            if (tx != null) {
                if (this.isLocalXAPool && !shareable) {
                    throw new SQLException("LocalXADataSource should not be unshareable resource");
                }
                if (this.isLocalXAPool) {
                    pcon = this.checkAndGetEnlistedLocalXAConnection((TransactionImpl)tx);
                } else if (this.isXAPool && shareable) {
                    pcon = this.sharedPhysicalConnection.get();
                }
            }
            if (pcon == null && (pcon = this.prepareConnection(username, password, returnNullOnEmptyQueue, false)) != null) {
                tx = txManager.getTransaction();
                if (tx != null && this.jtaSupported && shareable) {
                    tx.registerSynchronization((Synchronization)new SharedConnectionSynchronization(pcon));
                    if (this.isLocalXAPool) {
                        this.enlistLocalXAConnection((TransactionImpl)tx, pcon);
                    } else {
                        this.sharedPhysicalConnection.set(pcon);
                    }
                    pcon.setShared(true);
                    pcon.setClosable(false);
                } else {
                    pcon.setShared(false);
                }
            }
            if (pcon != null) {
                connection = pcon.getJeusConnection();
                if (!$assertionsDisabled && connection == null) {
                    throw new AssertionError();
                }
                this.registerConnectionResource(pcon, connection);
                if (this.useConnectionTrace) {
                    connection.setConnectionTrace(new Throwable());
                    pcon.setConnectionTrace(connection);
                }
                this.vendorHook.beforeReturnConnection(connection);
                this.checkTransactionTimeout();
                pcon.changeToActive();
            }
            return connection;
        }
        catch (Throwable th) {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException ignored) {
                // empty catch block
            }
            logger.logp(JeusMessage_JDBC._218_LEVEL, "ConnectionPool", "innerGetConnection", JeusMessage_JDBC._218, th);
            if (th instanceof SQLException) {
                throw (SQLException)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new JeusSQLException(th);
        }
    }

    private JeusPooledConnection prepareConnection(String username, String password, boolean returnNullOnEmptyQueue, boolean rawXASupport) throws SQLException {
        JeusPooledConnection pcon = this.pooledConnectionProvider.getPooledConnection(username, password, returnNullOnEmptyQueue);
        if (pcon == null) {
            return null;
        }
        boolean errOnce = false;
        while (true) {
            try {
                if (rawXASupport) {
                    this.logicalConnectionPreparer.prepareRawXAConnection(pcon, this);
                } else {
                    this.logicalConnectionPreparer.prepareConnectionHandle(pcon, this);
                    if (this.poolDBAHelper != null) {
                        Connection vcon = pcon.getActualHandle();
                        this.poolDBAHelper.addSessionId(pcon, vcon);
                    }
                    pcon.addConnectionEventListener(new ConnectionEventListenerImpl(this, pcon));
                }
                return pcon;
            }
            catch (SQLException e) {
                if (pcon != null) {
                    if (logger.isLoggable(JeusMessage_JDBC._220_LEVEL)) {
                        logger.log(JeusMessage_JDBC._220_LEVEL, JeusMessage_JDBC._220, (Object)pcon, (Throwable)e);
                    }
                    this.pooledConnectionProvider.closeConnection(pcon);
                }
                if (pcon != null && pcon.isDisposable()) {
                    throw new JeusSQLException(JeusMessage_JDBC._8, (Throwable)e);
                }
                if (errOnce) {
                    if (logger.isLoggable(JeusMessage_JDBC._338_LEVEL)) {
                        logger.log(JeusMessage_JDBC._338_LEVEL, JeusMessage_JDBC._338, (Throwable)e);
                    }
                    throw e;
                }
                if (logger.isLoggable(JeusMessage_JDBC._337_LEVEL)) {
                    logger.log(JeusMessage_JDBC._337_LEVEL, JeusMessage_JDBC._337, (Object)this.getExportName());
                }
                try {
                    pcon = this.createNewPooledConnection();
                }
                catch (Throwable th) {
                    if (this.periodicChecker != null) {
                        this.changeFailedState(false, true);
                    }
                    if (th instanceof SQLException) {
                        throw (SQLException)th;
                    }
                    if (th instanceof RuntimeException) {
                        throw (RuntimeException)th;
                    }
                    throw new JeusSQLException(th);
                }
                errOnce = true;
                continue;
            }
            break;
        }
    }

    private JeusPooledConnection checkAndGetEnlistedLocalXAConnection(TransactionImpl tx) throws SQLException {
        JDBCLocalXAResourceWrapper jdbcLocalXA;
        LocalXAResourceWrapper lrsc = tx.getLocalXAResource();
        if (lrsc == null) {
            return null;
        }
        if (lrsc instanceof JDBCLocalXAResourceWrapper && (jdbcLocalXA = (JDBCLocalXAResourceWrapper)lrsc).getConnectionPool() == this) {
            JeusPooledConnection jeusConn = jdbcLocalXA.getJeusPooledConnection();
            if (logger.isLoggable(JeusMessage_JDBC._311_LEVEL)) {
                logger.log(JeusMessage_JDBC._311_LEVEL, JeusMessage_JDBC._311, (Object)jeusConn);
            }
            return jeusConn;
        }
        throw new SQLException("Already another local transaction resource are being used for current transaction");
    }

    private void enlistLocalXAConnection(TransactionImpl tx, JeusPooledConnection pcon) throws SQLException {
        try {
            JDBCLocalXAResourceWrapper lrsc = new JDBCLocalXAResourceWrapper(pcon, this);
            tx.setLocalXAResource(lrsc);
            if (logger.isLoggable(JeusMessage_JDBC._9_LEVEL)) {
                logger.log(JeusMessage_JDBC._9_LEVEL, JeusMessage_JDBC._9, (Object[])new String[]{this.info.getExportName(), tx.getGTID().toString()});
            }
        }
        catch (Throwable ex) {
            logger.logp(JeusMessage_JDBC._11_LEVEL, "ConnectionPool", "enlistLocalXAResource", JeusMessage_JDBC._11, (Object)this.info.getExportName());
            throw new JeusSQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._11, (Object)this.info.getExportName()), ex);
        }
    }

    private void checkTransactionTimeout() throws SQLException {
        if ((this.isXAPool || this.isLocalXAPool) && TMCommonService.isTxTimeout()) {
            SQLException ex = new SQLException("The transaction associated with this thread has been already timed out, tx : " + ThreadContexts.getAssociatedTransactionID());
            if (logger.isLoggable(JeusMessage_JDBC._355_LEVEL)) {
                logger.log(JeusMessage_JDBC._355_LEVEL, JeusMessage_JDBC._355, (Throwable)ex);
            }
            throw ex;
        }
    }

    private void checkWorkingNow() throws SQLException {
        if (!this.working.get()) {
            if (logger.isLoggable(JeusMessage_JDBC._14_LEVEL)) {
                logger.logp(JeusMessage_JDBC._14_LEVEL, "ConnectionPool", "innerGetConnection", JeusMessage_JDBC._14, (Object)this.info.getExportName());
            }
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._14, (Object)this.info.getExportName()));
        }
    }

    void registerConnectionResource(JeusPooledConnection pcon, JeusConnection vcon) {
        if (this.poolDBAHelper != null) {
            this.poolDBAHelper.scheduleConnectionTimer(pcon);
        }
        InvocationManagerCenter.addResource(vcon.getManagedResource());
    }

    public void removeConnectionResource(JeusPooledConnection pcon, JeusConnection connection) {
        if (pcon != null && this.poolDBAHelper != null) {
            this.poolDBAHelper.removeConnectionTimer(pcon);
        }
        if (connection != null) {
            InvocationManagerCenter.removeResource(connection.getManagedResource());
        }
    }

    public XAConnection getControlConnection() throws SQLException {
        this.checkWorkingNow();
        JeusPooledConnection con = this.pooledConnectionProvider.getPooledConnection(null, null, false);
        return new XAControlConnection(con);
    }

    public void closeControlConnection(PooledConnection con) {
        XAControlConnection xaCon = (XAControlConnection)con;
        this.returnOrKillConnection(xaCon.delegate, false, false);
        xaCon.delegate = null;
    }

    public XAConnection getRawXAConnection() throws SQLException {
        if (this.info.getPoolType() != 2) {
            throw new SQLException("This operation can be used only on XA type datasource");
        }
        this.checkWorkingNow();
        JeusPooledConnection pcon = this.prepareConnection(null, null, false, true);
        if (pcon == null) {
            throw new SQLException("There is no available connection");
        }
        pcon.setRawConnection(true);
        pcon.changeToActive();
        return pcon;
    }

    public void closeRawXAConnection(XAConnection con, boolean abnormalClose) throws SQLException {
        if (this.info.getPoolType() != 2) {
            throw new SQLException("This operation can be used only on XA type datasource");
        }
        if (!(con instanceof JeusPooledConnection)) {
            throw new SQLException("Not a JeusPooledConnection - " + con);
        }
        JeusPooledConnection pcon = (JeusPooledConnection)con;
        pcon.setRawConnection(false);
        this.closeConnection(pcon, abnormalClose, true);
    }

    public PrintWriter getLogWriter() throws SQLException {
        if (this.datasrc instanceof DataSource) {
            return ((DataSource)this.datasrc).getLogWriter();
        }
        if (this.datasrc instanceof ConnectionPoolDataSource) {
            return ((ConnectionPoolDataSource)this.datasrc).getLogWriter();
        }
        if (this.datasrc instanceof XADataSource) {
            return ((XADataSource)this.datasrc).getLogWriter();
        }
        throw new RuntimeException("Never happen");
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        if (this.datasrc instanceof DataSource) {
            ((DataSource)this.datasrc).setLogWriter(out);
        } else if (this.datasrc instanceof ConnectionPoolDataSource) {
            ((ConnectionPoolDataSource)this.datasrc).setLogWriter(out);
        } else if (this.datasrc instanceof XADataSource) {
            ((XADataSource)this.datasrc).setLogWriter(out);
        } else {
            throw new RuntimeException("Never happen");
        }
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        if (this.datasrc instanceof DataSource) {
            ((DataSource)this.datasrc).setLoginTimeout(seconds);
        } else if (this.datasrc instanceof ConnectionPoolDataSource) {
            ((ConnectionPoolDataSource)this.datasrc).setLoginTimeout(seconds);
        } else if (this.datasrc instanceof XADataSource) {
            ((XADataSource)this.datasrc).setLoginTimeout(seconds);
        } else {
            throw new RuntimeException("Never happen");
        }
    }

    public int getLoginTimeout() throws SQLException {
        if (this.datasrc instanceof DataSource) {
            return ((DataSource)this.datasrc).getLoginTimeout();
        }
        if (this.datasrc instanceof ConnectionPoolDataSource) {
            return ((ConnectionPoolDataSource)this.datasrc).getLoginTimeout();
        }
        if (this.datasrc instanceof XADataSource) {
            return ((XADataSource)this.datasrc).getLoginTimeout();
        }
        throw new RuntimeException("Never happen");
    }

    public void refresh() throws SQLException {
        this.pooledConnectionProvider.refresh();
    }

    public Reference getReference() throws NamingException {
        if (this.ref == null) {
            this.ref = new PropertyReference(this.getClass().getName(), DataSourceConstants.FACTORY_CLASSNAME, null);
            this.ref.add(0, new SerializableRefAddr("connectionpool_info", this.info));
        }
        return this.ref;
    }

    public void forcedShrink() {
        try {
            this.pooledConnectionProvider.resizePool(true);
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_JDBC._334_LEVEL)) {
                logger.log(JeusMessage_JDBC._334_LEVEL, JeusMessage_JDBC._334, (Object)this.info.getExportName());
            }
            e.printStackTrace();
        }
    }

    public void enable() {
        this.working.set(true);
    }

    public void disable() {
        this.working.set(false);
    }

    public void update(Hashtable properties) throws ConnectionPoolException {
        if (!this.onReconfig.compareAndSet(false, true)) {
            return;
        }
        try {
            Class<?> cl = this.datasrc.getClass();
            Class[] argTypes = new Class[]{String.class};
            Object[] args = new Object[1];
            Enumeration e = properties.keys();
            while (e.hasMoreElements()) {
                String arg = (String)e.nextElement();
                if (arg.equals("User")) {
                    args[0] = properties.get(arg);
                    DBDSBinder.invokeMethod(cl, "setUser", argTypes, this.datasrc, args);
                    continue;
                }
                if (!arg.equals("Password")) continue;
                args[0] = properties.get(arg);
                DBDSBinder.invokeMethod(cl, "setPassword", argTypes, this.datasrc, args);
            }
            this.pooledConnectionProvider.updateQueue(properties);
        }
        catch (Throwable th) {
            if (logger.isLoggable(JeusMessage_JDBC._207_LEVEL)) {
                logger.logp(JeusMessage_JDBC._207_LEVEL, "ConnectionPool", "update", JeusMessage_JDBC._207, (Object)this.getExportName());
            }
            throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._207, (Object)this.getExportName()), th);
        }
        finally {
            this.onReconfig.set(false);
        }
    }

    public void destroy() {
        this.working.set(false);
        this.pooledConnectionProvider.destroy();
        if (this.periodicChecker != null) {
            this.periodicChecker.destroy();
        }
        this.stats.destroy();
    }

    public int getType() {
        return this.info.getPoolType();
    }

    public CPInfo getCPInfo() {
        CPInfo cpInfo = this.pooledConnectionProvider.getCPInfo();
        cpInfo.setWorking(this.working.get());
        return cpInfo;
    }

    public ConnectionPoolInfo getConnectionPoolInfo() {
        return this.info;
    }

    public boolean isWorking() {
        return this.working.get();
    }

    public String getInfo() {
        return this.ref.toString();
    }

    public long getWaitingThreadCount() {
        return ((RangeStatisticImpl)this.stats.getWaitingThreadCountStat()).getCurrent();
    }

    public String getName() {
        if (this.info != null) {
            return this.info.getExportName();
        }
        return "<NOT INITIALIZED>";
    }

    public String getExportName() {
        return this.info.getExportName();
    }

    public PooledConnectionInfo[] getPooledConnectionInfoArray() {
        return this.stats.getPooledConnectionInfoArray();
    }

    public String getUserName() {
        return this.info.getUserName();
    }

    public StatisticImpl getUseTimeStatistic() {
        return this.stats.getUseTimeStat();
    }

    public StatisticImpl getCreateCountStatistic() {
        return this.stats.getCreatCountStat();
    }

    public StatisticImpl getWaitingThreadCountStatistic() {
        return this.stats.getWaitingThreadCountStat();
    }

    public StatisticImpl getReConnectCountStatistic() {
        return null;
    }

    public StatisticImpl getCurrentConnectionStatistic() {
        return this.stats.getActiveConnections();
    }

    public StatisticImpl getConnectionPoolMinSizeStat() {
        return this.stats.getMinSizeStat();
    }

    public StatisticImpl getConnectionPoolMaxSizeStat() {
        return this.stats.getMaxSizeStat();
    }

    public StatisticImpl getFreePoolSizeStatistic() {
        return this.stats.getIdleConnections();
    }

    public StatisticImpl getWaitTimeStatistic() {
        return this.stats.getWaitTimeStat();
    }

    public StatisticImpl getCloseCountStatistic() {
        return this.stats.getCloseCountStat();
    }

    public int getPoolSize() {
        return this.pooledConnectionProvider.size();
    }

    public DataSource getDelegateDataSource() {
        return this.nullTxDelegator;
    }

    public void putInitializerHandback(Object jdbcDataSource) {
        this.initializerHandback = jdbcDataSource;
    }

    public Object getInitializerHandback() {
        return this.initializerHandback;
    }

    public void changeFailedState(boolean expect, boolean update) {
        this.failed.compareAndSet(expect, update);
    }

    public boolean isFailed() {
        return this.failed.get();
    }

    public static String getConnectionTraceAsString(Throwable trace) {
        StringBuffer strBuffer = new StringBuffer(256);
        StackTraceElement[] traces = trace.getStackTrace();
        for (int i = 3; i < traces.length; ++i) {
            strBuffer.append("\n    ").append(traces[i]);
        }
        return strBuffer.toString();
    }

    static {
        boolean bl = $assertionsDisabled = !ConnectionPoolImpl.class.desiredAssertionStatus();
        if (JeusJDBCProperties.SYBASE_DEBUG) {
            try {
                SybDriver driver = (SybDriver)Class.forName("com.sybase.jdbc2.jdbc.SybDriver").newInstance();
                driver.getDebug().debug(true, "ALL");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");
        txManager = TxHelper.getTransactionManager();
    }

    private class SharedConnectionSynchronization
    implements Synchronization {
        private JeusPooledConnection pcon;

        public SharedConnectionSynchronization(JeusPooledConnection pcon) {
            this.pcon = pcon;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            try {
                this.pcon.closeConnectionHandleAfterTxCompletion();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

