/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jeus.jdbc.connectionpool.JEUSConnectionChecker;
import jeus.jdbc.connectionpool.JeusSQLException;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_JDBC;

public final class DefaultConnectionChecker
implements JEUSConnectionChecker {
    private String queryString;

    public void checkConnection(Connection vcon) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = vcon.prepareStatement(this.queryString);
            boolean isResultSet = ps.execute();
            if (isResultSet) {
                rs = ps.getResultSet();
            }
        }
        catch (Throwable th) {
            throw new JeusSQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._313, (Object)vcon), th);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public void setQueryString(String query) {
        this.queryString = query;
    }
}

