/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.datasource;

import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.naming.InitialContext;
import jeus.jdbc.connectionpool.ClusteredConnectionPool;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.datasource.ClusterDSBindInfo;
import jeus.jdbc.datasource.DBDSBindInfo;
import jeus.jdbc.datasource.DBDataSourceException;
import jeus.jdbc.datasource.DataSourceGenerator;
import jeus.jdbc.info.ConnectionPoolInfo;
import jeus.util.JeusRootClassLoader;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public class DBDSBinder {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");

    public static boolean bind(DBDSBindInfo info, boolean forced) {
        try {
            int type = info.getDataSourceType();
            Object src = type >= 1 ? DBDSBinder.getConnectionPool(info) : DataSourceGenerator.getDataSource(info);
            Hashtable<String, String> envs = new Hashtable<String, String>();
            envs.put("jeus.jndi.jns.replicatebindings", "false");
            envs.put("jeus.jndi.jns.forcedbindings", "true");
            InitialContext ctx = new InitialContext(envs);
            if (forced) {
                ctx.rebind(info.getExportName(), src);
            } else {
                ctx.bind(info.getExportName(), src);
            }
            if (logger.isLoggable(JeusMessage_JDBC._40_LEVEL)) {
                logger.log(JeusMessage_JDBC._40_LEVEL, JeusMessage_JDBC._40, (Object)info.toString());
            }
            return true;
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_JDBC._41_LEVEL)) {
                logger.log(JeusMessage_JDBC._41_LEVEL, JeusMessage_JDBC._41, (Object)info.toString(), ex);
            }
            return false;
        }
    }

    public static boolean bind(ClusterDSBindInfo info, boolean forced) {
        try {
            ClusteredConnectionPool src = new ClusteredConnectionPool(info);
            Hashtable<String, String> envs = new Hashtable<String, String>();
            envs.put("jeus.jndi.jns.replicatebindings", "false");
            envs.put("jeus.jndi.jns.forcedbindings", "true");
            InitialContext ctx = new InitialContext(envs);
            if (forced) {
                ctx.rebind(info.getExportName(), (Object)src);
            } else {
                ctx.bind(info.getExportName(), (Object)src);
            }
            if (logger.isLoggable(JeusMessage_JDBC._40_LEVEL)) {
                logger.log(JeusMessage_JDBC._40_LEVEL, JeusMessage_JDBC._40, (Object)info.toString());
            }
            return true;
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_JDBC._41_LEVEL)) {
                logger.log(JeusMessage_JDBC._41_LEVEL, JeusMessage_JDBC._41, (Object)info.toString(), ex);
            }
            return false;
        }
    }

    private static Object getConnectionPool(DBDSBindInfo info) {
        return new ConnectionPoolImpl(new ConnectionPoolInfo(info));
    }

    public static ClassLoader getDSClassLoader() {
        return JeusRootClassLoader.loader;
    }

    public static void invokeMethod(Class cl, String methodName, Class[] argTypes, Object instance, Object[] args) throws DBDataSourceException {
        try {
            Method m = cl.getMethod(methodName, argTypes);
            m.invoke(instance, args);
        }
        catch (Throwable t) {
            throw new DBDataSourceException(9043, new String[]{cl.getName(), methodName}, t);
        }
    }
}

