/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.driver.blackbox;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import jeus.jdbc.driver.blackbox.BlackboxConnection;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public final class BlackboxPooledConnection
implements PooledConnection {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");
    private Connection con;
    private ConnectionEventListener listener = null;
    private ConnectionEvent event;

    public BlackboxPooledConnection(Connection con) {
        this.con = con;
        this.event = new ConnectionEvent(this);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listener = listener;
    }

    public void close() throws SQLException {
        this.con.close();
    }

    void innerClosed() {
        block3: {
            if (this.listener != null) {
                try {
                    this.listener.connectionClosed(this.event);
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_JDBC._215_LEVEL)) break block3;
                    logger.logp(JeusMessage_JDBC._215_LEVEL, "BlackboxPooledConnection", "innerClosed", JeusMessage_JDBC._215, t);
                }
            }
        }
    }

    void innerErrorOccurred() {
        block3: {
            if (this.listener != null) {
                try {
                    this.listener.connectionErrorOccurred(this.event);
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_JDBC._216_LEVEL)) break block3;
                    logger.logp(JeusMessage_JDBC._216_LEVEL, "BlackboxPooledConnection", "innerErrorOccurred", JeusMessage_JDBC._216, t);
                }
            }
        }
    }

    public Connection getConnection() throws SQLException {
        return new BlackboxConnection(this.con, this);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listener = null;
    }
}

