/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.info;

import java.io.Serializable;
import java.util.logging.Level;
import javax.naming.Reference;
import javax.naming.Referenceable;
import jeus.jdbc.common.DBMSType;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.datasource.DBDSBindInfo;
import jeus.jdbc.datasource.DBDataSourceException;
import jeus.jdbc.datasource.DataSourceGenerator;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public class ConnectionPoolInfo
implements Serializable {
    private static final long serialVersionUID = -8145243471276316975L;
    private transient Object datasrc;
    private transient Reference dataSrcReference;
    private final String exportName;
    private final String driverVendorName;
    private transient DBMSType dbmsType;
    private final DBDSBindInfo bindInfo;
    private final boolean waiting;
    private final long waitingTime;
    private final int type;
    private final boolean delegationRequired;
    private final String nullTxDelegate;
    private final boolean dbaRequired;
    private final int dbaTimeout;
    private final boolean isCheckQuery;
    private final String checkQuery;
    private String checkQueryClassName;
    private long nonValidationInterval;
    private final boolean enableStmtCaching;
    private final int stmtCachingSize;
    private final boolean autoCommit;
    private final boolean useAutoCommit;
    private final boolean enableFetchSize;
    private final int fetchSize;
    private final long stmtQueryTimeout;
    private final boolean useConnectionTrace;
    private final boolean keepConnectionHandleOpen;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");
    private final long resizingPeriod;
    private long idleTimeout;
    private final int maxUseCount;
    private final String dbaDelegate;
    private long checkQueryPeriod;
    private String userName;
    private int minPoolSize;
    private int maxPoolSize;
    private int increaseStep;

    public ConnectionPoolInfo(DBDSBindInfo info) {
        this.exportName = info.getExportName();
        this.driverVendorName = info.getVendor();
        this.waiting = info.getWaiting();
        this.waitingTime = this.waiting ? info.getWaitingTime() : 0L;
        this.type = info.getDataSourceType();
        this.delegationRequired = info.isDelegationRequired();
        this.nullTxDelegate = info.getNullTxDelegate();
        this.dbaDelegate = info.getDBADelegate();
        this.minPoolSize = info.getMin();
        this.maxPoolSize = info.getMax();
        this.increaseStep = info.getStep();
        this.maxUseCount = info.getMaxUseCount();
        this.resizingPeriod = info.getResizingPeriod();
        this.idleTimeout = info.getIdleTimeout();
        this.useAutoCommit = info.isUseAutoCommitSetting();
        this.autoCommit = info.getAutoCommitValue();
        this.checkQuery = info.getCheckQuery();
        this.checkQueryClassName = info.getCheckQueryClassName();
        this.checkQueryPeriod = info.getCheckQueryPeriod();
        this.nonValidationInterval = info.getNonValidationInterval();
        this.keepConnectionHandleOpen = info.isKeepConnectionHandleOpen();
        this.userName = info.getUserName();
        this.dbaRequired = info.isDBARequired();
        this.dbaTimeout = this.dbaRequired ? info.getDbaTO() : 0;
        if (this.checkQuery != null && !this.checkQuery.equals("") || this.checkQueryClassName != null && !this.checkQueryClassName.equals("")) {
            this.isCheckQuery = true;
            if (this.checkQueryClassName == null || this.checkQueryClassName.equals("")) {
                this.checkQueryClassName = "jeus.jdbc.connectionpool.DefaultConnectionChecker";
            }
        } else {
            this.isCheckQuery = false;
            this.checkQueryClassName = null;
        }
        this.stmtCachingSize = info.getStmtCachingSize();
        this.enableStmtCaching = this.stmtCachingSize > 0;
        this.fetchSize = info.getFetchSize();
        this.enableFetchSize = this.fetchSize > 0;
        this.stmtQueryTimeout = info.getStmtQueryTimeout();
        this.useConnectionTrace = info.getUseConnectionTrace();
        this.bindInfo = info;
    }

    public Object getDataSource() {
        return this.datasrc;
    }

    public void setUpDataSource() throws DBDataSourceException {
        if (this.datasrc == null) {
            this.datasrc = DataSourceGenerator.getDataSource(this.bindInfo);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, " datasource  " + this.datasrc + " is generated for connection pool = " + this.exportName);
            }
        }
    }

    public int getPoolType() {
        return this.type;
    }

    public String getExportName() {
        return this.exportName;
    }

    public String getDriverVendorName() {
        return this.driverVendorName;
    }

    public DBMSType getDBMSType() {
        if (this.dbmsType == null) {
            this.dbmsType = DBMSType.getType(this.driverVendorName);
            if (this.dbmsType == null) {
                this.dbmsType = DBMSType.OTHERS;
            }
        }
        return this.dbmsType;
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public long getWaitingTime() {
        return this.waitingTime;
    }

    public boolean isDelegationRequired() {
        return this.delegationRequired;
    }

    public String getNullTxDelegate() {
        return this.nullTxDelegate;
    }

    public boolean isDbaRequired() {
        return this.dbaRequired;
    }

    public int getDbaTimeout() {
        return this.dbaTimeout;
    }

    public boolean isCheckQuery() {
        return this.isCheckQuery;
    }

    public String getCheckQuery() {
        return this.checkQuery;
    }

    public String getCheckQueryClassName() {
        return this.checkQueryClassName;
    }

    public boolean isEnableStmtCaching() {
        return this.enableStmtCaching;
    }

    public int getStmtCachingSize() {
        return this.stmtCachingSize;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public boolean isUseAutoCommit() {
        return this.useAutoCommit;
    }

    public boolean isEnableFetchSize() {
        return this.enableFetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int max) {
        this.maxPoolSize = max;
    }

    public long getResizingPeriod() {
        return this.resizingPeriod;
    }

    public int getIncreaseStep() {
        return this.increaseStep;
    }

    public void setIncreaseStep(int step) {
        this.increaseStep = step;
    }

    public void setMinPoolSize(int min) {
        this.minPoolSize = min;
    }

    public int getMaxUseCount() {
        return this.maxUseCount;
    }

    public String getDbaDelegate() {
        return this.dbaDelegate;
    }

    public long getCheckQueryPeriod() {
        return this.checkQueryPeriod;
    }

    public long getNonValidationInterval() {
        return this.nonValidationInterval;
    }

    public String getUserName() {
        return this.userName;
    }

    public long getStmtQueryTimeout() {
        return this.stmtQueryTimeout;
    }

    public Reference getDataSourceReference() throws ConnectionPoolException {
        if (this.dataSrcReference == null) {
            try {
                this.dataSrcReference = ((Referenceable)DataSourceGenerator.getDataSource(this.bindInfo)).getReference();
            }
            catch (Exception ex) {
                logger.logp(JeusMessage_JDBC._3_LEVEL, "ConnectionPool", "<init>", JeusMessage_JDBC._3, (Object)this.getExportName());
                throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._3, (Object)this.getExportName()), (Throwable)ex);
            }
        }
        return this.dataSrcReference;
    }

    public boolean getUseConnectionTrace() {
        return this.useConnectionTrace;
    }

    public boolean isKeepConnectionHandleOpen() {
        return this.keepConnectionHandleOpen;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }
}

