/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.queue;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;
import jeus.jdbc.common.JeusCachePooledConnection;
import jeus.jdbc.common.JeusNonCachePooledConnection;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.connectionpool.JeusSQLException;
import jeus.jdbc.connectionpool.WaitTimeoutException;
import jeus.jdbc.helper.ConnectionPoolDBAHelper;
import jeus.jdbc.info.CPInfo;
import jeus.jdbc.info.ConnectionPoolInfo;
import jeus.jdbc.info.DynamicPoolStatsAndInfo;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCConnectionQueue {
    private final LinkedList<JeusPooledConnection> queue = new LinkedList();
    private final ConnectionPoolImpl connectionPool;
    private final ConnectionPoolInfo info;
    private final DynamicPoolStatsAndInfo stats;
    private final String idPrefix;
    private int increaseStep;
    private int minSize;
    private int maxSize;
    private int generation;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");
    private boolean destroyed = false;

    public JDBCConnectionQueue(ConnectionPoolImpl cp, DynamicPoolStatsAndInfo statHolder) {
        this.connectionPool = cp;
        this.stats = statHolder;
        this.info = cp.getConnectionPoolInfo();
        this.increaseStep = this.info.getIncreaseStep();
        this.maxSize = this.info.getMaxPoolSize();
        this.minSize = this.info.getMinPoolSize();
        this.idPrefix = this.info.getExportName() + "-";
    }

    public synchronized void initConnectionQueue(int initSize) throws SQLException {
        this.minSize = initSize;
        this.generation = 0;
        for (int i = 0; i < this.minSize; ++i) {
            this.putConnection(this.createPooledConnection(null, false));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized JeusPooledConnection getConnection(boolean waiting, long timeout, boolean returnNullOnEmpty) throws Exception {
        if (this.queue.isEmpty() && !returnNullOnEmpty) {
            int currentSize = this.stats.getCurrentPoolSize();
            if (currentSize < this.maxSize) {
                int margin = currentSize + this.increaseStep > this.maxSize ? this.maxSize - currentSize : this.increaseStep;
                this.sizeUpQueue(margin - 1);
                return this.createPooledConnection(null, false);
            }
            if (!waiting || timeout < 0L) return this.getSingleConnection(null, true);
            long realTimeout = timeout;
            long startTime = System.currentTimeMillis();
            try {
                while (true) {
                    this.wait(realTimeout);
                    long afterWaitTime = System.currentTimeMillis();
                    if (this.destroyed) {
                        logger.logp(JeusMessage_JDBC._20_LEVEL, "ConnectionStore", "getPooledConnection", JeusMessage_JDBC._20);
                        throw new JeusSQLException(JeusMessage_JDBC._20);
                    }
                    if (!this.queue.isEmpty()) return this.removeConnectionFromNonemptyQueue();
                    long waitedTime = afterWaitTime - startTime;
                    if (waitedTime < timeout) {
                        realTimeout = timeout - waitedTime;
                        continue;
                    }
                    if (this.queue.isEmpty()) throw new WaitTimeoutException("timeout occurred : " + this.info.getExportName());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return this.removeConnectionFromNonemptyQueue();
        } else {
            if (!this.queue.isEmpty() || !returnNullOnEmpty) return this.removeConnectionFromNonemptyQueue();
            return null;
        }
    }

    private JeusPooledConnection removeConnectionFromNonemptyQueue() {
        this.stats.decIdleConnections();
        return this.queue.removeFirst();
    }

    public JeusPooledConnection getSingleConnection(Object[] args, boolean disposable) throws SQLException {
        JeusPooledConnection pcon = this.createPooledConnection(args, disposable);
        pcon.setGeneration(this.generation);
        return pcon;
    }

    private void sizeUpQueue(int margin) throws SQLException {
        for (int i = 0; i < margin; ++i) {
            this.putConnection(this.createPooledConnection(null, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean putConnection(JeusPooledConnection pcon) {
        try {
            if (this.queue.size() >= this.maxSize) {
                this.destroyConnection(pcon);
                if (logger.isLoggable(JeusMessage_JDBC._345_LEVEL)) {
                    logger.log(JeusMessage_JDBC._345_LEVEL, JeusMessage_JDBC._345, (Object)this.info.getExportName());
                }
                boolean bl = false;
                return bl;
            }
            if (pcon.getGeneration() == -1) {
                pcon.setGeneration(this.generation);
            } else if (pcon.getGeneration() != this.generation) {
                this.destroyConnection(pcon);
                boolean bl = false;
                return bl;
            }
            this.stats.incIdleConnections();
            this.queue.addLast(pcon);
            boolean bl = true;
            return bl;
        }
        finally {
            this.notify();
        }
    }

    public synchronized int size() {
        return this.queue.size();
    }

    public synchronized <E> E[] toArray(E[] array) {
        return this.queue.toArray(array);
    }

    public synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public void shrinkPoolToMinimumSize() throws SQLException {
        this.resizePool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizePool() throws SQLException {
        ArrayList<JeusPooledConnection> toBeClosed = null;
        JDBCConnectionQueue jDBCConnectionQueue = this;
        synchronized (jDBCConnectionQueue) {
            block13: {
                int margin;
                int currentSize = this.stats.getCurrentPoolSize();
                if (currentSize > this.maxSize) {
                    currentSize = this.maxSize;
                }
                if ((margin = currentSize - this.minSize) == 0) {
                    return;
                }
                try {
                    if (margin > 0) {
                        toBeClosed = new ArrayList<JeusPooledConnection>(margin);
                        for (int i = 0; i < margin; ++i) {
                            if (this.queue.isEmpty()) {
                                break block13;
                            }
                            JeusPooledConnection pcon = this.removeConnectionFromNonemptyQueue();
                            toBeClosed.add(pcon);
                        }
                        break block13;
                    }
                    margin = -1 * margin;
                    this.sizeUpQueue(margin);
                }
                finally {
                    this.notifyAll();
                }
            }
        }
        if (toBeClosed != null) {
            Iterator it = toBeClosed.iterator();
            while (it.hasNext()) {
                JeusPooledConnection pcon = (JeusPooledConnection)it.next();
                this.destroyConnection(pcon);
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConnection(JeusPooledConnection pcon) {
        pcon.setAbnormallyClosed(true);
        ConnectionPoolDBAHelper dbaHelper = this.connectionPool.getDBAHelper();
        if (dbaHelper != null) {
            dbaHelper.removeSession(pcon);
        }
        try {
            pcon.close();
        }
        catch (Exception e) {
            logger.log(JeusMessage_JDBC._352_LEVEL, JeusMessage_JDBC._352, (Object)pcon, (Throwable)e);
        }
        finally {
            this.stats.incCloseCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceUsedConnection(JeusPooledConnection pcon) throws SQLException {
        try {
            this.destroyConnection(pcon);
        }
        finally {
            JDBCConnectionQueue jDBCConnectionQueue = this;
            synchronized (jDBCConnectionQueue) {
                JeusPooledConnection newPCon;
                if (this.stats.getCurrentPoolSize() < this.maxSize && this.putConnection(newPCon = this.createPooledConnection(null, false)) && logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "connection is replaced successfully");
                }
            }
        }
    }

    private void clearQueue() throws SQLException {
        while (!this.queue.isEmpty()) {
            JeusPooledConnection pcon = this.removeConnectionFromNonemptyQueue();
            this.destroyConnection(pcon);
        }
    }

    public synchronized void refreshQueue(int min, int max, int step) throws SQLException {
        this.minSize = min;
        this.maxSize = max;
        this.increaseStep = step;
        this.clearQueue();
        ++this.generation;
        for (int i = 0; i < this.minSize; ++i) {
            this.putConnection(this.createPooledConnection(null, false));
        }
    }

    public synchronized void destroy() throws Exception {
        this.clearQueue();
        this.destroyed = true;
        this.notifyAll();
    }

    public synchronized void setCPInfo(CPInfo cpInfo) {
        this.stats.setCPInfo(cpInfo);
    }

    private JeusPooledConnection createPooledConnection(Object[] args, boolean disposable) throws SQLException {
        String password;
        String username;
        Object dataSrc = this.info.getDataSource();
        if (args != null && args.length == 2 && args instanceof String[]) {
            username = (String)args[0];
            password = (String)args[1];
        } else {
            password = null;
            username = null;
        }
        int type = this.info.getPoolType();
        PooledConnection pooledConn = type == 1 || type == 3 ? (username == null ? ((ConnectionPoolDataSource)dataSrc).getPooledConnection() : ((ConnectionPoolDataSource)dataSrc).getPooledConnection(username, password)) : (username == null ? ((XADataSource)dataSrc).getXAConnection() : ((XADataSource)dataSrc).getXAConnection(username, password));
        this.stats.incCreateCount();
        long createCount = ((CountStatisticImpl)this.stats.getCreatCountStat()).getCount();
        logger.log(JeusMessage_JDBC._310_LEVEL, JeusMessage_JDBC._310, (Object)pooledConn);
        if (this.info.getStmtCachingSize() > 0) {
            return new JeusCachePooledConnection(pooledConn, this.idPrefix + createCount, this.stats, this.connectionPool, disposable);
        }
        return new JeusNonCachePooledConnection(pooledConn, this.idPrefix + createCount, this.stats, this.connectionPool, disposable);
    }
}

