/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.xa;

import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.jdbc.connectionpool.ConnectionPool;
import jeus.transaction.JeusXAException;
import jeus.transaction.resources.XAResourceWrapper;
import jeus.transaction.util.XidToString;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public class JDBCXAResourceWrapper
extends XAResourceWrapper {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");
    private ConnectionPool pool;
    private XAConnection xaCon;
    private boolean usingControlConnection;

    public JDBCXAResourceWrapper(ConnectionPool pool, XAResource resource) {
        super(resource);
        this.pool = pool;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            if (onePhase && this.usingControlConnection) {
                this.xaCon = this.pool.getControlConnection();
                this.resource = this.xaCon.getXAResource();
            }
            this.resource.commit(xid, onePhase);
        }
        catch (XAException ex) {
            if (logger.isLoggable(JeusMessage_JDBC._24_LEVEL)) {
                logger.logp(JeusMessage_JDBC._24_LEVEL, "JDBCXAResourceWrapper", "commit", JeusMessage_JDBC._24, (Object)XidToString.getXAErrorCode(ex.errorCode), (Throwable)ex);
            }
            throw ex;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_JDBC._24_LEVEL)) {
                logger.logp(JeusMessage_JDBC._24_LEVEL, "JDBCXAResourceWrapper", "commit", JeusMessage_JDBC._24, (Object)t.toString(), t);
            }
            throw new JeusXAException(JeusMessage_JDBC._24, t);
        }
        finally {
            if (this.usingControlConnection && this.xaCon != null) {
                this.usingControlConnection = false;
                this.pool.closeControlConnection(this.xaCon);
            }
        }
    }

    public void enforceEnd() {
        block4: {
            try {
                if (this.inTx) {
                    this.end(this.xid, 0x4000000);
                } else {
                    this.usingControlConnection = true;
                }
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_JDBC._102_LEVEL)) break block4;
                logger.logp(JeusMessage_JDBC._102_LEVEL, "JDBCXAResourceWrapper", "enforceEnd", JeusMessage_JDBC._102, t);
            }
        }
    }

    public int prepare(Xid xid) throws XAException {
        int result = -100;
        try {
            if (this.usingControlConnection) {
                this.xaCon = this.pool.getControlConnection();
                this.resource = this.xaCon.getXAResource();
            }
            int n = result = this.resource.prepare(xid);
            return n;
        }
        catch (XAException ex) {
            if (logger.isLoggable(JeusMessage_JDBC._37_LEVEL)) {
                logger.logp(JeusMessage_JDBC._37_LEVEL, "JDBCXAResourceWrapper", "prepare", JeusMessage_JDBC._37);
            }
            throw ex;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_JDBC._37_LEVEL)) {
                logger.logp(JeusMessage_JDBC._37_LEVEL, "JDBCXAResourceWrapper", "prepare", JeusMessage_JDBC._37);
            }
            throw new JeusXAException(JeusMessage_JDBC._37, t);
        }
        finally {
            if (result == 3 && this.usingControlConnection && this.xaCon != null) {
                this.usingControlConnection = false;
                this.pool.closeControlConnection(this.xaCon);
            }
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            if (this.usingControlConnection && this.xaCon == null) {
                this.xaCon = this.pool.getControlConnection();
                this.resource = this.xaCon.getXAResource();
            }
            this.resource.rollback(xid);
        }
        catch (XAException ex) {
            if (logger.isLoggable(JeusMessage_JDBC._32_LEVEL)) {
                logger.logp(JeusMessage_JDBC._32_LEVEL, "JDBCXAResourceWrapper", "rollback", JeusMessage_JDBC._32);
            }
            throw ex;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_JDBC._32_LEVEL)) {
                logger.logp(JeusMessage_JDBC._32_LEVEL, "JDBCXAResourceWrapper", "rollback", JeusMessage_JDBC._32);
            }
            throw new JeusXAException(JeusMessage_JDBC._32, t);
        }
        finally {
            if (this.usingControlConnection && this.xaCon != null) {
                this.usingControlConnection = false;
                this.pool.closeControlConnection(this.xaCon);
            }
        }
    }

    public XAConnection getXAConnection() {
        return this.xaCon;
    }

    public String getPoolUserName() {
        return this.pool.getUserName();
    }

    public String getName() {
        if (this.pool != null) {
            return this.pool.getExportName();
        }
        return null;
    }
}

