/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi;

import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.event.NamingListener;
import jeus.jndi.CacheableContext;
import jeus.jndi.JNSContext;
import jeus.jndi.JNSContextFactory;
import jeus.jndi.jns.local.JNSLocal;
import jeus.jndi.jns.local.Service;
import jeus.util.JeusException;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JNDI;

public class JEUSFailoverContext
implements CacheableContext {
    protected Hashtable env;
    protected final String[] linkNames;
    protected JNSContext context;
    protected String serverName;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jndi");

    public JEUSFailoverContext(String[] links, Hashtable table) throws NamingException {
        this.env = table;
        this.linkNames = links;
        this.initFailover(links);
        this.getAliveContext();
    }

    protected void initFailover(String[] links) {
        this.serverName = links[0];
        this.env.put("java.naming.provider.url", this.serverName);
    }

    protected void getAliveContext() throws NamingException {
        this.context = (JNSContext)JNSContextFactory.getInternalInitialContext(this.env);
    }

    protected boolean getAliveContextForLookup(List aa) {
        try {
            this.context = (JNSContext)JNSContextFactory.getInternalInitialContext(this.env);
            return true;
        }
        catch (Throwable nse) {
            nse.printStackTrace();
            return false;
        }
    }

    protected void handleFailedServer(String serverName) {
    }

    private void handleContextOperationException(NamingException ne, int failoverCount) throws NamingException {
        NamingException e = Service.wrapClientException(ne);
        if (this.stopFailover(failoverCount)) {
            throw e;
        }
        Throwable rootCause = ne.getRootCause();
        this.printException(ne, rootCause);
        if (rootCause instanceof JeusException || rootCause instanceof IOException || rootCause instanceof JeusRuntimeException || ne instanceof NameNotFoundException) {
            if (ne instanceof NameNotFoundException && !this.failoverForNameNotFoundException()) {
                throw e;
            }
            this.context = null;
            ne.printStackTrace();
            if (rootCause != null) {
                rootCause.printStackTrace();
            }
            if (logger.isLoggable(JeusMessage_JNDI._67_LEVEL)) {
                logger.log(JeusMessage_JNDI._67_LEVEL, JeusMessage_JNDI._67);
            }
        } else {
            throw e;
        }
        this.handleFailedServer(this.serverName);
        JNSLocal.down(this.serverName);
        this.getAliveContext();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleContextOperationExceptionForLookup(NamingException ne, List nameNotFoundContextList, int failoverCount) throws NamingException {
        NamingException e = Service.makeNamingException(ne);
        if (this.stopFailover(failoverCount)) {
            throw e;
        }
        Throwable rootCause = ne.getRootCause();
        if (ne instanceof NameNotFoundException) {
            if (!this.failoverForNameNotFoundException()) throw e;
            this.context = null;
            nameNotFoundContextList.add(this.serverName);
            if (this.getAliveContextForLookup(nameNotFoundContextList)) return;
            throw e;
        }
        this.printException(ne, rootCause);
        if (!(rootCause instanceof JeusException) && !(rootCause instanceof IOException) && !(rootCause instanceof JeusRuntimeException)) throw e;
        if (logger.isLoggable(JeusMessage_JNDI._67_LEVEL)) {
            logger.log(JeusMessage_JNDI._67_LEVEL, JeusMessage_JNDI._67);
        }
        this.handleFailedServer(this.serverName);
        this.context.getJNSLocal().cancel();
        this.context = null;
        if (this.getAliveContextForLookup(nameNotFoundContextList)) return;
        throw e;
    }

    private void printException(NamingException ne, Throwable rootCause) {
        if (logger.isLoggable(JeusMessage_JNDI._68_LEVEL)) {
            logger.log(JeusMessage_JNDI._68_LEVEL, JeusMessage_JNDI._68, (Throwable)ne);
        }
        if (rootCause != null && logger.isLoggable(JeusMessage_JNDI._69_LEVEL)) {
            logger.log(JeusMessage_JNDI._69_LEVEL, JeusMessage_JNDI._69, rootCause);
        }
    }

    protected boolean stopFailover(int failoverCount) {
        return failoverCount > 0;
    }

    protected boolean failoverForNameNotFoundException() {
        return false;
    }

    public synchronized Object lookup(Name name) throws NamingException {
        int failoverCount = 0;
        Vector notFoundContextList = new Vector();
        while (true) {
            try {
                if (logger.isLoggable(JeusMessage_JNDI._64_LEVEL)) {
                    logger.log(JeusMessage_JNDI._64_LEVEL, JeusMessage_JNDI._64, new Object[]{name, this.context.env.get("java.naming.provider.url")});
                }
                return this.context.lookup(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationExceptionForLookup(ne, notFoundContextList, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized Object lookup(String name) throws NamingException {
        int failoverCount = 0;
        Vector nameNotFoundContextList = new Vector();
        while (true) {
            try {
                if (logger.isLoggable(JeusMessage_JNDI._64_LEVEL)) {
                    logger.log(JeusMessage_JNDI._64_LEVEL, JeusMessage_JNDI._64, new Object[]{name, this.context.env.get("java.naming.provider.url")});
                }
                return this.context.lookup(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationExceptionForLookup(ne, nameNotFoundContextList, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void bind(Name name, Object obj) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.bind(name, obj);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void bind(String name, Object obj) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.bind(name, obj);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void rebind(Name name, Object obj) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.rebind(name, obj);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void rebind(String name, Object obj) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.rebind(name, obj);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void unbind(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.unbind(name);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void unbind(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.unbind(name);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void rename(Name oldName, Name newName) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.rename(oldName, newName);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void rename(String oldName, String newName) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.rename(oldName, newName);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration list(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.list(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration list(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.list(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration listBindings(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.listBindings(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration listBindings(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.listBindings(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void destroySubcontext(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.destroySubcontext(name);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void destroySubcontext(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.destroySubcontext(name);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized Context createSubcontext(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.createSubcontext(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized Context createSubcontext(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.createSubcontext(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized Object lookupLink(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.lookupLink(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized Object lookupLink(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.lookupLink(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NameParser getNameParser(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.getNameParser(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NameParser getNameParser(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.getNameParser(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized Name composeName(Name name, Name prefix) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.composeName(name, prefix);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized String composeName(String name, String prefix) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.composeName(name, prefix);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized Object addToEnvironment(String propName, Object propVal) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.addToEnvironment(propName, propVal);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized Object removeFromEnvironment(String propName) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.removeFromEnvironment(propName);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized Hashtable getEnvironment() throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.getEnvironment();
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void close() throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.close();
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized String getNameInNamespace() throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.getNameInNamespace();
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized Attributes getAttributes(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.getAttributes(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized Attributes getAttributes(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.getAttributes(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.getAttributes(name, attrIds);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.getAttributes(name, attrIds);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.modifyAttributes(name, mod_op, attrs);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.modifyAttributes(name, mod_op, attrs);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.modifyAttributes(name, mods);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.modifyAttributes(name, mods);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.bind(name, obj, attrs);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void bind(String name, Object obj, Attributes attrs) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.bind(name, obj, attrs);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.rebind(name, obj, attrs);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.rebind(name, obj, attrs);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.createSubcontext(name, attrs);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.createSubcontext(name, attrs);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized DirContext getSchema(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.getSchema(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized DirContext getSchema(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.getSchema(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized DirContext getSchemaClassDefinition(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.getSchemaClassDefinition(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized DirContext getSchemaClassDefinition(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.getSchemaClassDefinition(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.search(name, matchingAttributes, attributesToReturn);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.search(name, matchingAttributes, attributesToReturn);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.search(name, matchingAttributes);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.search(name, matchingAttributes);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.search(name, filter, cons);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.search(name, filter, cons);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.search(name, filterExpr, filterArgs, cons);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.search(name, filterExpr, filterArgs, cons);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void addNamingListener(Name target, int scope, NamingListener l) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.addNamingListener(target, scope, l);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void addNamingListener(String target, int scope, NamingListener l) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.addNamingListener(target, scope, l);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void removeNamingListener(NamingListener l) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.removeNamingListener(l);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized boolean targetMustExist() throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.targetMustExist();
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void addNamingListener(Name target, String filter, SearchControls ctls, NamingListener l) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.addNamingListener(target, filter, ctls, l);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void addNamingListener(String target, String filter, SearchControls ctls, NamingListener l) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.addNamingListener(target, filter, ctls, l);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void addNamingListener(Name target, String filter, Object[] filterArgs, SearchControls ctls, NamingListener l) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.addNamingListener(target, filter, filterArgs, ctls, l);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized void addNamingListener(String target, String filter, Object[] filterArgs, SearchControls ctls, NamingListener l) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.context.addNamingListener(target, filter, filterArgs, ctls, l);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized Reference getReference() throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.context.getReference();
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public void removeCache(String name) {
        this.context.removeCache(name);
    }
}

