/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.server;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import jeus.descriptor.jeusserver.JNDIServerDescriptor;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.jndi.io.JndiContentHandlerCreator;
import jeus.jndi.jns.common.JNS;
import jeus.jndi.jns.common.Message;
import jeus.jndi.jns.common.NamingServerException;
import jeus.jndi.jns.server.DirService;
import jeus.jndi.jns.server.SendDirectBindingsHandler;
import jeus.jndi.jns.server.ServiceHandler;
import jeus.jndi.jns.server.repository.ListenerProxy;
import jeus.net.AcceptorConnectionListener;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.JeusSSLConfiguration;
import jeus.net.ManagerEndpoint;
import jeus.net.NetworkControlPacket;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.impl.NodeInfo;
import jeus.server.JeusServer;
import jeus.server.manager.JeusVersion;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusPort;
import jeus.util.PooledExecutorFactory;
import jeus.util.concurrent50.concurrent.ThreadPoolExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JNSServer;
import jeus.util.properties.JeusJNDIProperties;
import jeus.util.properties.JeusNetPropertyValues;

public class JNSServer
extends JNS
implements ConnectionListenerFactory,
AcceptorConnectionListener {
    private static final String THREAD_NAME_PREFIX = "JNSServer";
    private static int port = JeusPort.JeusBase;
    private int threadPoolMinSize = 10;
    private int threadPoolMaxSize = 20;
    private long threadPoolResizePeriod = 60000L;
    private boolean exportCosnaming = false;
    private Process cosnaming;
    private static DirService dirService;
    private static ThreadPoolExecutor pooledExecutor;
    private static final JeusLogger logger;
    private static ManagerEndpoint endpoint;
    private boolean isNonblocking;
    private Set clusterInfoTable;

    public JNSServer(JNDIServerDescriptor desc, ObjectName parent) {
        if (logger.isLoggable(JeusMessage_JNSServer._1_LEVEL)) {
            logger.log(JeusMessage_JNSServer._1_LEVEL, JeusMessage_JNSServer._1, (Object)JeusVersion.getVersion());
        }
        if (logger.isLoggable(JeusMessage_JNSServer._2_LEVEL)) {
            logger.log(JeusMessage_JNSServer._2_LEVEL, JeusMessage_JNSServer._2);
        }
        if (logger.isLoggable(JeusMessage_JNSServer._200_LEVEL)) {
            logger.log(JeusMessage_JNSServer._200_LEVEL, JeusMessage_JNSServer._200);
        }
        this.exportCosnaming = desc.getExportCosNaming();
        this.threadPoolMinSize = desc.getServerPoolMin();
        this.threadPoolMaxSize = desc.getServerPoolMax();
        this.threadPoolResizePeriod = desc.getServerPoolPeriod();
        this.isNonblocking = desc.isNonBlocking();
        if (logger.isLoggable(JeusMessage_JNSServer._201_LEVEL)) {
            logger.log(JeusMessage_JNSServer._201_LEVEL, JeusMessage_JNSServer._201);
        }
        this.clusterInfoTable = new HashSet();
        Enumeration e = JeusServer.clusterInfo.getNodes();
        while (e.hasMoreElements()) {
            NodeInfo nodeInfo = (NodeInfo)e.nextElement();
            if (nodeInfo.isSameHostPort(JeusServer.clusterInfo.getLocalNode()) || nodeInfo.getHost().equals("127.0.0.1")) continue;
            try {
                this.clusterInfoTable.add(JeusNetPropertyValues.getByName((String)nodeInfo.getHost()).getHostAddress() + ":" + nodeInfo.getBasePort());
            }
            catch (Throwable t) {}
        }
        if (logger.isLoggable(JeusMessage_JNSServer._5_LEVEL)) {
            logger.log(JeusMessage_JNSServer._5_LEVEL, JeusMessage_JNSServer._5);
        }
        if (logger.isLoggable(JeusMessage_JNSServer._180_LEVEL)) {
            logger.log(JeusMessage_JNSServer._180_LEVEL, JeusMessage_JNSServer._180, (Object)String.valueOf(port));
        }
        if (logger.isLoggable(JeusMessage_JNSServer._181_LEVEL)) {
            logger.log(JeusMessage_JNSServer._181_LEVEL, JeusMessage_JNSServer._181, (Object)String.valueOf(this.exportCosnaming));
        }
        if (logger.isLoggable(JeusMessage_JNSServer._186_LEVEL)) {
            logger.log(JeusMessage_JNSServer._186_LEVEL, JeusMessage_JNSServer._186, (Object)String.valueOf(this.threadPoolMinSize));
        }
        if (logger.isLoggable(JeusMessage_JNSServer._187_LEVEL)) {
            logger.log(JeusMessage_JNSServer._187_LEVEL, JeusMessage_JNSServer._187, (Object)String.valueOf(this.threadPoolMaxSize));
        }
        if (logger.isLoggable(JeusMessage_JNSServer._189_LEVEL)) {
            logger.log(JeusMessage_JNSServer._189_LEVEL, JeusMessage_JNSServer._189, (Object)String.valueOf(this.threadPoolResizePeriod));
        }
        if (logger.isLoggable(JeusMessage_JNSServer._9_LEVEL)) {
            logger.log(JeusMessage_JNSServer._9_LEVEL, JeusMessage_JNSServer._9);
        }
    }

    public void export() throws IOException, InstanceAlreadyExistsException {
        SSLContext sslContext;
        NodeInfo nodeInfo;
        if (logger.isLoggable(JeusMessage_JNSServer._10_LEVEL)) {
            logger.log(JeusMessage_JNSServer._10_LEVEL, JeusMessage_JNSServer._10);
        }
        if (logger.isLoggable(JeusMessage_JNSServer._11_LEVEL)) {
            logger.log(JeusMessage_JNSServer._11_LEVEL, JeusMessage_JNSServer._11);
        }
        pooledExecutor = (ThreadPoolExecutor)PooledExecutorFactory.createPooledExecutor((String)THREAD_NAME_PREFIX, (int)this.threadPoolMaxSize, (int)this.threadPoolMinSize, (long)this.threadPoolResizePeriod);
        if (logger.isLoggable(JeusMessage_JNSServer._12_LEVEL)) {
            logger.log(JeusMessage_JNSServer._12_LEVEL, JeusMessage_JNSServer._12, (Object)pooledExecutor);
        }
        if (JeusJNDIProperties.USE_SSL) {
            nodeInfo = JeusServer.clusterInfo.getLocalNode(JeusPort.JNDI_SSL, 0);
            sslContext = JeusSSLConfiguration.sslContext;
        } else {
            nodeInfo = JeusServer.clusterInfo.getLocalNode(THREAD_NAME_PREFIX, 0);
            sslContext = null;
        }
        endpoint = new ManagerEndpoint(THREAD_NAME_PREFIX, this.isNonblocking, (SocketID)nodeInfo, (StreamContentHandlerCreator)new JndiContentHandlerCreator(), this, sslContext, null);
        endpoint.export();
        if (logger.isLoggable(JeusMessage_JNSServer._13_LEVEL)) {
            logger.log(JeusMessage_JNSServer._13_LEVEL, JeusMessage_JNSServer._13);
        }
        dirService = new DirService();
        if (logger.isLoggable(JeusMessage_JNSServer._14_LEVEL)) {
            logger.log(JeusMessage_JNSServer._14_LEVEL, JeusMessage_JNSServer._14, (Object)dirService);
        }
        if (this.exportCosnaming) {
            this.exportCosNaming();
        }
        if (logger.isLoggable(JeusMessage_JNSServer._22_LEVEL)) {
            logger.log(JeusMessage_JNSServer._22_LEVEL, JeusMessage_JNSServer._22);
        }
    }

    public void unexport() throws NamingServerException {
        if (logger.isLoggable(JeusMessage_JNSServer._23_LEVEL)) {
            logger.log(JeusMessage_JNSServer._23_LEVEL, JeusMessage_JNSServer._23);
        }
        dirService.destroy();
        dirService = null;
        if (logger.isLoggable(JeusMessage_JNSServer._27_LEVEL)) {
            logger.log(JeusMessage_JNSServer._27_LEVEL, JeusMessage_JNSServer._27);
        }
        endpoint.unexport();
        if (logger.isLoggable(JeusMessage_JNSServer._228_LEVEL)) {
            logger.log(JeusMessage_JNSServer._228_LEVEL, JeusMessage_JNSServer._228);
        }
        pooledExecutor.shutdownNow();
        if (logger.isLoggable(JeusMessage_JNSServer._28_LEVEL)) {
            logger.log(JeusMessage_JNSServer._28_LEVEL, JeusMessage_JNSServer._28);
        }
        if (this.exportCosnaming) {
            this.cosnaming.destroy();
            if (logger.isLoggable(JeusMessage_JNSServer._29_LEVEL)) {
                logger.log(JeusMessage_JNSServer._29_LEVEL, JeusMessage_JNSServer._29);
            }
        }
        if (logger.isLoggable(JeusMessage_JNSServer._30_LEVEL)) {
            logger.log(JeusMessage_JNSServer._30_LEVEL, JeusMessage_JNSServer._30);
        }
    }

    private void exportCosNaming() throws NamingServerException {
        if (logger.isLoggable(JeusMessage_JNSServer._33_LEVEL)) {
            logger.log(JeusMessage_JNSServer._33_LEVEL, JeusMessage_JNSServer._33);
        }
        if (logger.isLoggable(JeusMessage_JNSServer._34_LEVEL)) {
            logger.log(JeusMessage_JNSServer._34_LEVEL, JeusMessage_JNSServer._34, (Object)String.valueOf(JeusPort.TnameServ));
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            this.cosnaming = runtime.exec("tnameserv -ORBInitialPort " + JeusPort.TnameServ);
            boolean dead = false;
            byte[] errMsg = new byte[2048];
            BufferedInputStream outStream = new BufferedInputStream(this.cosnaming.getInputStream(), 2048);
            BufferedInputStream errStream = new BufferedInputStream(this.cosnaming.getErrorStream(), 2048);
            for (int i = 0; i < 3; ++i) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    try {
                        this.cosnaming.exitValue();
                        dead = true;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    int avail = errStream.available();
                    if (avail > 0 || dead) {
                        while (errStream.available() > 0) {
                            int len = errStream.read(errMsg, 0, avail);
                            if (!logger.isLoggable(JeusMessage_JNSServer._35_LEVEL)) continue;
                            logger.log(JeusMessage_JNSServer._35_LEVEL, JeusMessage_JNSServer._35, (Object)new String(errMsg, 0, len));
                        }
                        if (logger.isLoggable(JeusMessage_JNSServer._38_LEVEL)) {
                            logger.logp(JeusMessage_JNSServer._38_LEVEL, THREAD_NAME_PREFIX, "exportCosNaming", JeusMessage_JNSServer._38);
                        }
                        throw new NamingServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JNSServer._38));
                    }
                    avail = outStream.available();
                    if (avail <= 0) continue;
                    while (outStream.available() > 0) {
                        int len = outStream.read(errMsg, 0, avail);
                        if (!logger.isLoggable(JeusMessage_JNSServer._35_LEVEL)) continue;
                        logger.log(JeusMessage_JNSServer._35_LEVEL, JeusMessage_JNSServer._35, (Object)new String(errMsg, 0, len));
                    }
                    break;
                }
                catch (Exception ex) {
                    if (!logger.isLoggable(JeusMessage_JNSServer._36_LEVEL)) continue;
                    logger.log(JeusMessage_JNSServer._36_LEVEL, JeusMessage_JNSServer._36);
                }
            }
            if (logger.isLoggable(JeusMessage_JNSServer._37_LEVEL)) {
                logger.log(JeusMessage_JNSServer._37_LEVEL, JeusMessage_JNSServer._37);
            }
        }
        catch (Exception ex) {
            if (logger.isLoggable(JeusMessage_JNSServer._38_LEVEL)) {
                logger.log(JeusMessage_JNSServer._38_LEVEL, JeusMessage_JNSServer._38);
            }
            throw new NamingServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JNSServer._3) + ex);
        }
    }

    public static JeusLogger getLogger() {
        return logger;
    }

    public static DirService getDirService() {
        return dirService;
    }

    public static void addListener(ListenerProxy listener) {
        endpoint.addListener(listener);
    }

    public static void removeListener(SocketID socketID, String id) {
        endpoint.removeListener(socketID, id);
    }

    public static boolean broadcastToServers(Message request) {
        return endpoint.broadcast(0, null, request);
    }

    public static boolean broadcastToLocals(SocketStream sockStream, Message request) {
        return endpoint.broadcast(-1, sockStream, request);
    }

    public static SocketStream containsServerSocketStream(SocketID socketID) {
        return endpoint.getConnectionManager().getSocketStream(socketID);
    }

    public void runDelegatedTask(Runnable messageProcessor, boolean isReplyPacket, Object message) {
        if (isReplyPacket) {
            messageProcessor.run();
        } else {
            try {
                Message _msg = (Message)message;
                int opcode = _msg.getCode();
                if (opcode == 202 || opcode == 201 || opcode == 301) {
                    messageProcessor.run();
                    return;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            pooledExecutor.execute(messageProcessor);
        }
    }

    public Object getPiggybackData(int msgType, SocketStream sockStream, Object piggybackedData) {
        return piggybackedData;
    }

    public void writeDone(SocketStream sockStream) {
    }

    public void connectionEstablished(SocketStream sockStream) {
    }

    public void connectionAllowed(SocketStream sockStream, NetworkControlPacket packet, int connectionType, Object piggybackedData) throws IOException {
        if (connectionType == 0) {
            SocketID socketID = sockStream.getSocketID();
            String clusterInfo = JeusNetPropertyValues.getByName((String)socketID.getHost()).getHostAddress() + ":" + socketID.getBasePort();
            if (!this.clusterInfoTable.contains(clusterInfo)) {
                this.clusterInfoTable.add(clusterInfo);
            }
            sockStream.write((Object)packet);
            new SendDirectBindingsHandler(sockStream).run();
        } else if (connectionType == -1) {
            packet.setData((Object)new Object[]{new Integer(1), this.clusterInfoTable});
            sockStream.write((Object)packet);
        } else {
            throw new RuntimeException();
        }
    }

    public void connectionConnected(SocketStream sockStream) throws SocketException {
    }

    public void connectionAccepted(SocketStream sockStream, int connectionType, Object packet) {
        SocketID socketID = sockStream.getSocketID();
        try {
            String clusterInfo = JeusNetPropertyValues.getByName((String)socketID.getHost()).getHostAddress() + ":" + socketID.getBasePort();
            if (!this.clusterInfoTable.contains(clusterInfo)) {
                this.clusterInfoTable.add(clusterInfo);
            }
            new SendDirectBindingsHandler(sockStream).run();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public void connectionClosed(Exception exception, SocketStream socketStream) {
        if (exception != null && logger.isLoggable(JeusMessage_JNSServer._242_LEVEL)) {
            logger.log(JeusMessage_JNSServer._242_LEVEL, JeusMessage_JNSServer._242, (Throwable)exception);
        }
    }

    public ConnectionListener createConnectionListener(Socket socket, SocketID socketID) {
        return this;
    }

    public void receiveMessage(Object message, SocketStream socketStream, Object controlInfo) {
        Message msg = (Message)message;
        try {
            int msgType = msg.getType();
            if (msgType != 1 && msgType != 2) {
                throw new RuntimeException();
            }
            new ServiceHandler(socketStream, msg).handle();
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_JNSServer._91_LEVEL)) {
                logger.logp(JeusMessage_JNSServer._91_LEVEL, "NonBlockingReceiver", "handle", JeusMessage_JNSServer._91, (Object[])new String[]{socketStream.toString(), e.toString()}, (Throwable)e);
            }
            if (logger.isLoggable(JeusMessage_JNSServer._92_LEVEL)) {
                logger.logp(JeusMessage_JNSServer._92_LEVEL, "NonBlockingReceiver", "handle", JeusMessage_JNSServer._92, (Throwable)e);
            }
            try {
                socketStream.writeReply((Object)new Message(402, null, (Object)new NamingException("[JNSServer]" + e), null));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    static {
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jndi");
    }
}

