/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.server;

import java.util.List;
import javax.naming.directory.Attributes;
import jeus.jndi.jns.common.Environment;
import jeus.jndi.jns.common.Message;
import jeus.jndi.jns.server.DirService;
import jeus.jndi.jns.server.JNSServer;
import jeus.jndi.jns.server.ServiceHandler;
import jeus.net.SocketStream;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JNSServer;

class SendDirectBindingsHandler
implements Runnable {
    private SocketStream managerSocketStream;
    private static JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jndi.jns.server");

    public SendDirectBindingsHandler(SocketStream managerSocketStream) {
        this.managerSocketStream = managerSocketStream;
    }

    public void run() {
        Environment env = new Environment();
        DirService dirService = JNSServer.getDirService();
        if (logger.isLoggable(JeusMessage_JNSServer._52_LEVEL)) {
            logger.log(JeusMessage_JNSServer._52_LEVEL, JeusMessage_JNSServer._52);
        }
        List items = dirService.getReplicationItems();
        for (Object item1 : items) {
            Object[] item = (Object[])item1;
            String name = (String)item[0];
            Object obj = item[1];
            Environment bindEnv = (Environment)item[2];
            Attributes attrs = (Attributes)item[3];
            try {
                if (!ServiceHandler.isReplicateBinding(obj, bindEnv)) continue;
                env.fromInt(bindEnv.toInt());
                env.setForcedBind(true);
                env.setDirectBind(false);
                Message replicateRequest = new Message(301, env, (Object)name, obj);
                if (attrs != null) {
                    replicateRequest.put(5, attrs);
                }
                if (logger.isLoggable(JeusMessage_JNSServer._175_LEVEL)) {
                    logger.log(JeusMessage_JNSServer._175_LEVEL, JeusMessage_JNSServer._175, (Object)name);
                }
                if (this.managerSocketStream.isClosed()) {
                    return;
                }
                this.managerSocketStream.write((Object)replicateRequest);
            }
            catch (Exception ex) {
                if (!logger.isLoggable(JeusMessage_JNSServer._176_LEVEL)) continue;
                logger.logp(JeusMessage_JNSServer._176_LEVEL, "NonBlockingReceiver$SendDirectBindingsHandler", "run", JeusMessage_JNSServer._176, (Object)name, (Throwable)ex);
            }
        }
        if (logger.isLoggable(JeusMessage_JNSServer._55_LEVEL)) {
            logger.log(JeusMessage_JNSServer._55_LEVEL, JeusMessage_JNSServer._55);
        }
    }
}

