/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.server.repository;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import jeus.jndi.jns.common.Environment;
import jeus.jndi.jns.server.repository.Composite;
import jeus.jndi.jns.server.repository.ListenerProxy;
import jeus.jndi.jns.server.repository.SearchFilter;

public abstract class Node {
    private boolean existListener;
    private Hashtable listenerTable;
    Composite parent;
    String name;
    Object value;
    Environment env;
    Attributes attrs;

    protected Node(Composite _parent, String _name, Object _value, Environment _env, Attributes _attrs) {
        this.parent = _parent;
        this.name = _name;
        this.value = _value;
        this.env = _env;
        this.attrs = _attrs;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    public Composite getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String _name) {
        this.name = _name;
    }

    public Object getValue() {
        return this.value;
    }

    public Environment getEnv() {
        return this.env;
    }

    public Attributes getAttrs() {
        return this.attrs;
    }

    public Attribute getAttr(String _attrId) {
        return this.attrs.get(_attrId);
    }

    public Attributes acquireAttrs() {
        if (this.attrs == null) {
            this.attrs = new BasicAttributes();
        }
        return this.attrs;
    }

    public abstract boolean isComposite();

    public void setExistListener(boolean existListener) {
        this.existListener = existListener;
    }

    public static String getChildName(String _name) {
        int contextSeperatorIndex = _name.indexOf(47);
        if (contextSeperatorIndex == -1) {
            return _name;
        }
        return _name.substring(0, contextSeperatorIndex);
    }

    final String getSubName(String _name) {
        int contextSeperatorIndex = _name.indexOf(47);
        if (contextSeperatorIndex == -1) {
            return "";
        }
        return _name.substring(contextSeperatorIndex + 1);
    }

    final String getParentName(String _name) {
        int contextSeperatorIndex = _name.lastIndexOf(47);
        if (contextSeperatorIndex == -1) {
            return "";
        }
        return _name.substring(0, contextSeperatorIndex);
    }

    final String getName(String _name) {
        int contextSeperatorIndex = _name.lastIndexOf(47);
        if (contextSeperatorIndex == -1) {
            return _name;
        }
        return _name.substring(contextSeperatorIndex + 1);
    }

    public abstract Node find(String var1);

    public void remove() {
        if (this.parent != null) {
            this.parent.removeChild(this.name);
        }
    }

    public abstract List search(List var1, Attributes var2, String[] var3, int var4) throws Exception;

    public abstract List search(List var1, SearchFilter var2, SearchControls var3) throws Exception;

    public void addListener(ListenerProxy listener) {
        if (this.listenerTable == null) {
            this.listenerTable = new Hashtable();
        }
        this.listenerTable.put(listener.getID(), listener);
    }

    public void removeListener(ListenerProxy listener) {
        if (this.listenerTable == null) {
            return;
        }
        this.listenerTable.remove(listener.getID());
    }

    public void notify(int type, Binding newBd, Binding oldBd) throws Exception {
        if (!this.existListener) {
            return;
        }
        this.innerNotify(type, newBd, oldBd, this);
    }

    void innerNotify(int type, Binding newBd, Binding oldBd, Node node) throws Exception {
        if (this.listenerTable != null) {
            Enumeration e = this.listenerTable.elements();
            while (e.hasMoreElements()) {
                ListenerProxy listener = (ListenerProxy)e.nextElement();
                listener.notify(type, newBd, oldBd, node);
            }
        }
        if (this.parent != null) {
            this.parent.innerNotify(type, newBd, oldBd, node);
        }
    }

    public int distance(Node _node) throws Exception {
        return new CompositeName(_node.getName()).size() - new CompositeName(this.name).size();
    }

    public void print(String tab) {
        if (this.attrs == null) {
            return;
        }
        try {
            NamingEnumeration<? extends Attribute> ae = this.attrs.getAll();
            while (ae != null && ae.hasMoreElements()) {
                Attribute attr = ae.next();
                System.out.println(tab + "  attribute: " + attr.getID());
                NamingEnumeration<?> e = attr.getAll();
                while (e.hasMoreElements()) {
                    System.out.println(tab + "      value: " + e.nextElement());
                }
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }
}

