/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.url.jh;

import java.util.Hashtable;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.ServiceUnavailableException;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ResolveResult;
import jeus.jndi.JNSContext;
import jeus.jndi.jns.local.JNSLocal;

public class jhURLContext
implements Context {
    protected Hashtable myEnv;

    public jhURLContext(Hashtable env) {
        this.myEnv = env;
    }

    protected ResolveResult getRootURLContext(String url, Hashtable env) throws NamingException {
        if (!url.startsWith("jh:")) {
            throw new IllegalArgumentException("jhURLContext: name is not an Jeus Host URL: " + url);
        }
        String host = null;
        String objName = null;
        int i = 3;
        if (url.startsWith("//", i)) {
            int colon;
            int slash = url.indexOf(47, i += 2);
            if (slash < 0) {
                slash = url.length();
            }
            if ((colon = url.indexOf(58, i)) < 0 || colon > slash) {
                host = url.substring(i, slash);
                env.put("java.naming.provider.url", host);
            } else {
                host = url.substring(i, colon);
                int port = Integer.parseInt(url.substring(colon + 1, slash).trim());
                env.put("java.naming.provider.url", host + ":" + port);
            }
            i = slash;
        }
        if ("".equals(host)) {
            host = null;
        }
        if (url.startsWith("/", i)) {
            ++i;
        }
        if (i < url.length()) {
            objName = url.substring(i);
        }
        CompositeName remaining = new CompositeName();
        if (objName != null) {
            remaining.add(objName);
        }
        try {
            JNSContext ctx = new JNSContext(JNSLocal.getLocalServer(env), env, "");
            return new ResolveResult((Object)ctx, remaining);
        }
        catch (Exception e) {
            throw new ServiceUnavailableException("Naming Server is not avail.");
        }
    }

    protected Context getContinuationContext(Name n) throws NamingException {
        Object obj = this.lookup(n.get(0));
        CannotProceedException cpe = new CannotProceedException();
        cpe.setResolvedObj(obj);
        cpe.setEnvironment(this.myEnv);
        return NamingManager.getContinuationContext(cpe);
    }

    public Object lookup(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        Context ctx = (Context)res.getResolvedObj();
        Name nm = res.getRemainingName();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nm.size(); ++i) {
            sb.append(nm.get(i));
            sb.append("/");
        }
        return ctx.lookup(sb.toString());
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        Context ctx = (Context)res.getResolvedObj();
        Name nm = res.getRemainingName();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nm.size(); ++i) {
            sb.append(nm.get(i));
            sb.append("/");
        }
        ctx.bind(sb.toString(), obj);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        Context ctx = (Context)res.getResolvedObj();
        Name nm = res.getRemainingName();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nm.size(); ++i) {
            sb.append(nm.get(i));
            sb.append("/");
        }
        ctx.rebind(sb.toString(), obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void unbind(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        Context ctx = (Context)res.getResolvedObj();
        Name nm = res.getRemainingName();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nm.size(); ++i) {
            sb.append(nm.get(i));
            sb.append("/");
        }
        ctx.unbind(sb.toString());
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(Name name, Name newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        Context ctx = (Context)res.getResolvedObj();
        Name nm = res.getRemainingName();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nm.size(); ++i) {
            sb.append(nm.get(i));
            sb.append("/");
        }
        return ctx.list(sb.toString());
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.list(name.get(0));
        }
        Context ctx = this.getContinuationContext(name);
        return ctx.list(name.getSuffix(1));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        Context ctx = (Context)res.getResolvedObj();
        Name nm = res.getRemainingName();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nm.size(); ++i) {
            sb.append(nm.get(i));
            sb.append("/");
        }
        return ctx.listBindings(sb.toString());
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.listBindings(name.get(0));
        }
        Context ctx = this.getContinuationContext(name);
        return ctx.listBindings(name.getSuffix(1));
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        Context ctx = (Context)res.getResolvedObj();
        Name nm = res.getRemainingName();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nm.size(); ++i) {
            sb.append(nm.get(i));
            sb.append("/");
        }
        return ctx.lookupLink(sb.toString());
    }

    public Object lookupLink(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.lookupLink(name.get(0));
        }
        Context ctx = this.getContinuationContext(name);
        return ctx.lookupLink(name.getSuffix(1));
    }

    public NameParser getNameParser(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        Context ctx = (Context)res.getResolvedObj();
        Name nm = res.getRemainingName();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nm.size(); ++i) {
            sb.append(nm.get(i));
            sb.append("/");
        }
        return ctx.getNameParser(sb.toString());
    }

    public NameParser getNameParser(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.getNameParser(name.get(0));
        }
        Context ctx = this.getContinuationContext(name);
        return ctx.getNameParser(name.getSuffix(1));
    }

    public String composeName(String name, String prefix) throws NamingException {
        if (prefix.equals("")) {
            return name;
        }
        if (name.equals("")) {
            return prefix;
        }
        return prefix + "/" + name;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        this.myEnv = this.myEnv == null ? new Hashtable(11, 0.75f) : this.myEnv;
        return this.myEnv.put(propName, propVal);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            return new Hashtable(5, 0.75f);
        }
        return (Hashtable)this.myEnv.clone();
    }

    public void close() throws NamingException {
    }
}

