/*
 * Decompiled with CFR 0.152.
 */
package jeus.loganalyzer.common;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.HashMap;
import jeus.loganalyzer.common.StorageEntry;
import jeus.loganalyzer.util.LogAnalyzerException;

public abstract class FileStorageBase
implements Serializable {
    protected String fileDBPath;
    protected String fileDBName;
    protected String fileDir;
    protected String fileName;
    protected HashMap fpTable;
    protected HashMap logDataTable;
    protected transient RandomAccessFile DBfile;
    protected StorageEntry entry;
    File file1;
    protected int totalLen;
    protected int KEY_SIZE;
    protected int BODY_SIZE;
    protected long totalHits;

    public FileStorageBase() {
        this.initializeHeaderInfo();
    }

    abstract void initializeHeaderInfo();

    protected void makeDBFile() throws LogAnalyzerException {
        try {
            this.fileName = this.fileDBName + ".fdb";
            this.fileDir = this.fileDBPath + File.separator + this.fileName;
            this.file1 = new File(this.fileDir);
            if (this.file1.getParent() != null) {
                new File(this.file1.getParent()).mkdirs();
            }
            this.DBfile = new RandomAccessFile(this.file1, "rw");
            this.DBfile.seek(this.DBfile.length());
        }
        catch (IOException e) {
            throw new LogAnalyzerException(5500, "fail to create .fdb file", (Throwable)e);
        }
    }

    abstract void store(String var1, long var2, long var4, long var6) throws IOException;

    abstract void update(String var1, long var2, long var4) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws Exception {
        Object sync;
        Object object = sync = new Object();
        synchronized (object) {
            if (this.fpTable != null) {
                this.fpTable.clear();
            }
            if (this.logDataTable != null) {
                this.logDataTable.clear();
            }
            this.fileDBPath = null;
            this.fileDBName = null;
            this.fpTable = null;
            this.logDataTable = null;
            this.entry = null;
            try {
                if (this.DBfile != null) {
                    this.DBfile.close();
                }
            }
            catch (Throwable ex) {
                throw new Exception("fail to clear()", ex);
            }
            this.file1 = null;
        }
    }
}

