/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.security.Permission;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import jeus.ejb.BeanContainer;
import jeus.ejb.EJBServerUtils;
import jeus.management.JMXUtility;
import jeus.management.j2ee.EJBMBean;
import jeus.management.j2ee.EJBModuleMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.monitor.DataProvider;
import jeus.management.j2ee.monitor.MonitorHandler;
import jeus.management.j2ee.statistics.EJBStatsImpl;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.management.j2ee.statistics.StatisticListener;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;

public abstract class EJB
extends J2EEManagedObjectSupport
implements EJBMBean {
    private DataProvider threadPoolProvider = new DataProvider(){

        public Object getMonitorValue() {
            return new Float(EJB.this.container.getActiveThreadRatio());
        }

        public String getFatalCause(MonitorHandler handler) {
            return "The number of active threads in the EJB " + EJB.this.myObjectName + " exceeds the fatal ratio, active thread ratio : " + handler.getObservedValue();
        }

        public String getWarningCause(MonitorHandler handler) {
            return "The number of active threads in the EJB " + EJB.this.myObjectName + " exceeds the warning ratio, active thread ratio : " + handler.getObservedValue();
        }
    };
    protected EJBStatsImpl stat;
    protected BeanContainer container;
    private StatisticListener statListener;
    private Permission getRemoteJndiNamePermission;
    private Permission getLocalJndiNamePermission;

    public EJB(ObjectName parent, Object _target) {
        super(parent);
        this.container = (BeanContainer)_target;
    }

    protected String initPermissionName() {
        EJBModuleMBean module = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, EJBModuleMBean.class, false);
        String name = module.getPermissionName();
        name = name + ".bean." + this.myNameString;
        return name;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.getRemoteJndiNamePermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getRemoteJndiName");
        this.getLocalJndiNamePermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getLocalJndiName");
    }

    public void setStatistic(StatisticImpl statistic) {
        this.stat.setStatistic((Statistic)statistic);
    }

    public Stats getstats() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        if (this.statListener != null) {
            this.statListener.beforeStatistic();
        }
        return this.stat;
    }

    public void setStatisticListener(StatisticListener listener) {
        this.statListener = listener;
    }

    public void refreshMonitoring() {
        List monitorList = null;
        monitorList = this.addHandler(monitorList, "thread-max-warning-ratio", "thread-max-fatal-ratio", this.threadPoolProvider);
        this.setMonitorList(monitorList);
    }

    public boolean isWebserviceConsumer() {
        return this.container.isWebserviceConsumer();
    }

    public String getRemoteJndiName() {
        LoginUtil.checkPermissionWithRuntimeException(this.getRemoteJndiNamePermission);
        if (this.container.getBeanInfo().hasRemoteView()) {
            return EJBServerUtils.getRemoteViewJndiName(this.container.getBeanInfo());
        }
        return null;
    }

    public String getLocalJndiName() {
        LoginUtil.checkPermissionWithRuntimeException(this.getLocalJndiNamePermission);
        if (this.container.getBeanInfo().hasLocalView()) {
            return EJBServerUtils.getLocalViewJndiName(this.container.getBeanInfo());
        }
        return null;
    }
}

