/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.security.Permission;
import javax.management.ObjectName;
import javax.persistence.EntityManager;
import jeus.container.ExecutionModule;
import jeus.container.namingenv.EnvUtil;
import jeus.ejb.EJBServerUtils;
import jeus.management.j2ee.EJBModule;
import jeus.management.j2ee.J2EEApplication;
import jeus.management.j2ee.J2EEDeployedObject;
import jeus.management.j2ee.J2EEModuleMBean;
import jeus.persistence.container.PersistenceUnit;
import jeus.persistence.container.PersistenceUnitNotFoundException;
import jeus.persistence.container.PersistenceUnits;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.util.StringUtil;
import jeus.xml.binding.j2ee.ServiceRefType;
import jeus.xml.binding.jeusDD.ServiceClientType;

public abstract class J2EEModule
extends J2EEDeployedObject
implements J2EEModuleMBean,
ExecutionModule {
    static final String APP_MODULE_SEPARATOR = "#";
    protected String deployType;
    protected String appModuleName;
    private ResourcePermission getjavaVMsPermission;
    protected J2EEApplication application;
    protected String path;
    protected String moduleUri;
    private boolean isStandAloneModule = true;

    protected void postCreation(boolean pRegistrationDone) throws Exception {
        super.postCreation(pRegistrationDone);
        if (pRegistrationDone) {
            this.getjavaVMsPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getjavaVMs");
        }
    }

    public String getUniqueModuleName() {
        if (this.appModuleName == null) {
            return this.appName;
        }
        return this.appName + APP_MODULE_SEPARATOR + this.appModuleName;
    }

    public String getAppModuleName() {
        if (this.appModuleName == null) {
            return this.appName;
        }
        return this.appModuleName;
    }

    public J2EEModule(ObjectName parent) {
        super(parent);
    }

    public String[] getjavaVMs() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.getjavaVMsPermission);
        return (String[])this.mbs.getAttribute(this.serverObjectName, "javaVMs");
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setDeployType(String deployTypeComponent) {
        this.deployType = deployTypeComponent;
    }

    public String getPath() {
        return this.path;
    }

    public void setAppModuleName(String s) {
        this.appModuleName = s;
    }

    public abstract void setComponentType(Object var1);

    public abstract Object getComponentType();

    public boolean isStandAloneModule() {
        return this.isStandAloneModule;
    }

    public J2EEApplication getApplication() {
        return this.application;
    }

    public void setApplication(J2EEApplication app) {
        this.application = app;
        this.isStandAloneModule = false;
    }

    public String getModuleUri() {
        return this.moduleUri;
    }

    public void setModuleUri(String moduleUri) {
        this.moduleUri = moduleUri;
    }

    public PersistenceUnit lookupPersistenceUnit(String qualifiedUnitName) throws PersistenceUnitNotFoundException {
        PersistenceUnit pu;
        String[] str = EnvUtil.getUriAndName(qualifiedUnitName);
        String puUri = str[0];
        String unitName = str[1];
        if (!puUri.equals("")) {
            if (this.application == null) {
                throw new PersistenceUnitNotFoundException("standalone module cannot use absolute URI pathname.");
            }
            try {
                puUri = EnvUtil.getCanonicalPath(this.moduleUri, puUri);
            }
            catch (IllegalArgumentException e) {
                throw new PersistenceUnitNotFoundException();
            }
            PersistenceUnits pus = this.application.getPersistenceUnits(puUri);
            if (pus == null) {
                throw new PersistenceUnitNotFoundException();
            }
            PersistenceUnit pu2 = pus.getPersistenceUnit(unitName);
            if (pu2 == null) {
                throw new PersistenceUnitNotFoundException();
            }
            return pu2;
        }
        if (this.isPersistenceUnitDeclared() && (pu = this.getPersistenceUnit(unitName)) != null) {
            return pu;
        }
        J2EEApplication app = this.getApplication();
        if (app != null && app.isPersistenceUnitDeclared() && (pu = app.getPersistenceUnit(unitName)) != null) {
            return pu;
        }
        throw new PersistenceUnitNotFoundException();
    }

    public PersistenceUnit lookupPersistenceUnit(String puUri, String unitName) {
        PersistenceUnits pus;
        J2EEApplication app;
        PersistenceUnit pu = null;
        if (this.isPersistenceUnitDeclared()) {
            PersistenceUnits pus2 = this.getPersistenceUnits(puUri);
            if (pus2 != null) {
                pu = pus2.getPersistenceUnit(unitName);
            }
            if (pu != null) {
                return pu;
            }
        }
        if ((app = this.getApplication()) != null && app.isPersistenceUnitDeclared() && (pus = app.getPersistenceUnits(puUri)) != null) {
            pu = pus.getPersistenceUnit(unitName);
        }
        return pu;
    }

    public EntityManager getCurrentExtendedPersistenceContext(PersistenceUnit pu) {
        return EJBServerUtils.getCurrentExtendedPersistenceContext(pu);
    }

    public J2EEModule getSiblingModule(String relativeModuleUri) {
        if (relativeModuleUri.equals("")) {
            return this;
        }
        if (this.application != null) {
            String uri = EnvUtil.getCanonicalPath(this.moduleUri, relativeModuleUri);
            return this.application.getModule(uri);
        }
        return null;
    }

    public String getEJBJndiName(String ejblink, String beanInterface, Boolean isRemote) {
        String jndiName;
        String beanName = "";
        if (!StringUtil.isNullOrEmpty((String)ejblink)) {
            J2EEModule refModule;
            String[] str = EnvUtil.getUriAndName(ejblink);
            String moduleUri = str[0];
            beanName = str[1];
            if (!moduleUri.equals("") && (refModule = this.getSiblingModule(moduleUri)) != null && refModule instanceof EJBModule) {
                return ((EJBModule)refModule).getBeanJndiName(beanName, beanInterface, isRemote);
            }
        }
        if (this instanceof EJBModule && (jndiName = ((EJBModule)this).getBeanJndiName(beanName, beanInterface, isRemote)) != null) {
            return jndiName;
        }
        if (this.application != null) {
            EJBModule[] modules;
            for (EJBModule module : modules = this.application.getEJBModules()) {
                jndiName = module.getBeanJndiName(beanName, beanInterface, isRemote);
                if (jndiName == null) continue;
                return jndiName;
            }
        }
        return null;
    }

    public String getMessageDestinationJndiNameWithLink(String msgDestLink) {
        if (msgDestLink != null) {
            String[] str = EnvUtil.getUriAndName(msgDestLink);
            String moduleUri = str[0];
            String destName = str[1];
            if (!moduleUri.equals("")) {
                J2EEModule refModule = this.getSiblingModule(moduleUri);
                if (refModule != null && refModule instanceof EJBModule) {
                    return ((EJBModule)refModule).getMessageDestinationJndiName(destName);
                }
            } else {
                String jndiName = null;
                if (this instanceof EJBModule && (jndiName = ((EJBModule)this).getMessageDestinationJndiName(destName)) != null) {
                    return jndiName;
                }
                if (this.application != null) {
                    EJBModule[] modules;
                    for (EJBModule module : modules = this.application.getEJBModules()) {
                        jndiName = module.getMessageDestinationJndiName(destName);
                        if (jndiName == null) continue;
                        return jndiName;
                    }
                }
            }
        }
        return null;
    }

    public void processPortComponentlink(ServiceClientType serviceClientType, ServiceRefType serviceRefType) {
    }

    public void setStandAloneModule(boolean b) {
        this.isStandAloneModule = b;
    }

    public boolean isApplication() {
        return this.application != null;
    }
}

