/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.security.Permission;
import java.util.Hashtable;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionFactory;
import jeus.connector.CMInfo;
import jeus.connector.ManagedConnectionPool;
import jeus.management.JMXManagerException;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.JCAConnectionFactoryMBean;
import jeus.management.j2ee.JCAManagedConnectionFactory;
import jeus.management.j2ee.statistics.JCAConnectionPoolStatsImpl;
import jeus.management.j2ee.statistics.JCAStatsImpl;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.transaction.RecoveryThread;
import jeus.transaction.logging.ConnectorXAResourceFactory;
import jeus.util.message.JeusMessage_JCA1;

public class JCAConnectionFactory
extends J2EEManagedObjectSupport
implements JCAConnectionFactoryMBean {
    protected static final String[] childTypes = new String[]{"JCAManagedConnectionFactory"};
    private Object connectionFactory;
    private ManagedConnectionPool managedConnectionPool;
    private JCAConnectionPoolStatsImpl poolStats;
    private String exportName;
    private ObjectName jcaManagedConnectionFactoryName;
    private JCAManagedConnectionFactory jcaManagedConnectionFactory;
    private ResourcePermission poolControlPermission;

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target) {
        try {
            JCAConnectionFactory object = new JCAConnectionFactory(mBeanName, parent, target);
            return object.createMBean(mBeanName, "JCAConnectionFactory", parent, JCAConnectionFactoryMBean.parentKeyMap, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JCAConnectionFactory(String mBeanName, ObjectName parent, Object target) {
        super(parent);
        this.exportName = mBeanName;
        this.managedConnectionPool = (ManagedConnectionPool)target;
    }

    protected String initPermissionName() throws JMXManagerException {
        J2EEManagedObjectMBean parent = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return parent.getPermissionName() + "." + "connection_factory" + "." + this.myNameString;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.poolControlPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"poolControlPermision");
    }

    public void addChild(ObjectName pChild) {
        LoginService.checkCodeSubject();
        if (this.jcaManagedConnectionFactoryName == null) {
            this.jcaManagedConnectionFactoryName = pChild;
            this.poolStats.setManagedConnectionFactoryName(pChild.getCanonicalName());
            super.addChild(pChild);
        }
    }

    public void removeChild(ObjectName pChild) {
        LoginService.checkCodeSubject();
        if (this.jcaManagedConnectionFactoryName.equals(pChild)) {
            this.jcaManagedConnectionFactoryName = null;
            this.poolStats.setManagedConnectionFactoryName(null);
            super.removeChild(pChild);
        }
    }

    public void deploy() {
        this.jcaManagedConnectionFactory = (JCAManagedConnectionFactory)JCAManagedConnectionFactory.createMBean(this.exportName, this.myObjectName, this.managedConnectionPool.getManagedConnectionFactory());
        this.jcaManagedConnectionFactory.deploy();
    }

    public void undeploy() throws ResourceException {
        try {
            this.managedConnectionPool.destroy();
            this.jcaManagedConnectionFactory.undeploy();
        }
        catch (Throwable t) {
            throw new ResourceException(t);
        }
        finally {
            this.jcaManagedConnectionFactory = null;
            this.destroyMBean();
        }
    }

    void initStatsMonitor(JCAStatsImpl jcaStats) {
        this.poolStats = new JCAConnectionPoolStatsImpl(this.myName);
        this.managedConnectionPool.getPoolStats().initStatsMonitor(this.poolStats);
        jcaStats.addStats(this.poolStats);
    }

    public void preStart() {
        Referenceable connectionFactory = (Referenceable)this.connectionFactory;
        try {
            Hashtable<String, String> envs = new Hashtable<String, String>();
            envs.put("jeus.jndi.jns.replicatebindings", "false");
            envs.put("jeus.jndi.jns.forcedbindings", "true");
            InitialContext ctx = new InitialContext(envs);
            if (logger.isLoggable(JeusMessage_JCA1._1981)) {
                logger.log(JeusMessage_JCA1._1981_LEVEL, JeusMessage_JCA1._1981, (Object)this.exportName);
            }
            ctx.rebind(this.exportName, (Object)connectionFactory.getReference());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.managedConnectionPool.setEnabled();
    }

    public void preStop() {
        String export = this.myObjectName.getKeyProperty("name");
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(export);
            if (logger.isLoggable(JeusMessage_JCA1._1981_LEVEL)) {
                logger.log(JeusMessage_JCA1._1981_LEVEL, JeusMessage_JCA1._1981, (Object)export);
            }
        }
        catch (NamingException ne) {
            ne.printStackTrace();
        }
        this.managedConnectionPool.setDisabled();
    }

    public void setConnectionFactory(Object connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ManagedConnectionPool getConnectionPool() {
        return this.managedConnectionPool;
    }

    public void resyncCM(Reference ref) {
        if (ref != null && this.managedConnectionPool != null) {
            new RecoveryThread(new ConnectorXAResourceFactory(ref)).start();
        }
    }

    public boolean isWorking() {
        if (this.managedConnectionPool == null) {
            return false;
        }
        return this.managedConnectionPool.getPoolInfo().isWorking();
    }

    public void enableCM() {
        if (this.managedConnectionPool != null) {
            this.managedConnectionPool.setEnabled();
        }
    }

    public void disableCM() {
        if (this.managedConnectionPool != null) {
            this.managedConnectionPool.setDisabled();
        }
    }

    public void destroy() {
        if (this.managedConnectionPool != null) {
            this.managedConnectionPool.destroy();
        }
    }

    public void shrinkCM() {
        if (this.managedConnectionPool != null) {
            this.managedConnectionPool.shrink();
        }
    }

    public void invalidateCM() {
        if (this.managedConnectionPool != null) {
            this.managedConnectionPool.invalidate();
        }
    }

    public void dissociateCM() {
        if (this.managedConnectionPool != null) {
            this.managedConnectionPool.dissociate();
        }
    }

    public Stats getstats() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.poolStats;
    }

    public int getmin() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.managedConnectionPool.getPoolInfo().getMin();
    }

    public void setmin(int min) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.poolControlPermission);
        this.managedConnectionPool.getPoolInfo().setMin(min);
    }

    public int getmax() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.managedConnectionPool.getPoolInfo().getMax();
    }

    public int getmaxWaiter() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.managedConnectionPool.getPoolInfo().getMaxWaiter();
    }

    public void setmaxWaiter(int maxWaiter) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.poolControlPermission);
        this.managedConnectionPool.getPoolInfo().setMaxWaiter(maxWaiter);
    }

    public int getmaxDisposableCount() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.managedConnectionPool.getPoolInfo().getMaxDisposableCount();
    }

    public void setmaxDisposableCount(int maxDisposableCount) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.poolControlPermission);
        this.managedConnectionPool.getPoolInfo().setMaxDisposableCount(maxDisposableCount);
    }

    public int getwaitTrial() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.managedConnectionPool.getPoolInfo().getWaitTrial();
    }

    public void setwaitTrial(int waitTrial) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.poolControlPermission);
        this.managedConnectionPool.getPoolInfo().setWaitTrial(waitTrial);
    }

    public long getwaitingTime() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.managedConnectionPool.getPoolInfo().getWaitingTime();
    }

    public void setwaitingTime(long waitingTime) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.poolControlPermission);
        this.managedConnectionPool.getPoolInfo().setWaitingTime(waitingTime);
    }

    public long getpooledTimeout() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.managedConnectionPool.getPoolInfo().getPooledTimeout();
    }

    public void setpooledTimeout(long pooledTimeout) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.poolControlPermission);
        this.managedConnectionPool.updatePooledTimeout(pooledTimeout);
    }

    public long getdissociationtimeout() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.managedConnectionPool.getPoolInfo().getDissociationTimeout();
    }

    public void setdissociationtimeout(long dissociationtimeout) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.poolControlPermission);
        this.managedConnectionPool.updateDissociationTimeout(dissociationtimeout);
    }

    public long getinvalidationtimeout() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.managedConnectionPool.getPoolInfo().getInvalidationTimeout();
    }

    public void setinvalidationtimeout(long invalidationtimeout) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.poolControlPermission);
        this.managedConnectionPool.updateInvalidationTimeout(invalidationtimeout);
    }

    public long getvalidationtimeout() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.managedConnectionPool.getPoolInfo().getValidationTimeout();
    }

    public void setvalidationtimeout(long validationtimeout) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.poolControlPermission);
        this.managedConnectionPool.updateValidationTimeout(validationtimeout);
    }

    public boolean getskipMatching() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.managedConnectionPool.getPoolInfo().isSkipMatching();
    }

    public void setskipMatching(boolean skipMatching) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.poolControlPermission);
        this.managedConnectionPool.getPoolInfo().setSkipMatching(skipMatching);
    }

    public boolean getuseWrapper() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.managedConnectionPool.getPoolInfo().isUseWrapper();
    }

    public void setuseWrapper(boolean useWrapper) throws ResourceException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.poolControlPermission);
        try {
            this.managedConnectionPool.setUseWrapper(useWrapper);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceException(e.getMessage());
        }
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.jcaManagedConnectionFactory.managedConnectionFactory;
    }

    public String toString() {
        return "JCAConnectionFactory[" + this.exportName + "]";
    }

    protected String[] getChildType() {
        return childTypes;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    public Object getConnectionFactory() {
        return this.connectionFactory;
    }

    public CMInfo getCMInfo() {
        if (this.managedConnectionPool == null) {
            return null;
        }
        return this.managedConnectionPool.getCMInfo();
    }
}

