/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.security.Permission;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import javax.naming.Reference;
import jeus.jdbc.connectionpool.ConnectionPool;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.info.CPInfo;
import jeus.jdbc.info.PooledConnectionInfo;
import jeus.management.JMXManagerException;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.JDBCDataSourceMBean;
import jeus.management.j2ee.monitor.DataProvider;
import jeus.management.j2ee.monitor.MonitorHandler;
import jeus.management.j2ee.statistics.JDBCConnectionPoolStatsImpl;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.transaction.RecoveryThread;
import jeus.transaction.logging.JEUSXAResourceFactory;
import jeus.util.message.JeusMessage_JDBC;
import jeus.util.properties.JeusManagerPropertyValues;

public class JDBCDataSource
extends J2EEManagedObjectSupport
implements JDBCDataSourceMBean {
    private JDBCConnectionPoolStatsImpl stats;
    private ResourcePermission controlPermission;
    private ResourcePermission connectionInfoPermission;
    private List jdbcDriver = new Vector();
    private ConnectionPool target = null;
    private DataProvider connectionWaitingProvider = new DataProvider(){

        public Object getMonitorValue() {
            return JDBCDataSource.this.target.getWaitingThreadCount();
        }

        public String getFatalCause(MonitorHandler handler) {
            return "The number of waiting threads for the datasource " + JDBCDataSource.this.myObjectName + " exceeds the fatal number, waiting thread number : " + handler.getObservedValue();
        }

        public String getWarningCause(MonitorHandler handler) {
            return "The number of waiting threads for the datasource " + JDBCDataSource.this.myObjectName + " exceeds the warning number, waiting thread number : " + handler.getObservedValue();
        }
    };

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName pParent, Object target) throws InstanceAlreadyExistsException {
        JDBCDataSource jdbcDSMBean = new JDBCDataSource(mBeanName, pParent, target);
        return jdbcDSMBean.createMBean(mBeanName, "JDBCDataSource", pParent, parentKeyMap, null);
    }

    public JDBCDataSource(String mBeanName, ObjectName pParent, Object targetInput) {
        super(pParent);
        this.target = (ConnectionPool)targetInput;
        this.stats = new JDBCConnectionPoolStatsImpl(mBeanName);
    }

    public void addChild(ObjectName pChild) {
        String lType = JMXUtility.getJ2eeType(pChild);
        if ("JDBCDriver".equals(lType)) {
            this.jdbcDriver.add(pChild);
        }
        super.addChild(pChild);
    }

    public void removeChild(ObjectName pChild) {
        String lType = JMXUtility.getJ2eeType(pChild);
        if ("JDBCDriver".equals(lType)) {
            this.jdbcDriver.remove(pChild);
        }
        super.removeChild(pChild);
    }

    protected String initPermissionName() throws JMXManagerException {
        return this.initDefaultPermission();
    }

    protected void makePermissions() {
        super.makePermissions();
        this.controlPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"control");
        this.connectionInfoPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getConnectionInfo");
    }

    public String getExportName() {
        return this.target.getExportName();
    }

    public String getContainerName() {
        return JeusManagerPropertyValues.containerName;
    }

    public String getjdbcDriver() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        return this.jdbcDriver.get(0).toString();
    }

    public void setStatistic(StatisticImpl statistic) {
        this.stats.setStatistic((Statistic)statistic);
    }

    public Stats getstats() {
        return this.stats;
    }

    public String getconfig() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        return this.target.getInfo();
    }

    public CPInfo getCPInfo() {
        return this.target.getCPInfo();
    }

    public PooledConnectionInfo[] getPooledConnectionInfo() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.connectionInfoPermission);
        return this.target.getPooledConnectionInfoArray();
    }

    public void enableCP() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        this.target.enable();
    }

    public void disableCP() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        this.target.disable();
    }

    public void shrink() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        this.target.forcedShrink();
    }

    public void resyncCP() {
        block3: {
            LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
            try {
                Reference ref = this.target.getReference();
                if (this.target.getType() != 2) {
                    return;
                }
                RecoveryThread t = new RecoveryThread(new JEUSXAResourceFactory(ref));
                t.setDaemon(true);
                t.start();
            }
            catch (Throwable e) {
                if (!logger.isLoggable(JeusMessage_JDBC._95_LEVEL)) break block3;
                logger.log(JeusMessage_JDBC._95_LEVEL, JeusMessage_JDBC._95, (Object)this.getObjectName().getKeyProperty("name"), e);
            }
        }
    }

    public void updateCP(Hashtable properties) throws ConnectionPoolException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        this.target.update(properties);
    }

    public boolean isWorking() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        return this.target.isWorking();
    }

    public void refreshMonitoring() {
        List monitorList = null;
        monitorList = this.addHandler(monitorList, "connection-waiting-warning-ratio", "connection-waiting-fatal-ratio", this.connectionWaitingProvider);
        this.setMonitorList(monitorList);
    }
}

