/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.rmi.RemoteException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.JDBCConnectionPoolStats;
import javax.management.j2ee.statistics.Stats;
import javax.naming.InitialContext;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.jdbc.connectionpool.ClusterDataSourceFactory;
import jeus.jdbc.connectionpool.ClusteredConnectionPool;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.connectionpool.ConnectionPoolManager;
import jeus.jdbc.datasource.ClusterDSBindInfo;
import jeus.jdbc.info.CPInfo;
import jeus.management.JMXManagerException;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEResource;
import jeus.management.j2ee.JDBCResourceMBean;
import jeus.management.j2ee.statistics.JDBCStatsImpl;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.enginecontainer.EngineContainer;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_JDBC;
import jeus.util.properties.JeusManagerPropertyValues;

public class JDBCResource
extends J2EEResource
implements JDBCResourceMBean {
    private EngineContainer target;
    private List mDataSources = new ArrayList();
    private JDBCStatsImpl stats = new JDBCStatsImpl();
    private Permission controlPermission;

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, EngineContainer target) throws InstanceAlreadyExistsException {
        JDBCResource jdbcRscMBean = new JDBCResource(target, parent);
        return jdbcRscMBean.createMBean(mBeanName, "JDBCResource", parent, parentKeyMap, null);
    }

    public JDBCResource(EngineContainer _target, ObjectName parent) {
        super(parent);
        this.target = _target;
    }

    protected String initPermissionName() throws JMXManagerException {
        J2EEManagedObjectMBean parent = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return parent.getPermissionName() + "." + "JDBCResource" + this.myNameString;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.controlPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"control");
    }

    public void addChild(ObjectName pChild) {
        String lType = JMXUtility.getJ2eeType(pChild);
        if ("JDBCDataSource".equals(lType)) {
            this.mDataSources.add(pChild);
            super.addChild(pChild);
        }
    }

    public void removeChild(ObjectName pChild) {
        String lType = JMXUtility.getJ2eeType(pChild);
        if ("JDBCDataSource".equals(lType)) {
            this.mDataSources.remove(pChild);
            super.removeChild(pChild);
        }
    }

    public String getContainerName() {
        return JeusManagerPropertyValues.containerName;
    }

    public String[] getjdbcDataSources() {
        return JMXUtility.getAsStringArray(this.mDataSources);
    }

    public void addJDBCDataSourceStats(JDBCConnectionPoolStats stats) {
        this.stats.addJDBCConnectionPoolStats(stats);
    }

    public Stats getstats() {
        return this.stats;
    }

    public CPInfo[] getCPInfo() throws RemoteException {
        LoginUtil.checkPermissionWithRuntimeException(this.controlPermission);
        return ConnectionPoolManager.getCPInfo();
    }

    public void enableCP(String cpname) throws RemoteException {
        LoginUtil.checkPermissionWithRuntimeException(this.controlPermission);
        ConnectionPoolManager.enableCP(cpname);
    }

    public void disableCP(String cpname) throws RemoteException {
        LoginUtil.checkPermissionWithRuntimeException(this.controlPermission);
        ConnectionPoolManager.disableCP(cpname);
    }

    public void shrinkCP(String cpname) throws RemoteException {
        LoginUtil.checkPermissionWithRuntimeException(this.controlPermission);
        ConnectionPoolManager.shrinkCP(cpname);
    }

    public void resyncCP(String cpname) throws RemoteException {
        LoginUtil.checkPermissionWithRuntimeException(this.controlPermission);
        ConnectionPoolManager.resyncCP(cpname);
    }

    public void updateCP(String cpname, Hashtable properties) throws RemoteException {
        LoginUtil.checkPermissionWithRuntimeException(this.controlPermission);
        ConnectionPoolManager.updateCP(cpname, properties);
    }

    public void enableAll() throws RemoteException {
        LoginUtil.checkPermissionWithRuntimeException(this.controlPermission);
        ConnectionPoolManager.enableAll();
    }

    public void disableAll() throws RemoteException {
        LoginUtil.checkPermissionWithRuntimeException(this.controlPermission);
        ConnectionPoolManager.disableAll();
    }

    public void shrinkAll() throws RemoteException {
        LoginUtil.checkPermissionWithRuntimeException(this.controlPermission);
        ConnectionPoolManager.shrinkAll();
    }

    public void resyncAll() throws RemoteException {
        LoginUtil.checkPermissionWithRuntimeException(this.controlPermission);
        ConnectionPoolManager.resyncAll();
    }

    public String[] updateAll(Hashtable properties) throws RemoteException {
        LoginUtil.checkPermissionWithRuntimeException(this.controlPermission);
        return ConnectionPoolManager.updateAll(properties);
    }

    public void createConnectionPool(String poolName) throws RemoteException {
        LoginUtil.checkPermissionWithRuntimeException(this.controlPermission);
        try {
            new InitialContext().lookup(poolName);
        }
        catch (Exception e) {
            throw new RemoteException("", e);
        }
    }

    public void refreshConnectionPool(String poolName) throws RemoteException {
        LoginUtil.checkPermissionWithRuntimeException(this.controlPermission);
        ConnectionPoolManager.refresh(poolName);
    }

    public String[] getDataSourceListOfClusterDataSource(String exportName) throws ConnectionPoolException {
        LoginUtil.checkPermissionWithRuntimeException(this.controlPermission);
        JeusMainDescriptor desc = JeusMainDescriptorJB.getLocalJeusMainDescriptor();
        Enumeration e = desc.clusterDataSource.elements();
        while (e.hasMoreElements()) {
            ClusterDSBindInfo info = (ClusterDSBindInfo)e.nextElement();
            if (!exportName.equals(info.getExportName())) continue;
            return info.getDSListAsStringArray();
        }
        throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._43, (Object)exportName));
    }

    public void failbackClusterDataSource(String exportName) throws ConnectionPoolException {
        LoginUtil.checkPermissionWithRuntimeException(this.controlPermission);
        if (this.isClusterDataSource(exportName)) {
            ClusteredConnectionPool pool = ClusterDataSourceFactory.getClusteredConnectionPool(exportName);
            if (pool != null) {
                pool.failbackManually();
                return;
            }
            throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._33, (Object[])new String[]{exportName, this.getContainerName()}));
        }
        throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._43, (Object)exportName));
    }

    private boolean isClusterDataSource(String exportName) {
        JeusMainDescriptor desc = JeusMainDescriptorJB.getLocalJeusMainDescriptor();
        Enumeration e = desc.clusterDataSource.elements();
        while (e.hasMoreElements()) {
            ClusterDSBindInfo info = (ClusterDSBindInfo)e.nextElement();
            if (!exportName.equals(info.getExportName())) continue;
            return true;
        }
        return false;
    }
}

