/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.rmi.RemoteException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.jdbc.connectionpool.ConnectionPoolManager;
import jeus.jms.server.transaction.TransactionManager;
import jeus.jms.wrapper.ForeignJMSConnectionFactoryManager;
import jeus.management.JMXManagerException;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEResource;
import jeus.management.j2ee.JTAResourceMBean;
import jeus.management.j2ee.ResourceAdapterModule;
import jeus.management.j2ee.statistics.JTAStatsImpl;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.management.j2ee.transaction.IncompletedTransactionInfo;
import jeus.management.j2ee.transaction.IncompletedTransactionInfoImpl;
import jeus.management.j2ee.transaction.ReferenceInfo;
import jeus.management.j2ee.transaction.TransactionInfo;
import jeus.management.j2ee.transaction.TransactionInfoImpl;
import jeus.management.j2ee.transaction.XAResourceInfo;
import jeus.management.j2ee.transaction.XAResourceInfoImpl;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.transaction.Coordinator;
import jeus.transaction.GTID;
import jeus.transaction.TMConfig;
import jeus.transaction.TMConstants;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.TMServer;
import jeus.transaction.Terminator;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TxStatus;
import jeus.transaction.XidImpl;
import jeus.transaction.logging.IncompletedTx;
import jeus.transaction.logging.XidInfo;
import jeus.transaction.resources.JeusXAResource;
import jeus.transaction.resources.LocalResource;

public class JTAResource
extends J2EEResource
implements JTAResourceMBean {
    private ResourcePermission controlPermission;
    private JTAStatsImpl stats = new JTAStatsImpl();

    public static JTAResource createMBean(String mBeanName, ObjectName parent) throws InstanceAlreadyExistsException {
        JTAResource object = new JTAResource(parent);
        return (JTAResource)object.createMBean(mBeanName, "JTAResource", parent, parentKeyMap, null);
    }

    public JTAResource(ObjectName parent) {
        super(parent);
    }

    protected String initPermissionName() throws JMXManagerException {
        J2EEManagedObjectMBean parent = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return parent.getPermissionName() + "." + "JTAResource" + this.myNameString;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.controlPermission = PermissionMaker.makeResourcePermission((String)this.getPermissionName(), (String)"control");
    }

    public void setStatistic(StatisticImpl statistic) {
        this.stats.setStatistic((Statistic)statistic);
    }

    public Stats getstats() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.stats;
    }

    public void resyncXAResource(int resourceType, String exportName) throws RemoteException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        if (resourceType == 1) {
            ConnectionPoolManager.resyncCP(exportName);
        } else if (resourceType == 2) {
            if (!TransactionManager.resyncJMSServer((String)exportName)) {
                ForeignJMSConnectionFactoryManager.resyncJMSServer((String)exportName);
            }
        } else {
            if (resourceType == 3) {
                throw new RemoteException("not sufficient information for jca resource");
            }
            throw new RemoteException("invalid resource type " + resourceType);
        }
    }

    public void resyncXAResource(int resourceType, String exportName, String moduleName) throws RemoteException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        if (resourceType == 3) {
            ResourceAdapterModule.resyncCM(moduleName, exportName);
        } else if (resourceType == 1) {
            ConnectionPoolManager.resyncCP(exportName);
        } else if (resourceType == 2) {
            if (!TransactionManager.resyncJMSServer((String)exportName)) {
                ForeignJMSConnectionFactoryManager.resyncJMSServer((String)exportName);
            }
        } else {
            throw new RemoteException("invalid resource type " + resourceType);
        }
    }

    public long getactiveTimeout() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        return TMConfig.activeTO;
    }

    public void setactiveTimeout(long timeout) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        TMConfig.activeTO = timeout;
    }

    public long getprepareTimeout() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        return TMConfig.prepareTO;
    }

    public void setprepareTimeout(long timeout) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        TMConfig.prepareTO = timeout;
    }

    public long getpreparedTimeout() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        return TMConfig.preparedTO;
    }

    public void setpreparedTimeout(long timeout) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        TMConfig.preparedTO = timeout;
    }

    public long getcommitTimeout() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        return TMConfig.commitTO;
    }

    public void setcommitTimeout(long timeout) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        TMConfig.commitTO = timeout;
    }

    public long getrecoveryTimeout() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        return TMConfig.recoveryTO;
    }

    public void setrecoveryTimeout(long timeout) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        TMConfig.recoveryTO = timeout;
    }

    public long getuncompletedTimeout() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        return TMConfig.uncompletedTO;
    }

    public void setuncompletedTimeout(long timeout) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        TMConfig.uncompletedTO = timeout;
    }

    public void commit(Xid xid) throws XAException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        if (xid == null) {
            return;
        }
        if (xid.getFormatId() == 303077) {
            throw new XAException("current tx commit is not supported");
        }
        try {
            TMServer.setGlobalDecisionForUncompletedExternalTransaction(xid, true);
        }
        catch (TMException e) {
            e.printStackTrace();
            throw new XAException(-3);
        }
    }

    public void forget(Xid xid) throws XAException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        if (xid == null) {
            return;
        }
        if (xid.getFormatId() == 303077) {
            throw new XAException("current tx commit is not supported");
        }
        try {
            TMServer.forgetIncompleteTx(xid);
        }
        catch (TMException e) {
            e.printStackTrace();
            throw new XAException(-3);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        return TMServer.getIncompleteExternalXids();
    }

    public void rollback(Xid xid) throws XAException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        if (xid == null) {
            return;
        }
        if (xid.getFormatId() == 303077) {
            this.currentRollbackForcefully(xid);
        } else {
            this.incompletedRollbackForcefully(xid);
        }
    }

    private void incompletedRollbackForcefully(Xid xid) throws XAException {
        try {
            TMServer.setGlobalDecisionForUncompletedExternalTransaction(xid, false);
        }
        catch (TMException e) {
            e.printStackTrace();
            throw new XAException(-3);
        }
    }

    private void currentRollbackForcefully(Xid xid) {
        Coordinator coordinator;
        if (xid == null) {
            return;
        }
        byte[] gTidBytes = xid.getGlobalTransactionId();
        if (gTidBytes == null) {
            return;
        }
        GTID jeusGtid = new GTID(gTidBytes);
        TMInfo myTmInfo = TMServer.getTMInfo();
        TMInfo gtidTmInfo = jeusGtid.getTMInfo();
        if (myTmInfo == null || gtidTmInfo == null) {
            return;
        }
        if (myTmInfo.isSameLocation(gtidTmInfo)) {
            jeusGtid.setLocal();
        }
        if ((coordinator = ThreadContexts.getCoordinator(jeusGtid)) == null) {
            return;
        }
        Terminator.rollback(coordinator);
    }

    public ReferenceInfo[] getRecoveredXAResourceInfo() {
        return TMServer.getRecoveredXAResourceInfo();
    }

    public ReferenceInfo[] getCurrentXAResourceInfo() {
        return TMServer.getCurrentXAResourceInfo();
    }

    public void removeXAResourceInfo(ReferenceInfo ref) throws TMException {
        TMServer.removeXAResourceInfo(ref);
    }

    public IncompletedTx[] getAllIncompletedTx() {
        return TMServer.getAllincompletedTx();
    }

    public TransactionInfo[] getTransactionInfos() {
        Vector transactions = new Vector();
        if (ThreadContexts.hasActiveCoordinator()) {
            this.makeTransactionInfos(transactions, ThreadContexts.getLocalCoordinatorList());
            this.makeTransactionInfos(transactions, ThreadContexts.getSubCoordinatorList());
        }
        return transactions.toArray(new TransactionInfo[transactions.size()]);
    }

    private void makeTransactionInfos(Vector transactions, Vector coordinators) {
        if (transactions == null || coordinators == null) {
            return;
        }
        for (Object coordinator : coordinators) {
            TransactionInfo info;
            if (!(coordinator instanceof Coordinator) || (info = this.getTransactionInfoFromCoordinator((Coordinator)coordinator)) == null) continue;
            transactions.add(info);
        }
    }

    private TransactionInfo getTransactionInfoFromCoordinator(Coordinator coordinator) {
        Xid externalXid;
        if (coordinator == null) {
            return null;
        }
        TransactionInfoImpl transactionInfo = null;
        GTID gtid = coordinator.getGTID();
        if (gtid == null) {
            return null;
        }
        transactionInfo = new TransactionInfoImpl(new XidImpl(gtid.toBytes(), new byte[0], 303077));
        TMInfo tminfo = gtid.getTMInfo();
        if (tminfo != null) {
            transactionInfo.setCoordinator(tminfo.getIPString() + ":" + tminfo.getPort());
        }
        if ((externalXid = gtid.getExternalXid()) != null) {
            transactionInfo.setExternalXid(new XidImpl(externalXid));
        }
        transactionInfo.setTimeout(coordinator.getTimeout());
        transactionInfo.setElapseSinceBegin(coordinator.getElapseSinceBegin());
        transactionInfo.setStatus(TxStatus.getState(coordinator.getStatus()));
        Vector localResources = coordinator.getLocalResources();
        Vector<String> stringResources = new Vector<String>();
        for (Object localResource : localResources) {
            if (!(localResource instanceof LocalResource)) continue;
            LocalResource resource = (LocalResource)localResource;
            stringResources.add(resource.getName());
        }
        if (!stringResources.isEmpty()) {
            transactionInfo.setXaResources(stringResources.toArray(new String[stringResources.size()]));
        }
        return transactionInfo;
    }

    public IncompletedTransactionInfo[] getIncompletedTransactionInfos() {
        Vector<IncompletedTransactionInfo> incompletedTransactions = new Vector<IncompletedTransactionInfo>();
        IncompletedTx[] incompletedTxs = TMServer.getAllincompletedTx();
        for (int i = 0; i < incompletedTxs.length; ++i) {
            IncompletedTransactionInfo info = this.getIncompletedTransactionInfo(incompletedTxs[i]);
            if (info == null) continue;
            incompletedTransactions.add(info);
        }
        return incompletedTransactions.toArray(new IncompletedTransactionInfo[incompletedTransactions.size()]);
    }

    private IncompletedTransactionInfo getIncompletedTransactionInfo(IncompletedTx incompletedTx) {
        Xid externalXid;
        if (incompletedTx == null) {
            return null;
        }
        IncompletedTransactionInfoImpl incompletedTxInfo = null;
        GTID gtid = incompletedTx.getGTID();
        if (gtid == null) {
            return null;
        }
        incompletedTxInfo = new IncompletedTransactionInfoImpl(new XidImpl(gtid.toBytes(), new byte[0], 256077));
        TMInfo tminfo = gtid.getTMInfo();
        if (tminfo != null) {
            incompletedTxInfo.setCoordinator(tminfo.getIPString() + ":" + tminfo.getPort());
        }
        if ((externalXid = gtid.getExternalXid()) != null) {
            incompletedTxInfo.setExternalXid(new XidImpl(externalXid));
        }
        incompletedTxInfo.setTimeout(-1L);
        incompletedTxInfo.setElapseSinceBegin(-1L);
        incompletedTxInfo.setStatus(TxStatus.getState(incompletedTx.getLastStatus()));
        ArrayList childXidInfos = incompletedTx.getChildXids();
        Vector<XidImpl> childXids = new Vector<XidImpl>();
        for (Object xidInfo : childXidInfos) {
            XidInfo info;
            Xid xid;
            if (!(xidInfo instanceof XidInfo) || (xid = (info = (XidInfo)xidInfo).getXid()) == null) continue;
            childXids.add(new XidImpl(xid));
        }
        if (!childXids.isEmpty()) {
            incompletedTxInfo.setChildXids(childXids.toArray(new Xid[childXids.size()]));
        }
        incompletedTxInfo.setDecision(TxStatus.getState(incompletedTx.getDecision()));
        return incompletedTxInfo;
    }

    public XAResourceInfo[] getRetryingXAResourceInfos() {
        Vector<XAResourceInfo> retryingXAResourceInfos = new Vector<XAResourceInfo>();
        ConcurrentHashMap xaResourceInfos = TMServer.getFailedLocalResources();
        if (xaResourceInfos == null) {
            return new XAResourceInfo[0];
        }
        for (Map.Entry entry : xaResourceInfos.entrySet()) {
            XAResourceInfo info;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof LocalResource) || !(value instanceof Byte) || (info = this.getRetryingXAResourceInfo((LocalResource)key, (Byte)value)) == null) continue;
            retryingXAResourceInfos.add(info);
        }
        return retryingXAResourceInfos.toArray(new XAResourceInfo[retryingXAResourceInfos.size()]);
    }

    private XAResourceInfo getRetryingXAResourceInfo(LocalResource localResource, Byte status) {
        Xid xid;
        if (localResource == null || status == null) {
            return null;
        }
        XAResourceInfoImpl info = new XAResourceInfoImpl();
        XAResource xaResource = localResource.getXAResource();
        if (xaResource != null && xaResource instanceof JeusXAResource) {
            info.setName(((JeusXAResource)xaResource).getName());
        }
        if ((xid = localResource.getXid()) != null) {
            info.setXid(new XidImpl(xid));
        }
        info.setFailCount(localResource.getFailCount());
        info.setStatus(TMConstants.getPhaseString(status));
        info.setDecision(TMConstants.getDecisionStringFromPhase(status));
        return info;
    }
}

