/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.security.Permission;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.ServletMBean;
import jeus.management.j2ee.servlet.ServletInfo;
import jeus.management.j2ee.servlet.ServletStatsImpl;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.management.j2ee.statistics.TimeStatisticImpl;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.servlet.engine.ServletWrapper;

public class Servlet
extends J2EEManagedObjectSupport
implements ServletMBean {
    private ServletStatsImpl stats;
    private ServletWrapper target;
    private ResourcePermission servletInfoPermission;
    private ResourcePermission servletControlPermission;

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target) {
        try {
            Servlet object = new Servlet(parent, target);
            return object.createMBean(mBeanName, "Servlet", parent, parentKeyMap, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Servlet(ObjectName parent, Object _target) {
        super(parent);
        this.target = (ServletWrapper)_target;
        this.stats = new ServletStatsImpl();
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean module = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        String name = module.getPermissionName();
        name = name + ".servlet." + this.myNameString;
        return name;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.servletInfoPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"servletInfo");
        this.servletControlPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"servletControl");
    }

    public Stats getstats() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.stats;
    }

    public void setStatistic(StatisticImpl statistic) {
        this.stats.setStatistic((Statistic)statistic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeStatisticImpl getSERVICE_TIME() {
        if (this.stats == null) {
            return null;
        }
        TimeStatisticImpl stat = (TimeStatisticImpl)this.stats.getSERVICE_TIME();
        if (stat != null) {
            return stat;
        }
        ServletStatsImpl servletStatsImpl = this.stats;
        synchronized (servletStatsImpl) {
            stat = (TimeStatisticImpl)this.stats.getSERVICE_TIME();
            if (stat != null) {
                return stat;
            }
            return this.stats.createSERVICE_TIME();
        }
    }

    public ServletInfo getServletInfo() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.servletInfoPermission);
        if (this.target == null) {
            return null;
        }
        return this.target.getServletInfo();
    }

    public long getAverageExecutionTime() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.servletInfoPermission);
        TimeStatisticImpl timeStat = this.getALL_THREAD_COUNT();
        long _count = timeStat.getCount();
        if (_count == 0L) {
            return 0L;
        }
        return timeStat.getTotalTime() / timeStat.getCount();
    }

    public boolean resumeServlet() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.servletControlPermission);
        return this.target.execResume();
    }

    public boolean suspendServlet() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.servletControlPermission);
        return this.target.execSuspend();
    }

    public boolean clearStatServlet() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.servletControlPermission);
        return this.target.clearRequestCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeStatisticImpl getALL_THREAD_COUNT() {
        if (this.stats == null) {
            return null;
        }
        TimeStatisticImpl stat = (TimeStatisticImpl)this.stats.getSERVICE_TIME();
        if (stat != null) {
            return stat;
        }
        ServletStatsImpl servletStatsImpl = this.stats;
        synchronized (servletStatsImpl) {
            stat = (TimeStatisticImpl)this.stats.getSERVICE_TIME();
            if (stat != null) {
                return stat;
            }
            return this.stats.createSERVICE_TIME();
        }
    }
}

