/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.ServerException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.ModuleTypeSerializable;
import jeus.deploy.TargetModuleIDImpl;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.management.JMXManager;
import jeus.management.JMXUtility;
import jeus.management.j2ee.DeploymentException;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEModule;
import jeus.management.j2ee.WebModuleMBean;
import jeus.management.j2ee.servlet.WebEngineMoMBean;
import jeus.management.j2ee.servlet.WebModuleStatsImpl;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.security.base.Policy;
import jeus.security.container.ear.ApplicationSecurity;
import jeus.security.container.web.ServletSecurity;
import jeus.security.spi.PolicyNotExistsException;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.enginecontainer.EngineContainer;
import jeus.servlet.common.WebContainerControlImpl;
import jeus.servlet.common.WebContainerManager;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.WarFile;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ServletWrapper;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusException;
import jeus.util.JeusRuntimeException;
import jeus.util.file.FileUtils;
import jeus.util.message.JeusMessage_JMX;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.xml.binding.j2ee.Persistence;
import jeus.xml.binding.jeusDD.AllTargetsType;
import jeus.xml.binding.jeusDD.AppTargetType;
import jeus.xml.binding.jeusDD.DeploymentTargetType;
import jeus.xml.binding.jeusDD.WebComponentType;
import jeus.xml.binding.jeusDD.WebContextGroupType;

public class WebModule
extends J2EEModule
implements WebModuleMBean {
    private String contextName;
    private WebComponentType type;
    private boolean isRegistered = false;
    private String mBeanName;
    private WebModuleStatsImpl webStats;
    private String contextGroupObjectName;
    private Context context;
    private CountStatisticImpl allSessionsSizeCount;
    private CountStatisticImpl activeSessionsSizeCount;
    private CountStatisticImpl passivateSessionsSizeCount;
    private CountStatisticImpl requestCount;
    private CountStatisticImpl processingTime;
    private CountStatisticImpl localSessionsSizeCount;
    private Vector servlets = new Vector();
    private static final PermissionCollection defaultPermissions;
    private Permission webModuleInfoPermission;
    private Permission webModuleControlPermission;
    private WebContextGroupType contextGroup;
    private AtomicBoolean started = new AtomicBoolean(false);
    private boolean standaloneContext = false;
    private String manifestClassPaths;

    private WebModule(ObjectName parent, Object _target) {
        super(parent);
        this.webStats = new WebModuleStatsImpl();
        this.allSessionsSizeCount = this.getAllSessionsSize();
        this.activeSessionsSizeCount = this.getActiveSessionsSize();
        this.passivateSessionsSizeCount = this.getPassivateSessionsSize();
        this.localSessionsSizeCount = this.getLocalSessionsSize();
        this.requestCount = this.getRequestCount();
        this.processingTime = this.getProcessingTime();
    }

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target) {
        WebModule object = new WebModule(parent, target);
        object.mBeanName = mBeanName;
        object.parentObjectName = parent;
        return object;
    }

    public J2EEManagedObject createMBean() throws InstanceAlreadyExistsException {
        if (logger.isLoggable(JeusMessage_WebContainer0._1500_LEVEL)) {
            logger.log(JeusMessage_WebContainer0._1500_LEVEL, JeusMessage_WebContainer0._1500, new Object[]{this.parentObjectName, this.isRegistered});
        }
        if (this.isRegistered) {
            return this;
        }
        this.isRegistered = true;
        J2EEManagedObject object = super.createMBean(this.mBeanName, "WebModule", this.parentObjectName, WebModuleMBean.parentKeyMap, null);
        if (this.myModuleID == null) {
            this.myModuleID = new TargetModuleIDImpl(this.myObjectName, EngineContainer.serverMBean.getTarget());
        }
        return object;
    }

    public void destroyMBean() {
        this.destroyMBean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyMBean(boolean forced) {
        LoginUtil.checkPermissionWithCodeSubject(this.webModuleControlPermission);
        try {
            if (!this.isRegistered) {
                return;
            }
            this.isRegistered = false;
            super.destroyMBean(forced);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean parent = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return parent.getPermissionName() + ".webmodule." + this.myNameString;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.webModuleInfoPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"webModuleInfo");
        this.webModuleControlPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"webModuleControl");
    }

    public String[] getservlets() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.webModuleInfoPermission);
        return JMXUtility.getAsStringArray(this.servlets);
    }

    public String getContextGroupObjectName() {
        LoginUtil.checkPermissionWithRuntimeException(this.webModuleInfoPermission);
        return this.contextGroupObjectName;
    }

    public void setContextGroupObjectName(String _contextGroupObjectName) {
        LoginUtil.checkPermissionWithRuntimeException(this.webModuleInfoPermission);
        this.contextGroupObjectName = _contextGroupObjectName;
    }

    public WebContextGroupType getContextGroup() {
        LoginUtil.checkPermissionWithRuntimeException(this.webModuleInfoPermission);
        return this.contextGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeployInternal(long gracefulTimeout) throws Exception {
        block10: {
            try {
                if (logger.isLoggable(JeusMessage_WebContainer0._1501_LEVEL)) {
                    logger.log(JeusMessage_WebContainer0._1501_LEVEL, JeusMessage_WebContainer0._1501, new Object[]{this.contextGroup.strip2(), this.contextName});
                }
                if (this.isRegistered) {
                    this.executeUnDeploy(this.contextGroup, this.contextName, new Hashtable());
                }
                Object var4_2 = null;
                if (!this.standaloneContext || this.appPolicy == null) break block10;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var4_3 = null;
                    if (this.standaloneContext && this.appPolicy != null) {
                        try {
                            ApplicationSecurity.removePolicy(this.appPolicy, this.appType.getSecurityDomainName());
                        }
                        catch (PolicyNotExistsException ex) {
                            if (!logger.isLoggable(JeusMessage_WebContainer0._1514_LEVEL)) break block11;
                            logger.log(JeusMessage_WebContainer0._1514_LEVEL, JeusMessage_WebContainer0._1514, (Object)this.appPolicy, (Throwable)ex);
                        }
                    }
                }
                if (this.appPolicy != null) {
                    ServletSecurity.removeServletSubjectsFromApp(this.appType.getSecurityDomainName(), this.getAppModuleName());
                }
                throw throwable;
            }
            try {
                ApplicationSecurity.removePolicy(this.appPolicy, this.appType.getSecurityDomainName());
            }
            catch (PolicyNotExistsException ex) {
                if (!logger.isLoggable(JeusMessage_WebContainer0._1514_LEVEL)) break block10;
                logger.log(JeusMessage_WebContainer0._1514_LEVEL, JeusMessage_WebContainer0._1514, (Object)this.appPolicy, (Throwable)ex);
            }
        }
        if (this.appPolicy != null) {
            ServletSecurity.removeServletSubjectsFromApp(this.appType.getSecurityDomainName(), this.getAppModuleName());
        }
    }

    public PermissionCollection getDefaultPermissions() {
        return defaultPermissions;
    }

    private WebContextGroupType findTargetContextGroup(DeploymentTargetType targetType) {
        List list = targetType.getAllTargetsOrTarget();
        for (Object o : list) {
            AllTargetsType target;
            if (o instanceof AllTargetsType) {
                target = (AllTargetsType)o;
                return target.getWebContextGroup();
            }
            if (!(o instanceof AppTargetType)) continue;
            target = (AppTargetType)o;
            String nodeName = target.getNodeName();
            String containerName = target.getEngineContainerName();
            if (nodeName != null && nodeName.equals(EngineContainer.nodeName)) {
                return target.getWebContextGroup();
            }
            if (containerName == null || !containerName.equals(JeusManagerPropertyValues.containerName)) continue;
            return target.getWebContextGroup();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TargetModuleID deploy(Object deployDesc) throws Exception {
        String contextRoot = null;
        contextRoot = this.type.getContextRoot();
        this.isDeployed = true;
        this.pushDeploymentContext();
        try {
            DeploymentTargetType targetType = this.type.getDeploymentTarget();
            this.contextGroup = this.findTargetContextGroup(targetType);
            String jeusDDPath = this.type.getJeusWebDd();
            String containerName = JeusManagerPropertyValues.containerName;
            File pathFile = new File(this.path);
            FileArchive standaloneHomeArchive = pathFile.isAbsolute() ? (FileArchive)FileArchiveFactory.openArchiveStatic((String)this.path) : (FileArchive)EngineContainer.jeusArchive.getEmbeddedArchive("webhome" + File.separator + containerName + File.separator + this.path);
            String warFileHome = this.type.getUri();
            String archiveUri = standaloneHomeArchive.getArchiveUri();
            if (archiveUri != null && !archiveUri.endsWith(File.separator)) {
                archiveUri = archiveUri + File.separator;
            }
            String warFileFullPath = archiveUri + warFileHome;
            String warFileNamePart = null;
            boolean isExploded = false;
            if (FileUtils.isExploded((String)warFileFullPath)) {
                isExploded = true;
                warFileNamePart = warFileHome;
            } else {
                isExploded = false;
                warFileNamePart = FileUtils.getExtractDirectoryName((String)warFileHome);
            }
            String warContextDocBaseFullPath = archiveUri + warFileNamePart;
            if (!this.type.isSetKeepGenerated()) {
                this.type.setKeepGenerated(Boolean.valueOf(this.isKeepGenerated()));
            }
            if (this.deployType.equals("EAR")) {
                this.standaloneContext = false;
                this.executeDeploy(warFileFullPath, jeusDDPath, warFileHome, contextRoot, warContextDocBaseFullPath, !isExploded);
            } else if (this.deployType.equals("COMPONENT")) {
                this.appPolicy = new Policy();
                this.standaloneContext = true;
                this.executeDeploy(warFileFullPath, jeusDDPath, warFileHome, contextRoot, warContextDocBaseFullPath, !JeusDeploymentManager.isExploded(this.appType));
            }
            if (this.appPolicy != null) {
                ServletSecurity.addServletSubjectsToApp(this.appType.getSecurityDomainName(), this.getAppModuleName(), warContextDocBaseFullPath + File.separator + "WEB-INF");
            }
            if (this.standaloneContext && this.appPolicy != null) {
                ApplicationSecurity.addPolicy(this.appPolicy, this.appType.getSecurityDomainName(), this.appType);
            }
        }
        finally {
            this.popDeploymentContext();
        }
        this.myModuleID = new TargetModuleIDImpl(this.myObjectName, EngineContainer.serverMBean.getTarget());
        return this.myModuleID;
    }

    public String getDeployType() {
        return this.deployType;
    }

    public ModuleTypeSerializable getModuleType() {
        LoginUtil.checkPermissionWithRuntimeException(this.getModuleTypePermission);
        return ModuleTypeSerializable.WAR;
    }

    protected void preStart() throws StartingException {
        if (this.context != null) {
            if (this.started.compareAndSet(false, true)) {
                this.context.execStart();
            }
            this.context.execResume();
        }
    }

    protected void preStop() {
        if (this.context != null) {
            this.context.execSuspend();
        }
    }

    public void setContextGroup(WebContextGroupType _contextGroupName) {
        this.contextGroup = _contextGroupName;
    }

    public void setContext(String _contextName) {
        this.contextName = _contextName;
    }

    public void setDeploymentDescriptorFromDocBase(String _readlDocBase) {
        try {
            URL url = _readlDocBase.endsWith(File.separator) ? new URL(JeusBootstrapProperties.JEUS_URL_PREFIX + _readlDocBase + "WEB-INF/web.xml") : new URL(JeusBootstrapProperties.JEUS_URL_PREFIX + _readlDocBase + "/WEB-INF/web.xml");
            String desc = WebModule.getDeploymentDescriptor(url, 1);
            super.setDeploymentDescriptor(desc);
        }
        catch (MalformedURLException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setAdditionalNameProperties(Map prop) {
        prop.put("ContextGroup", this.contextGroup.getName());
        if (WebContainerManager._ENGINE_NAME != null) {
            prop.put("WebEngine", WebContainerManager._ENGINE_NAME);
        }
        super.setAdditionalNameProperties(prop);
    }

    public ClassLoader getClassLoader() {
        return this.context.getContextLoader();
    }

    public void addChild(ObjectName pChild) {
        this.servlets.addElement(pChild);
        super.addChild(pChild);
    }

    public void removeChild(ObjectName pChild) {
        this.servlets.remove(pChild);
        super.removeChild(pChild);
    }

    public Stats getstats() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        if (this.context != null) {
            ContextGroup cg = this.context.getVirtualHost().getContextGroup();
            this.allSessionsSizeCount.setValue((long)cg.getAllSessionsSize(this.context));
            this.activeSessionsSizeCount.setValue((long)cg.getActiveSessionsSize(this.context));
            this.passivateSessionsSizeCount.setValue((long)cg.getPassivateSessionsSize(this.context));
            this.localSessionsSizeCount.setValue((long)cg.getLocalSessionsSize(this.context));
            this.requestCount.setValue((long)this.context.currentRequestNum);
            this.processingTime.setValue(this.context.processingTime);
        }
        return this.webStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatisticImpl getRequestCount() {
        if (this.webStats == null) {
            return null;
        }
        CountStatisticImpl stat = (CountStatisticImpl)this.webStats.getRequestCount();
        if (stat != null) {
            return stat;
        }
        WebModuleStatsImpl webModuleStatsImpl = this.webStats;
        synchronized (webModuleStatsImpl) {
            stat = (CountStatisticImpl)this.webStats.getRequestCount();
            if (stat != null) {
                return stat;
            }
            return this.webStats.createRegisterRequestCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatisticImpl getProcessingTime() {
        if (this.webStats == null) {
            return null;
        }
        CountStatisticImpl stat = (CountStatisticImpl)this.webStats.getProcessingTime();
        if (stat != null) {
            return stat;
        }
        WebModuleStatsImpl webModuleStatsImpl = this.webStats;
        synchronized (webModuleStatsImpl) {
            stat = (CountStatisticImpl)this.webStats.getProcessingTime();
            if (stat != null) {
                return stat;
            }
            return this.webStats.createProcessingTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountStatisticImpl getAllSessionsSize() {
        if (this.webStats == null) {
            return null;
        }
        CountStatisticImpl stat = (CountStatisticImpl)this.webStats.getAllSessionsSize();
        if (stat != null) {
            return stat;
        }
        WebModuleStatsImpl webModuleStatsImpl = this.webStats;
        synchronized (webModuleStatsImpl) {
            stat = (CountStatisticImpl)this.webStats.getAllSessionsSize();
            if (stat != null) {
                return stat;
            }
            return this.webStats.createAllSessionsSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountStatisticImpl getActiveSessionsSize() {
        if (this.webStats == null) {
            return null;
        }
        CountStatisticImpl stat = (CountStatisticImpl)this.webStats.getActiveSessionsSize();
        if (stat != null) {
            return stat;
        }
        WebModuleStatsImpl webModuleStatsImpl = this.webStats;
        synchronized (webModuleStatsImpl) {
            stat = (CountStatisticImpl)this.webStats.getActiveSessionsSize();
            if (stat != null) {
                return stat;
            }
            return this.webStats.createActiveSessionsSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountStatisticImpl getPassivateSessionsSize() {
        if (this.webStats == null) {
            return null;
        }
        CountStatisticImpl stat = (CountStatisticImpl)this.webStats.getPassivateSessionsSize();
        if (stat != null) {
            return stat;
        }
        WebModuleStatsImpl webModuleStatsImpl = this.webStats;
        synchronized (webModuleStatsImpl) {
            stat = (CountStatisticImpl)this.webStats.getPassivateSessionsSize();
            if (stat != null) {
                return stat;
            }
            return this.webStats.createPassivateSessionsSize();
        }
    }

    public void setContext(Context _context) {
        this.context = _context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountStatisticImpl getLocalSessionsSize() {
        if (this.webStats == null) {
            return null;
        }
        CountStatisticImpl stat = (CountStatisticImpl)this.webStats.getLocalSessionsSize();
        if (stat != null) {
            return stat;
        }
        WebModuleStatsImpl webModuleStatsImpl = this.webStats;
        synchronized (webModuleStatsImpl) {
            stat = (CountStatisticImpl)this.webStats.getLocalSessionsSize();
            if (stat != null) {
                return stat;
            }
            return this.webStats.createLocalSessionsSize();
        }
    }

    public String getRealDocBase() {
        LoginUtil.checkPermissionWithRuntimeException(this.webModuleInfoPermission);
        if (this.context != null) {
            return this.context.getDocBase();
        }
        return null;
    }

    public boolean isIsolatedStandalone() {
        return this.isIsolatedClassloading && this.deployType.equals("COMPONENT");
    }

    public boolean isStandaloneContext() {
        return this.standaloneContext;
    }

    public boolean reload() {
        LoginUtil.checkPermissionWithRuntimeException(this.webModuleControlPermission);
        try {
            if (this.context != null) {
                return this.context.execReload();
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_WebContainer0._1550_LEVEL)) {
                logger.log(JeusMessage_WebContainer0._1550_LEVEL, JeusMessage_WebContainer0._1550, new Object[]{this.context.getContextName()}, (Throwable)e);
            }
            return false;
        }
        return false;
    }

    public boolean resumeContext() {
        LoginUtil.checkPermissionWithRuntimeException(this.webModuleControlPermission);
        try {
            this.start();
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_WebContainer0._1551_LEVEL)) {
                logger.log(JeusMessage_WebContainer0._1551_LEVEL, JeusMessage_WebContainer0._1551, new Object[]{this.context.getContextName()});
            }
            return false;
        }
        return true;
    }

    public boolean suspendContext() {
        LoginUtil.checkPermissionWithRuntimeException(this.webModuleControlPermission);
        try {
            this.stop();
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_WebContainer0._1552_LEVEL)) {
                logger.log(JeusMessage_WebContainer0._1552_LEVEL, JeusMessage_WebContainer0._1552, new Object[]{this.context.getContextName()});
            }
            return false;
        }
        return true;
    }

    public boolean clearStatContext() {
        LoginUtil.checkPermissionWithRuntimeException(this.webModuleControlPermission);
        if (this.context == null) {
            return false;
        }
        boolean result = true;
        Enumeration enum1 = this.context.getContextLoader().getServlets();
        while (enum1.hasMoreElements()) {
            ServletWrapper wrapper = (ServletWrapper)enum1.nextElement();
            result &= wrapper.clearRequestCount();
        }
        this.context.clearStatistic();
        return result;
    }

    private boolean executeDeploy(String sourcePath, String jeusDDPath, String webUri, String contextRoot, String warContextDocBaseFullPath, boolean extract) throws Exception {
        ContextDescriptor ctxDesc;
        String cgrpName = this.contextGroup == null ? null : this.contextGroup.getName();
        if (contextRoot == null) {
            contextRoot = this.getAppModuleName();
        }
        List virtualHostName = this.contextGroup == null ? Collections.EMPTY_LIST : this.contextGroup.getVirtualHostName();
        if (logger.isLoggable(JeusMessage_WebContainer0._1502_LEVEL)) {
            logger.log(JeusMessage_WebContainer0._1502_LEVEL, JeusMessage_WebContainer0._1502, new Object[]{sourcePath, jeusDDPath, cgrpName, webUri, contextRoot});
        }
        if ((ctxDesc = this.fillBasicInfo(sourcePath, jeusDDPath, cgrpName, webUri, contextRoot, warContextDocBaseFullPath, extract)).isFastDeploy() == null) {
            ctxDesc.setFastDeploy(this.isFastDeploy() ? Boolean.TRUE : Boolean.FALSE);
        }
        if (ctxDesc.isKeepGenerated() == null) {
            ctxDesc.setKeepGenerated(this.isKeepGenerated() ? Boolean.TRUE : Boolean.FALSE);
        }
        if (WebContainerManager.ENGINE_CONTROLLER != null) {
            WebContainerControlImpl webControllerImpl = WebContainerManager.ENGINE_CONTROLLER;
            if (ctxDesc.getContextGroup() == null) {
                Vector cgNames = webControllerImpl.getContextGroupNames();
                if (cgNames != null && cgNames.size() > 0) {
                    ctxDesc.setContextGroup((String)cgNames.get(0));
                }
                if (ctxDesc.getContextGroup() == null) {
                    if (logger.isLoggable(JeusMessage_WebContainer0._1503_LEVEL)) {
                        logger.log(JeusMessage_WebContainer0._1503_LEVEL, JeusMessage_WebContainer0._1503);
                    }
                    return false;
                }
            }
            ctxDesc.setWarDeploy(true);
            if (this.application != null) {
                ctxDesc.setEarDeploy(true);
            } else {
                ctxDesc.setEarDeploy(false);
            }
            TargetModuleID result = webControllerImpl.deployContext(ctxDesc.getContextGroup(), virtualHostName, ctxDesc, this.appPolicy, this.appClassLoader, this);
            if (result != null) {
                if (logger.isLoggable(JeusMessage_WebContainer0._1504_LEVEL)) {
                    logger.log(JeusMessage_WebContainer0._1504_LEVEL, JeusMessage_WebContainer0._1504, new Object[]{this.contextGroup.getName(), this.contextName});
                }
                return true;
            }
        }
        return false;
    }

    private boolean executeUnDeploy(WebContextGroupType context_group, String context_name, Hashtable results) {
        String context_group_name = context_group == null ? null : context_group.getName();
        try {
            WebEngineMoMBean engineMo = JMXUtility.getProxy((MBeanServerConnection)JMXManager.getMbeanServer(), JMXUtility.queryEngineMo(JMXManager.getMbeanServer(), JeusManagerPropertyValues.containerName, EngineContainer.getFirstServletEngine()), WebEngineMoMBean.class, false);
            ObjectName result = engineMo.undeployContext(context_group_name, context_name);
            if (result != null) {
                results.put("redeploy", "SUCCESS");
                return true;
            }
            results.put("redeploy", "FAIL");
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            results.put("redeploy", "FAIL");
            return false;
        }
    }

    private ContextDescriptor fillBasicInfo(String sourcePath, String jdPath, String cgrpName, String webUri, String contextRoot, String absoulteUnjarPath, boolean extract) throws Exception {
        ContextDescriptor ctxDesc;
        WarFile warFile = new WarFile(sourcePath, jdPath, this.type, logger);
        if (absoulteUnjarPath != null) {
            warFile.setUnjarPath(absoulteUnjarPath);
        }
        warFile.openPackage(absoulteUnjarPath, contextRoot, extract);
        FileArchive fileArchive = new FileArchive(absoulteUnjarPath);
        Manifest manifest = fileArchive.getManifest();
        if (manifest != null) {
            Attributes attribs = manifest.getMainAttributes();
            this.manifestClassPaths = attribs.getValue(Attributes.Name.CLASS_PATH);
        }
        try {
            ctxDesc = warFile.loadContextDescriptor(contextRoot);
            ctxDesc.setContextName(this.getUniqueModuleName());
            ctxDesc.setContextGroup(cgrpName);
            ctxDesc.setWebddCreated(warFile.isWebddCreated());
            this.contextName = ctxDesc.getContextName();
        }
        catch (JeusException je) {
            if (logger.isLoggable(JeusMessage_WebContainer0._1505_LEVEL)) {
                logger.log(JeusMessage_WebContainer0._1505_LEVEL, JeusMessage_WebContainer0._1505, (Object)warFile.getJeusDescriptorPath(), (Throwable)je);
            }
            throw je;
        }
        catch (FileNotFoundException ex) {
            if (logger.isLoggable(JeusMessage_WebContainer0._1505_LEVEL)) {
                logger.log(JeusMessage_WebContainer0._1505_LEVEL, JeusMessage_WebContainer0._1505, (Object)warFile.getJeusDescriptorPath(), (Throwable)ex);
            }
            throw ex;
        }
        if (absoulteUnjarPath != null) {
            ctxDesc.setDocBase(absoulteUnjarPath);
        }
        if (ctxDesc.getContextPath() == null) {
            ctxDesc.setContextPathByContextRoot(contextRoot, this.getAppModuleName());
        }
        if (logger.isLoggable(JeusMessage_WebContainer0._1506_LEVEL)) {
            logger.log(JeusMessage_WebContainer0._1506_LEVEL, JeusMessage_WebContainer0._1506, new Object[]{webUri, cgrpName, this.getUniqueModuleName()});
        }
        return ctxDesc;
    }

    public boolean restartServlet(String servletName) {
        LoginUtil.checkPermissionWithRuntimeException(this.webModuleControlPermission);
        try {
            boolean result = this.context.terminateServlet(servletName);
            if (!result && logger.isLoggable(JeusMessage_WebContainer0._1507_LEVEL)) {
                logger.log(JeusMessage_WebContainer0._1507_LEVEL, JeusMessage_WebContainer0._1507, new Object[]{"restart", servletName});
            }
            return this.context.restartServlet(servletName);
        }
        catch (ServerException e) {
            if (logger.isLoggable(JeusMessage_WebContainer0._1507_LEVEL)) {
                logger.log(JeusMessage_WebContainer0._1507_LEVEL, JeusMessage_WebContainer0._1507, new Object[]{"restart", servletName}, (Throwable)e);
            }
            return false;
        }
    }

    public boolean resumeServlet(String servletName) {
        LoginUtil.checkPermissionWithRuntimeException(this.webModuleControlPermission);
        ServletWrapper wrapper = this.context.getServletByName(servletName);
        if (wrapper != null) {
            return wrapper.execResume();
        }
        return false;
    }

    public boolean suspendServlet(String servletName) {
        LoginUtil.checkPermissionWithRuntimeException(this.webModuleControlPermission);
        ServletWrapper wrapper = this.context.getServletByName(servletName);
        if (wrapper != null) {
            return wrapper.execSuspend();
        }
        return false;
    }

    public boolean terminateServlet(String servletName) {
        LoginUtil.checkPermissionWithRuntimeException(this.webModuleControlPermission);
        return this.context.terminateServlet(servletName);
    }

    public boolean clearStatServlet(String servletName) {
        LoginUtil.checkPermissionWithRuntimeException(this.webModuleControlPermission);
        ServletWrapper wrapper = this.context.getServletByName(servletName);
        if (wrapper != null) {
            return wrapper.clearRequestCount();
        }
        return false;
    }

    public void setAutoReload(String enableReload) {
        LoginUtil.checkPermissionWithRuntimeException(this.webModuleControlPermission);
        ContextDescriptor ctxDesc = this.context.getContextDescriptor();
        ctxDesc.setAutoReload(enableReload);
    }

    public String getAutoReload() {
        LoginUtil.checkPermissionWithRuntimeException(this.webModuleControlPermission);
        ContextDescriptor ctxDesc = this.context.getContextDescriptor();
        return ctxDesc.getAutoReload();
    }

    public String getDomainName() {
        if (this.appType != null) {
            return this.appType.getSecurityDomainName();
        }
        return null;
    }

    public void setComponentType(Object deployDesc) {
        this.type = (WebComponentType)deployDesc;
    }

    public Object getComponentType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPersistenceUnits() throws DeploymentException {
        Persistence puDescriptor = null;
        String classesPath = "WEB-INF" + File.separator + "classes";
        AbstractArchive classesArchive = null;
        try {
            classesArchive = this.rootArchive.getEmbeddedArchive(classesPath);
            puDescriptor = this.getPersistenceDescriptor(classesArchive);
            if (puDescriptor != null) {
                if (logger.isLoggable(JeusMessage_JMX.JMX_133_LEVEL)) {
                    logger.log(JeusMessage_JMX.JMX_133_LEVEL, JeusMessage_JMX.JMX_133, (Object)classesPath);
                }
                this.addPersistenceUnits(classesPath, puDescriptor);
            }
        }
        catch (IOException ex) {
            throw new DeploymentException(ex);
        }
        finally {
            if (classesArchive != null) {
                try {
                    classesArchive.close();
                }
                catch (IOException e) {}
            }
        }
        String libDir = "WEB-INF" + File.separator + "lib";
        FileArchive libArchive = null;
        try {
            if (this.rootArchive.contains(libDir)) {
                libArchive = (FileArchive)this.rootArchive.getEmbeddedArchive(libDir);
                File f = libArchive.getFile();
                for (String entry : f.list()) {
                    if (!entry.endsWith(".jar")) continue;
                    AbstractArchive jarArchive = libArchive.getEmbeddedArchive(entry);
                    try {
                        puDescriptor = this.getPersistenceDescriptor(jarArchive);
                        if (puDescriptor == null) continue;
                        String uri = libDir + File.separator + entry;
                        if (logger.isLoggable(JeusMessage_JMX.JMX_133_LEVEL)) {
                            logger.log(JeusMessage_JMX.JMX_133_LEVEL, JeusMessage_JMX.JMX_133, (Object)uri);
                        }
                        this.addPersistenceUnits(uri, puDescriptor);
                    }
                    finally {
                        jarArchive.close();
                    }
                }
                libArchive.close();
            }
        }
        catch (IOException ex) {
            throw new DeploymentException(ex);
        }
        finally {
            if (libArchive != null) {
                try {
                    libArchive.close();
                }
                catch (IOException e) {}
            }
        }
        this.loadPersistenceUnits();
    }

    public String getManifestClassPaths() {
        return this.manifestClassPaths;
    }

    static {
        try {
            defaultPermissions = java.security.Policy.getPolicy().getPermissions(new CodeSource(new URL("file:/jeus/web/"), (Certificate[])null));
        }
        catch (MalformedURLException e) {
            throw new JeusRuntimeException((Throwable)e);
        }
    }
}

