/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.ejb;

import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import jeus.ejb.EJBEngine;
import jeus.ejb.ejbserver.ActiveManager;
import jeus.management.JMXUtility;
import jeus.management.j2ee.EJBMBean;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.ejb.EJBEngineMoMBean;
import jeus.management.j2ee.manager.EngineMo;
import jeus.management.j2ee.monitor.DataProvider;
import jeus.management.j2ee.monitor.MonitorHandler;
import jeus.security.spi.LoginService;
import jeus.server.enginecontainer.EngineContainerException;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.JeusRuntimeException;
import jeus.util.properties.JeusManagerPropertyValues;

public class EJBEngineMo
extends EngineMo
implements EJBEngineMoMBean {
    private EJBEngine server;
    private DataProvider activeManagementProvider = new DataProvider(){

        public Object getMonitorValue() {
            ActiveManager activeManager = ActiveManager.currentActiveManager();
            if (activeManager != null) {
                return new Float(activeManager.getBlockedThreadRatio());
            }
            return 0;
        }

        public String getFatalCause(MonitorHandler handler) {
            return null;
        }

        public String getWarningCause(MonitorHandler handler) {
            return "The number of blocked threads in EJB Engine exceeds the warning ratio, blocked thread : " + handler.getObservedValue();
        }
    };

    public EJBEngineMo(Object target) {
        this.server = (EJBEngine)target;
    }

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        EJBEngineMo mo = new EJBEngineMo(target);
        return mo.createMBean(srvName, "JeusService", parent, parentKeyMap, "EJBEngine");
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean parent = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return parent.getPermissionName() + ".ejb";
    }

    protected void makePermissions() {
        super.makePermissions();
    }

    public int getblockThreadCount() {
        ActiveManager activeManager = ActiveManager.currentActiveManager();
        if (activeManager != null) {
            return activeManager.getNumBlockedThread();
        }
        return 0;
    }

    public Map getStats() throws IOException {
        ObjectName[] names;
        HashMap<ObjectName, Stats> map = new HashMap<ObjectName, Stats>();
        try {
            names = JMXUtility.queryEJBs(this.mbs, JeusManagerPropertyValues.containerName, null, null);
        }
        catch (IllegalJeusSystemNameException e) {
            throw new JeusRuntimeException((Throwable)e);
        }
        for (int i = 0; i < names.length; ++i) {
            ObjectName name = names[i];
            EJBMBean mbean = JMXUtility.getProxy((MBeanServerConnection)this.mbs, name, EJBMBean.class, false);
            map.put(name, mbean.getstats());
        }
        return map;
    }

    public void down() throws EngineContainerException {
        LoginService.checkCodeSubject();
        EJBEngineMo eJBEngineMo = this;
        eJBEngineMo.server.down();
    }

    public void refreshMonitoring() {
        List monitorList = null;
        monitorList = this.addHandler(monitorList, "ejb-active-management-ratio", null, this.activeManagementProvider);
        this.setMonitorList(monitorList);
    }

    public static ObjectName makeObjectName(ObjectName objName, String name) throws MalformedObjectNameException {
        Hashtable t = EJBEngineMo.getObjectNameKeyTable(objName, parentKeyMap, name, "JeusService", "EJBEngine");
        return new ObjectName("JEUS", t);
    }
}

