/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.security;

import java.security.Permission;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.security.SecurityMoMBean;
import jeus.security.base.Domain;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;

public class SecurityMo
extends J2EEManagedObjectSupport
implements SecurityMoMBean {
    private SecurityInstaller target;
    private Vector securityDomains = new Vector();
    private ResourcePermission securityPermission;

    public SecurityMo(ObjectName parent, Object target) {
        super(parent);
        this.target = (SecurityInstaller)target;
    }

    public Stats getstats() {
        return null;
    }

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        SecurityMo object = new SecurityMo(parent, target);
        return object.createMBean(mBeanName, "JeusService", parent, SecurityMoMBean.parentKeyMap, "SecurityService");
    }

    public void addChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType(pChild);
        if (lType.equals("SecurityDomain")) {
            this.securityDomains.add(pChild);
            super.addChild(pChild);
        }
    }

    public void removeChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType(pChild);
        if (lType.equals("SecurityDomain")) {
            this.securityDomains.remove(pChild);
            super.removeChild(pChild);
        }
    }

    public String[] getSecurityDomains() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.securityPermission);
        return JMXUtility.getAsStringArray(this.securityDomains);
    }

    public String getCurrentDomain() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.securityPermission);
        Domain domain = Domain.getCurrentDomain();
        return domain.getName();
    }

    public String addSecurityDomain(String name) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.securityPermission);
        return this.target.addDomain(name);
    }

    public void removeSecurityDomain(String name) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.securityPermission);
        this.target.removeDomain(name);
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean parent = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return parent.getPermissionName() + ".security";
    }

    protected void makePermissions() {
        super.makePermissions();
        this.securityPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"securityControl");
    }
}

