/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.servlet;

import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.security.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.manager.EngineMo;
import jeus.management.j2ee.servlet.ContextGroupMo;
import jeus.management.j2ee.servlet.WebEngineMoMBean;
import jeus.management.j2ee.servlet.WebEngineStatsImpl;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.security.base.Policy;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.enginecontainer.EngineContainerException;
import jeus.servlet.common.WebContainerManager;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.WebContainerDescriptor;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ServletWrapper;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.xml.binding.jeusDD.WebContainerType;

public class WebEngineMo
extends EngineMo
implements WebEngineMoMBean {
    private WebContainerManager target;
    private Vector ctxGroups = new Vector();
    private Vector webtGroups = new Vector();
    private ObjectName sessionContainer = null;
    private WebEngineStatsImpl webEngineStats;
    private ResourcePermission webEngineInfoPermission;
    private ResourcePermission webEngineControlPermission;
    private Vector destroyedGroups = new Vector();

    public WebEngineMo(Object target, ObjectName parent) {
        super(parent);
        this.target = (WebContainerManager)target;
        this.webEngineStats = new WebEngineStatsImpl();
    }

    public String[] getContextGroups() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineInfoPermission);
        return JMXUtility.getAsStringArray(this.ctxGroups);
    }

    public ObjectName getContextGroup(String ctxGrpName) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineInfoPermission);
        Enumeration enum1 = this.ctxGroups.elements();
        while (enum1.hasMoreElements()) {
            ObjectName groupName = (ObjectName)enum1.nextElement();
            if (!groupName.getKeyProperty("name").equals(ctxGrpName)) continue;
            return groupName;
        }
        return null;
    }

    public String[] getDestroyedGroups() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineInfoPermission);
        return this.destroyedGroups.toArray(new String[this.destroyedGroups.size()]);
    }

    public ObjectName getSessionContainer() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineInfoPermission);
        return this.sessionContainer;
    }

    public String[] getWebtConnectionGroup() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineInfoPermission);
        return JMXUtility.getAsStringArray(this.webtGroups);
    }

    public WebContainerType getConfiguration() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineInfoPermission);
        return this.target.getWebContainerDescriptor().getWebMainConfiguration();
    }

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        WebEngineMo object = new WebEngineMo(target, parent);
        return object.createMBean(mBeanName, "JeusService", parent, parentKeyMap, "WebEngine");
    }

    public void addChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType(pChild);
        if ("ContextGroup".equals(lType)) {
            this.ctxGroups.add(pChild);
        }
        if (lType.equals("SessionContainer") || lType.equals("SessionContainerCentral") || lType.equals("SessionContainerP2P")) {
            this.sessionContainer = pChild;
        }
        super.addChild(pChild);
    }

    public void removeChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType(pChild);
        if ("ContextGroup".equals(lType)) {
            this.ctxGroups.remove(pChild);
        }
        if (lType.equals("SessionContainer") || lType.equals("SessionContainerCentral") || lType.equals("SessionContainerP2P")) {
            this.sessionContainer = null;
        }
        super.removeChild(pChild);
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean module = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        String name = module.getPermissionName();
        name = name + ".web";
        return name;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.webEngineInfoPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"webEngineInfo");
        this.webEngineControlPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"webEngineControl");
    }

    public WebContainerDescriptor getConfigInfo() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineInfoPermission);
        return this.target.getWebContainerDescriptor();
    }

    public Stats getstats() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        Runtime rt = Runtime.getRuntime();
        ((CountStatisticImpl)this.webEngineStats.getTotalMemory()).setValue(rt.totalMemory());
        ((CountStatisticImpl)this.webEngineStats.getFreeMemory()).setValue(rt.freeMemory());
        return this.webEngineStats;
    }

    public boolean getServerStatus() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineInfoPermission);
        return false;
    }

    public TargetModuleID deployContext(String contextGroupName, List virtualHostName, ContextDescriptor ctxDesc, Policy appPolicy) throws RemoteException {
        return this.target.deployContext(contextGroupName, virtualHostName, ctxDesc, appPolicy, null, null);
    }

    public ObjectName undeployContext(String contextGroupName, String contextName) throws RemoteException {
        return this.target.getController().undeployContext(contextGroupName, contextName);
    }

    public Vector getContextGroupNames() throws RemoteException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineInfoPermission);
        return this.target.getController().getContextGroupNames();
    }

    public void down() throws EngineContainerException {
        LoginService.checkCodeSubject();
        if (this.destroyedGroups != null) {
            this.destroyedGroups.clear();
        }
        this.target.shutdown();
    }

    public boolean restartContextGroup(String groupName) {
        boolean result;
        ContextGroupMo contextGroupMo;
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineControlPermission);
        ContextGroup ctxGroup = this.target.getContextGroup(groupName);
        if (ctxGroup != null && this.target.terminateCtxGroup(groupName) && (contextGroupMo = ctxGroup.getContextGroupMBean()) != null) {
            try {
                if (contextGroupMo.getstate() != 3) {
                    contextGroupMo.stop();
                }
                contextGroupMo.destroyMBean();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            result = this.target.restartCtxGroup(groupName);
        }
        catch (ServerException e) {
            if (logger.isLoggable(JeusMessage_WebContainer0._1510_LEVEL)) {
                logger.log(JeusMessage_WebContainer0._1510_LEVEL, JeusMessage_WebContainer0._1510, new Object[]{"restart", groupName}, (Throwable)e);
            }
            result = false;
        }
        if (result && this.destroyedGroups.contains(groupName)) {
            this.destroyedGroups.remove(groupName);
        }
        return result;
    }

    public boolean resumeContextGroup(String groupName) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineControlPermission);
        ContextGroup ctxGroup = this.target.getContextGroup(groupName);
        if (ctxGroup == null) {
            return false;
        }
        return ctxGroup.execResume();
    }

    public boolean suspendContextGroup(String groupName) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineControlPermission);
        ContextGroup ctxGroup = this.target.getContextGroup(groupName);
        if (ctxGroup == null) {
            return false;
        }
        return ctxGroup.execSuspend();
    }

    public boolean terminateContextGroup(String groupName) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineControlPermission);
        ContextGroup ctxGroup = this.target.getContextGroup(groupName);
        if (ctxGroup == null) {
            return false;
        }
        if (this.target.terminateCtxGroup(groupName)) {
            ContextGroupMo contextGroupMo = ctxGroup.getContextGroupMBean();
            if (contextGroupMo != null) {
                try {
                    if (contextGroupMo.getstate() != 3) {
                        contextGroupMo.stop();
                    }
                    contextGroupMo.destroyMBean();
                }
                catch (Exception e) {
                    return false;
                }
            }
            this.destroyedGroups.add(groupName);
            return true;
        }
        return false;
    }

    public boolean clearStatContextGroup(String groupName) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineControlPermission);
        ContextGroup ctxGroup = this.target.getContextGroup(groupName);
        if (ctxGroup == null) {
            return false;
        }
        boolean result = true;
        Enumeration enum2 = ctxGroup.getContexts();
        while (enum2.hasMoreElements()) {
            Context context = (Context)enum2.nextElement();
            Enumeration enum1 = context.getContextLoader().getServlets();
            while (enum1.hasMoreElements()) {
                ServletWrapper wrapper = (ServletWrapper)enum1.nextElement();
                result &= wrapper.clearRequestCount();
            }
            context.clearStatistic();
        }
        return result;
    }

    public long getcheckClassReload() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineInfoPermission);
        return this.target.getMonitoringPeriod(3);
    }

    public long getcheckSession() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineInfoPermission);
        return this.target.getMonitoringPeriod(2);
    }

    public long getcheckThreadPool() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineInfoPermission);
        return this.target.getMonitoringPeriod(0);
    }

    public void setcheckClassReload(long period) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineControlPermission);
        this.target.setMonitoringPeriod("" + period, 3);
    }

    public void setcheckSession(long period) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineControlPermission);
        this.target.setMonitoringPeriod("" + period, 2);
    }

    public void setcheckThreadPool(long period) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webEngineControlPermission);
        this.target.setMonitoringPeriod("" + period, 0);
    }

    public static ObjectName makeObjectName(ObjectName objName, String name) throws MalformedObjectNameException {
        Hashtable t = WebEngineMo.getObjectNameKeyTable(objName, parentKeyMap, name, "JeusService", "WebEngine");
        return new ObjectName("JEUS", t);
    }
}

