/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.webserver;

import java.rmi.RemoteException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.manager.EngineMo;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.management.j2ee.statistics.TimeStatisticImpl;
import jeus.management.j2ee.webserver.WebServerInfoMBean;
import jeus.management.j2ee.webserver.WebServerInfoStatsImpl;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.enginecontainer.EngineContainerException;
import jeus.util.JeusException;
import jeus.webserver.NodeDescriptor;
import jeus.webserver.SvrDescriptor;
import jeus.webserver.WebServerProxyImpl;

public class WebServerInfo
extends EngineMo
implements WebServerInfoMBean {
    private WebServerProxyImpl target;
    private WebServerInfoStatsImpl stats;
    private List mWSEngine = new ArrayList();
    private Permission webserverPermission;

    public WebServerInfo(Object target, ObjectName parent) {
        super(parent);
        this.stats = new WebServerInfoStatsImpl();
        this.target = (WebServerProxyImpl)target;
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean parent = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return parent.getPermissionName() + ".webserver";
    }

    protected void makePermissions() {
        super.makePermissions();
        this.webserverPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"webserver");
    }

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        WebServerInfo object = new WebServerInfo(target, parent);
        return object.createMBean(mBeanName, "JeusService", parent, parentKeyMap, "WSEngine");
    }

    public void addChild(ObjectName objectname) {
        LoginService.checkCodeSubject();
        String s = JMXUtility.getJeusType(objectname);
        if ("WSEngine".equals(s)) {
            this.mWSEngine.add(objectname);
            super.addChild(objectname);
        }
    }

    public void removeChild(ObjectName objectname) {
        LoginService.checkCodeSubject();
        String s = JMXUtility.getJeusType(objectname);
        if ("WSEngine".equals(s)) {
            this.mWSEngine.remove(objectname);
            super.removeChild(objectname);
        }
    }

    public void setStatistic(StatisticImpl statistic) {
        this.stats.setStatistic((Statistic)statistic);
    }

    public Stats getstats() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        if (this.stats == null) {
            return null;
        }
        if (this.target != null) {
            try {
                SvrDescriptor[] svrdecs = this.target.getAllSvr();
                CountStatisticImpl svrCount = (CountStatisticImpl)this.stats.getSvrCount();
                CountStatisticImpl execCount = (CountStatisticImpl)this.stats.getExecCount();
                TimeStatisticImpl avgTime = (TimeStatisticImpl)this.stats.getAvgTime();
                for (int i = 0; i < svrdecs.length; ++i) {
                    SvrDescriptor desc = svrdecs[i];
                    svrCount.setValue((long)desc.getCount());
                    avgTime.addData((long)desc.getAvg());
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return this.stats;
    }

    public NodeDescriptor getNodeInfo() {
        LoginUtil.checkPermissionWithRuntimeException(this.webserverPermission);
        try {
            return this.target.getNodeDescriptor();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public SvrDescriptor[] getSvrAllInfo() {
        LoginUtil.checkPermissionWithRuntimeException(this.webserverPermission);
        try {
            return this.target.getAllSvr();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down() throws EngineContainerException {
        try {
            LoginUtil.loginCodeSubjectWithRuntimeException();
            this.target.down();
        }
        catch (JeusException e) {
            new EngineContainerException("fail to WebtoB Down", (Throwable)e);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    public static ObjectName makeObjectName(ObjectName objName, String name) throws MalformedObjectNameException {
        Hashtable t = WebServerInfo.getObjectNameKeyTable(objName, parentKeyMap, name, "JeusService", "WSEngine");
        return new ObjectName("JEUS", t);
    }
}

