/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.webservices;

import java.security.Permission;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.webservices.MetricsMBean;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;

public class Metrics
extends J2EEManagedObjectSupport
implements MetricsMBean {
    private int numberOfRequests = 0;
    private int numberOfFailedequests = 0;
    private int numberOfSuccessfulRequests = 0;
    private long lastResponseTime;
    private long maxResponseTime;
    private long serviceTime;
    private ResourcePermission webservicesMetricsPermission;

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent) throws InstanceAlreadyExistsException {
        Metrics object = new Metrics();
        return object.createMBean(mBeanName, "JeusService", parent, parentKeyMap, "WebServices");
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean module = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        String name = module.getPermissionName();
        name = name + ".webservices." + this.myNameString;
        return name;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.webservicesMetricsPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"webservicesMetrics");
    }

    public void incrementNumberOfRequests() {
        ++this.numberOfRequests;
    }

    public void incrementNumberOfFailedRequests() {
        ++this.numberOfFailedequests;
    }

    public void incrementNumberOfSuccessfulRequests() {
        ++this.numberOfSuccessfulRequests;
    }

    public int getNumberOfRequests() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webservicesMetricsPermission);
        return this.numberOfRequests;
    }

    public int getNumberOfFailedRequests() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webservicesMetricsPermission);
        return this.numberOfFailedequests;
    }

    public int getNumberOfSuccessfulRequests() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webservicesMetricsPermission);
        return this.numberOfSuccessfulRequests;
    }

    public long getServiceTime() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webservicesMetricsPermission);
        return this.serviceTime;
    }

    public long getMaxResponseTime() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webservicesMetricsPermission);
        return this.maxResponseTime;
    }

    public long getLastResponseTime() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webservicesMetricsPermission);
        return this.lastResponseTime;
    }

    public void setLastResponseTime(long lastResponseTime) {
        this.lastResponseTime = lastResponseTime;
        if (this.maxResponseTime < lastResponseTime) {
            this.maxResponseTime = lastResponseTime;
        }
        this.serviceTime += lastResponseTime;
    }
}

