/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.adaptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;

public class MbeanToOidTable {
    private Hashtable mbeanToOidTable = new Hashtable();

    public void putAttribute(String mbeanName, String attr, String oid) {
        if (mbeanName == null) {
            return;
        }
        ArrayList<String> attrs = (ArrayList<String>)this.mbeanToOidTable.get(mbeanName);
        if (attrs == null) {
            attrs = new ArrayList<String>();
            this.mbeanToOidTable.put(mbeanName, attrs);
        }
        attrs.add(oid);
    }

    public void removeAttributes(String mbeanName) {
        if (mbeanName == null) {
            return;
        }
        ArrayList attrs = (ArrayList)this.mbeanToOidTable.get(mbeanName);
        if (attrs == null) {
            return;
        }
        attrs.clear();
        this.mbeanToOidTable.remove(mbeanName);
    }

    public void clear() {
        if (this.mbeanToOidTable.isEmpty()) {
            return;
        }
        Collection col = this.mbeanToOidTable.values();
        for (ArrayList list : col) {
            list.clear();
        }
        this.mbeanToOidTable.clear();
    }

    public ArrayList getAttributes(String mbeanName) {
        if (mbeanName == null) {
            return null;
        }
        ArrayList attrs = (ArrayList)this.mbeanToOidTable.get(mbeanName);
        if (attrs == null) {
            return null;
        }
        return new ArrayList(attrs);
    }
}

