/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.adaptor;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Statistic;
import jeus.management.snmp.adaptor.MIBTable;
import jeus.management.snmp.adaptor.SnmpListener;
import jeus.management.snmp.adaptor.SnmpSupportList;
import jeus.management.snmp.agent.SnmpAgent;
import jeus.management.snmp.core.AsnInteger;
import jeus.management.snmp.core.AsnNull;
import jeus.management.snmp.core.AsnObject;
import jeus.management.snmp.core.AsnOctets;
import jeus.management.snmp.core.AsnSequence;
import jeus.management.snmp.core.LeafOIDListener;
import jeus.management.snmp.core.SnmpException;
import jeus.management.snmp.util.SnmpConstant;
import jeus.security.base.ServiceException;
import jeus.security.spi.LoginService;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_SNMP;

public class SnmpListenerRemote
extends LeafOIDListener
implements SnmpListener {
    String mbeanName;
    SnmpAgent snmpAgent;
    MIBTable mibTable;
    final String JEUS_OID = "1.3.6.1.4.1.14586.100";
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.management");
    private String objName;

    public SnmpListenerRemote(SnmpAgent snmpAgent, String mbeanName, String oid) {
        block2: {
            super(oid);
            this.mbeanName = null;
            this.snmpAgent = null;
            this.mibTable = null;
            this.JEUS_OID = "1.3.6.1.4.1.14586.100";
            this.objName = null;
            this.snmpAgent = snmpAgent;
            this.mbeanName = mbeanName;
            try {
                this.mibTable = snmpAgent.getMIBTable();
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_SNMP.SNMP_29_LEVEL)) break block2;
                logger.log(JeusMessage_SNMP.SNMP_29_LEVEL, JeusMessage_SNMP.SNMP_29, t);
            }
        }
    }

    public SnmpListenerRemote(SnmpAgent snmpAgent, String mbeanName, String oid, String uniqueId, String objName) {
        block2: {
            super(oid, uniqueId);
            this.mbeanName = null;
            this.snmpAgent = null;
            this.mibTable = null;
            this.JEUS_OID = "1.3.6.1.4.1.14586.100";
            this.objName = null;
            this.snmpAgent = snmpAgent;
            this.mbeanName = mbeanName;
            this.objName = objName;
            try {
                this.mibTable = snmpAgent.getMIBTable();
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_SNMP.SNMP_29_LEVEL)) break block2;
                logger.log(JeusMessage_SNMP.SNMP_29_LEVEL, JeusMessage_SNMP.SNMP_29, t);
            }
        }
    }

    public void setLeafOID(String oid) {
        this.leafOID = oid;
    }

    public void setValue(String instanceID, AsnObject value) throws SnmpException {
        block44: {
            int oidIndex = 0;
            if (!SnmpConstant.IS_DYNAMIC_SNMP_OID) {
                oidIndex = this.getOIDIndex(instanceID);
                if (oidIndex > 0) {
                    instanceID = instanceID.substring(0, instanceID.lastIndexOf("."));
                }
                instanceID = instanceID + ".0";
            } else if ((instanceID = this.removeUniqueId(instanceID)) == null) {
                return;
            }
            String attributeName = this.mibTable.getAttributeName(instanceID);
            if (attributeName == null || attributeName.length() == 0) {
                throw new SnmpException(2);
            }
            if (this.isStatisticAttribute(instanceID)) {
                throw new SnmpException(2);
            }
            String methodName = "set" + attributeName;
            if (logger.isLoggable(JeusMessage_SNMP.SNMP_44_LEVEL)) {
                String temp = null;
                temp = "isDynamic : " + SnmpConstant.IS_DYNAMIC_SNMP_OID;
                logger.log(JeusMessage_SNMP.SNMP_44_LEVEL, JeusMessage_SNMP.SNMP_44, (Object)temp);
                temp = "context Engine ID : " + this.contextEngineID;
                logger.log(JeusMessage_SNMP.SNMP_44_LEVEL, JeusMessage_SNMP.SNMP_44, (Object)temp);
                temp = "context Name : " + this.contextName;
                logger.log(JeusMessage_SNMP.SNMP_44_LEVEL, JeusMessage_SNMP.SNMP_44, (Object)temp);
                temp = "OID : " + instanceID;
                logger.log(JeusMessage_SNMP.SNMP_44_LEVEL, JeusMessage_SNMP.SNMP_44, (Object)temp);
                temp = "methodName : " + methodName;
                logger.log(JeusMessage_SNMP.SNMP_44_LEVEL, JeusMessage_SNMP.SNMP_44, (Object)temp);
            }
            Class[] methodClass = new Class[1];
            Object[] methodArgs = new Object[1];
            switch (value.getType()) {
                case 1: {
                    methodClass[0] = Boolean.class;
                    methodArgs[0] = new Boolean(value.toString());
                    break;
                }
                case 2: {
                    methodClass[0] = Integer.class;
                    methodArgs[0] = new Integer(value.toString());
                    break;
                }
                case 3: {
                    methodClass[0] = Boolean.class;
                    methodArgs[0] = value.toString();
                    break;
                }
                case 4: {
                    methodClass[0] = String.class;
                    methodArgs[0] = value.toString();
                    break;
                }
                case 16: {
                    AsnSequence sequenceValue = (AsnSequence)value;
                    block27: for (int i = 0; i < sequenceValue.size(); ++i) {
                        value = sequenceValue.getObj(i);
                        switch (value.getType()) {
                            case 1: {
                                methodClass[i] = Boolean.class;
                                methodArgs[i] = new Boolean(value.toString());
                                continue block27;
                            }
                            case 2: {
                                methodClass[i] = Integer.class;
                                methodArgs[i] = new Integer(value.toString());
                                continue block27;
                            }
                            case 3: {
                                methodClass[i] = Boolean.class;
                                methodArgs[i] = value.toString();
                                continue block27;
                            }
                            case 4: {
                                methodClass[i] = String.class;
                                methodArgs[i] = value.toString();
                                continue block27;
                            }
                            default: {
                                methodClass[i] = String.class;
                                methodArgs[i] = value.toString();
                            }
                        }
                    }
                    break;
                }
                default: {
                    methodClass[0] = String.class;
                    methodArgs[0] = value.toString();
                }
            }
            try {
                MBeanServerConnection mbsc = this.snmpAgent.getMBeanServerConnection();
                Vector<ObjectName> objectNames = null;
                if (!SnmpConstant.IS_DYNAMIC_SNMP_OID) {
                    objectNames = this.queryObjectNames(mbsc);
                } else {
                    objectNames = new Vector<ObjectName>();
                    objectNames.add(new ObjectName(this.objName));
                }
                if (oidIndex == 0) {
                    for (int i = 0; i < objectNames.size(); ++i) {
                        ObjectName objectName = (ObjectName)objectNames.get(i);
                        if (logger.isLoggable(JeusMessage_SNMP.SNMP_44_LEVEL)) {
                            String temp = "objectName : " + objectName.getCanonicalName();
                            logger.log(JeusMessage_SNMP.SNMP_44_LEVEL, JeusMessage_SNMP.SNMP_44, (Object)temp);
                        }
                        try {
                            mbsc.setAttribute(objectName, new Attribute(attributeName, methodArgs[i]));
                            continue;
                        }
                        catch (Throwable t) {
                            try {
                                mbsc.setAttribute(objectName, new Attribute(attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1), methodArgs[i]));
                                continue;
                            }
                            catch (Throwable tt) {
                                if (methodArgs[i] instanceof Integer) {
                                    Long longParam = new Long(((Integer)methodArgs[i]).longValue());
                                    try {
                                        mbsc.setAttribute(objectName, new Attribute(attributeName, longParam));
                                    }
                                    catch (Throwable ttt) {
                                        mbsc.setAttribute(objectName, new Attribute(attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1), longParam));
                                    }
                                    continue;
                                }
                                throw tt;
                            }
                        }
                    }
                    break block44;
                }
                ObjectName objectName = (ObjectName)objectNames.get(oidIndex - 1);
                if (logger.isLoggable(JeusMessage_SNMP.SNMP_44_LEVEL)) {
                    String temp = "objectName : " + objectName.getCanonicalName();
                    logger.log(JeusMessage_SNMP.SNMP_44_LEVEL, JeusMessage_SNMP.SNMP_44, (Object)temp);
                }
                try {
                    mbsc.setAttribute(objectName, new Attribute(attributeName, methodArgs[0]));
                }
                catch (Throwable t) {
                    try {
                        mbsc.setAttribute(objectName, new Attribute(attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1), methodArgs[0]));
                    }
                    catch (Throwable tt) {
                        if (methodArgs[0] instanceof Integer) {
                            Long longParam = new Long(((Integer)methodArgs[0]).longValue());
                            try {
                                mbsc.setAttribute(objectName, new Attribute(attributeName, longParam));
                            }
                            catch (Throwable ttt) {
                                mbsc.setAttribute(objectName, new Attribute(attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1), longParam));
                            }
                            break block44;
                        }
                        throw tt;
                    }
                }
            }
            catch (Throwable t) {
                if (logger.isLoggable(JeusMessage_SNMP.SNMP_30_LEVEL)) {
                    logger.log(JeusMessage_SNMP.SNMP_30_LEVEL, JeusMessage_SNMP.SNMP_30, new Object[]{this.mbeanName, methodName}, t);
                }
                throw new SnmpException(2);
            }
        }
    }

    private Vector tokenize(String str, String delim) {
        Vector<String> tokens = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(str);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken(delim);
            token = token.substring(0, 1).toUpperCase() + token.substring(1);
            tokens.add(token);
        }
        return tokens;
    }

    private Object recursiveInvoke(Object callObject, Vector attributeNameVector, Object[] methodArgs, int depth) throws Exception {
        Class<?>[] methodClass;
        String methodName;
        Object returnObject = null;
        Class<?> callClass = callObject.getClass();
        Method method = callClass.getMethod(methodName = "get" + (String)attributeNameVector.get(depth), methodClass = null);
        returnObject = method.invoke(callObject, methodArgs);
        if (returnObject == null) {
            return "";
        }
        Class<?> returnClass = returnObject.getClass();
        Object[] returnObjectArray = null;
        int endOfDepth = attributeNameVector.size() - 1;
        if (depth == endOfDepth) {
            return returnObject;
        }
        if (returnClass.isArray()) {
            returnObjectArray = (Object[])returnObject;
            Vector<Object> returnValueVector = new Vector<Object>();
            for (int j = 0; j < returnObjectArray.length; ++j) {
                returnObject = this.recursiveInvoke(returnObjectArray[j], attributeNameVector, methodArgs, depth + 1);
                if (depth >= endOfDepth) continue;
                returnValueVector.add(returnObject);
            }
            return returnValueVector;
        }
        returnObject = this.recursiveInvoke(returnObject, attributeNameVector, methodArgs, depth + 1);
        return returnObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsnObject getValue(String instanceID) throws SnmpException {
        String temp;
        String attributeName;
        boolean isStatistic = false;
        int oidIndex = 0;
        if (!SnmpConstant.IS_DYNAMIC_SNMP_OID) {
            oidIndex = this.getOIDIndex(instanceID);
            if (oidIndex > 0) {
                instanceID = instanceID.substring(0, instanceID.lastIndexOf(".")) + ".0";
            }
        } else if ((instanceID = this.removeUniqueId(instanceID)) == null) {
            return new AsnNull();
        }
        if ((attributeName = this.mibTable.getAttributeName(instanceID)) == null) throw new SnmpException(2);
        if (attributeName.length() == 0) {
            throw new SnmpException(2);
        }
        Vector attributeNameVector = this.tokenize(attributeName, "-");
        attributeName = (String)attributeNameVector.get(0);
        attributeName = attributeName.substring(0, 1).toLowerCase() + attributeName.substring(1);
        isStatistic = this.isStatisticAttribute(instanceID);
        String methodName = "get" + attributeName;
        if (logger.isLoggable(JeusMessage_SNMP.SNMP_43_LEVEL)) {
            String temp2 = null;
            temp2 = "isDynamic : " + SnmpConstant.IS_DYNAMIC_SNMP_OID;
            logger.log(JeusMessage_SNMP.SNMP_43_LEVEL, JeusMessage_SNMP.SNMP_43, (Object)temp2);
            temp2 = "context Engine ID : " + this.contextEngineID;
            logger.log(JeusMessage_SNMP.SNMP_43_LEVEL, JeusMessage_SNMP.SNMP_43, (Object)temp2);
            temp2 = "context Name : " + this.contextName;
            logger.log(JeusMessage_SNMP.SNMP_43_LEVEL, JeusMessage_SNMP.SNMP_43, (Object)temp2);
            temp2 = "OID : " + instanceID;
            logger.log(JeusMessage_SNMP.SNMP_43_LEVEL, JeusMessage_SNMP.SNMP_43, (Object)temp2);
            temp2 = "isStatistic : " + isStatistic;
            logger.log(JeusMessage_SNMP.SNMP_43_LEVEL, JeusMessage_SNMP.SNMP_43, (Object)temp2);
            temp2 = "methodName : " + methodName;
            logger.log(JeusMessage_SNMP.SNMP_43_LEVEL, JeusMessage_SNMP.SNMP_43, (Object)temp2);
        }
        Object[] methodArgs = null;
        Object returnObject = null;
        Vector<Object> returnVector = new Vector<Object>();
        ObjectName objectName = null;
        try {
            try {
                LoginService.loginCodeSubject();
                MBeanServerConnection mbsc = this.snmpAgent.getMBeanServerConnection();
                Vector<ObjectName> objectNames = null;
                if (!SnmpConstant.IS_DYNAMIC_SNMP_OID) {
                    objectNames = this.queryObjectNames(mbsc);
                } else {
                    objectNames = new Vector<ObjectName>();
                    objectNames.add(new ObjectName(this.objName));
                }
                Enumeration e = objectNames.elements();
                while (e.hasMoreElements()) {
                    Class<?> returnClass;
                    block52: {
                        block50: {
                            block51: {
                                Object temp3;
                                block49: {
                                    objectName = (ObjectName)e.nextElement();
                                    if (logger.isLoggable(JeusMessage_SNMP.SNMP_43_LEVEL)) {
                                        String temp4 = "objectName : " + objectName.getCanonicalName();
                                        logger.log(JeusMessage_SNMP.SNMP_43_LEVEL, JeusMessage_SNMP.SNMP_43, (Object)temp4);
                                    }
                                    if (isStatistic) {
                                        Object callObject = mbsc.getAttribute(objectName, "stats");
                                        returnObject = this.recursiveInvoke(callObject, attributeNameVector, methodArgs, 0);
                                    } else {
                                        try {
                                            returnObject = mbsc.getAttribute(objectName, attributeName);
                                            if (returnObject instanceof Statistic) {
                                                returnObject = this.recursiveInvoke(returnObject, attributeNameVector, methodArgs, 1);
                                            }
                                        }
                                        catch (Throwable t) {
                                            try {
                                                returnObject = mbsc.getAttribute(objectName, attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1));
                                                if (returnObject instanceof Statistic) {
                                                    returnObject = this.recursiveInvoke(returnObject, attributeNameVector, methodArgs, 1);
                                                }
                                            }
                                            catch (Throwable tt) {
                                                if (logger.isLoggable(JeusMessage_SNMP.SNMP_30_LEVEL)) {
                                                    logger.log(JeusMessage_SNMP.SNMP_30_LEVEL, JeusMessage_SNMP.SNMP_30, new Object[]{this.mbeanName, methodName}, tt);
                                                }
                                                tt.printStackTrace();
                                                throw new SnmpException(2);
                                            }
                                        }
                                    }
                                    returnClass = null;
                                    if (returnObject == null) break block49;
                                    returnClass = returnObject.getClass();
                                    if (!(returnObject instanceof List)) break block50;
                                    break block51;
                                }
                                if (logger.isLoggable(JeusMessage_SNMP.SNMP_43_LEVEL)) {
                                    temp3 = "return : AsnNull";
                                    logger.log(JeusMessage_SNMP.SNMP_43_LEVEL, JeusMessage_SNMP.SNMP_43, temp3);
                                }
                                temp3 = new AsnNull();
                                return temp3;
                            }
                            returnObject = ((List)returnObject).toArray();
                            returnClass = returnObject.getClass();
                            break block52;
                        }
                        if (returnObject instanceof Set) {
                            returnObject = ((Set)returnObject).toArray();
                            returnClass = returnObject.getClass();
                        } else if (returnObject instanceof Map) {
                            returnObject = ((Map)returnObject).entrySet().toArray();
                            returnClass = returnObject.getClass();
                        }
                    }
                    if (returnObject instanceof String) {
                        String tempReturnString = (String)returnObject;
                        if (!this.isObjectNameAttribute(instanceID) && tempReturnString.startsWith("JEUS:")) {
                            ObjectName tempObjectName = new ObjectName(tempReturnString);
                            returnObject = tempObjectName.getKeyProperty("name");
                        }
                    } else if (returnClass.isArray()) {
                        Object[] returnObjectArray = (Object[])returnObject;
                        Vector<Object> tempReturnValueVector = new Vector<Object>();
                        for (int i = 0; i < returnObjectArray.length; ++i) {
                            returnObject = returnObjectArray[i];
                            if (returnObject instanceof String) {
                                String tempReturnString = (String)returnObject;
                                if (tempReturnString.startsWith("JEUS:")) {
                                    ObjectName tempObjectName = new ObjectName(tempReturnString);
                                    returnObject = tempObjectName.getKeyProperty("name");
                                }
                            } else if (returnObject instanceof Object[]) {
                                Object[] returnObjectArrayArray = (Object[])returnObject;
                                Vector<Object> tempReturnValueVectorVector = new Vector<Object>();
                                for (int j = 0; j < returnObjectArrayArray.length; ++j) {
                                    Object returnObjectObject = returnObjectArrayArray[j];
                                    tempReturnValueVectorVector.add(returnObjectObject);
                                }
                                returnObject = tempReturnValueVectorVector;
                            }
                            tempReturnValueVector.add(returnObject);
                        }
                        returnObject = tempReturnValueVector;
                    }
                    returnVector.add(returnObject);
                }
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            finally {
                LoginService.logout();
            }
        }
        catch (Throwable t) {
            if (!logger.isLoggable(JeusMessage_SNMP.SNMP_30_LEVEL)) throw new SnmpException(2);
            logger.log(JeusMessage_SNMP.SNMP_30_LEVEL, JeusMessage_SNMP.SNMP_30, new Object[]{this.mbeanName, methodName}, t);
            throw new SnmpException(2);
        }
        String returnString = returnVector.toString();
        if (!SnmpConstant.IS_DYNAMIC_SNMP_OID) {
            if (oidIndex == 9999) {
                return new AsnInteger(returnVector.size());
            }
            if (oidIndex != 0) {
                Object tempReturnObject;
                try {
                    tempReturnObject = returnVector.get(oidIndex - 1);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return new AsnNull();
                }
                if (tempReturnObject == null) return new AsnNull();
                returnString = tempReturnObject.toString();
            }
        }
        if (returnString.length() <= AsnObject.MAX_PACKET_SIZE) {
            if (!logger.isLoggable(JeusMessage_SNMP.SNMP_43_LEVEL)) return new AsnOctets(returnString);
            temp = "return : " + returnString;
            logger.log(JeusMessage_SNMP.SNMP_43_LEVEL, JeusMessage_SNMP.SNMP_43, (Object)temp);
            return new AsnOctets(returnString);
        }
        if (logger.isLoggable(JeusMessage_SNMP.SNMP_31_LEVEL)) {
            logger.log(JeusMessage_SNMP.SNMP_31_LEVEL, JeusMessage_SNMP.SNMP_31);
        }
        if (!logger.isLoggable(JeusMessage_SNMP.SNMP_43_LEVEL)) return new AsnOctets(returnString.substring(0, AsnObject.MAX_PACKET_SIZE - 196));
        temp = "return : " + returnString.substring(0, AsnObject.MAX_PACKET_SIZE - 196);
        logger.log(JeusMessage_SNMP.SNMP_43_LEVEL, JeusMessage_SNMP.SNMP_43, (Object)temp);
        return new AsnOctets(returnString.substring(0, AsnObject.MAX_PACKET_SIZE - 196));
    }

    public boolean isStatisticAttribute(String instanceID) throws SnmpException {
        return this.getLastOID(instanceID) > 100;
    }

    public boolean isObjectNameAttribute(String instanceID) throws SnmpException {
        return this.getLastOID(instanceID) == 1;
    }

    public int getLastOID(String instanceID) throws SnmpException {
        int enterpriseIndex = instanceID.indexOf("1.3.6.1.4.1.14586.100");
        if (enterpriseIndex == -1) {
            throw new SnmpException(3);
        }
        String lastOID = instanceID.substring(enterpriseIndex);
        lastOID = lastOID.substring(22);
        int lastIndex = (lastOID = lastOID.substring(lastOID.indexOf(".") + 1)).indexOf(".");
        if (lastIndex > 0) {
            lastOID = lastOID.substring(0, lastIndex);
        }
        int attributeOID = Integer.valueOf(lastOID);
        return attributeOID;
    }

    public int getOIDIndex(String instanceID) throws SnmpException {
        int enterpriseIndex = instanceID.indexOf("1.3.6.1.4.1.14586.100");
        if (enterpriseIndex == -1) {
            throw new SnmpException(3);
        }
        String lastOID = instanceID.substring(enterpriseIndex);
        lastOID = lastOID.substring(22);
        int index = (lastOID = lastOID.substring(lastOID.indexOf(".") + 1)).indexOf(".");
        if (index == -1) {
            return 0;
        }
        int lastIndex = (lastOID = lastOID.substring(index + 1)).indexOf(".");
        if (lastIndex > 0) {
            lastOID = lastOID.substring(0, lastIndex);
        }
        int attributeOID = Integer.valueOf(lastOID);
        return attributeOID;
    }

    public void undo() throws SnmpException {
    }

    public void commit() throws SnmpException {
    }

    private Vector queryObjectNames(MBeanServerConnection mbsc) throws MalformedObjectNameException, IOException {
        Vector<ObjectName> objectNames = new Vector<ObjectName>();
        int idx = this.mbeanName.lastIndexOf("MBean");
        if (idx > 0) {
            this.mbeanName = this.mbeanName.substring(0, idx);
        }
        String queryString = (String)SnmpSupportList.classes.get(this.mbeanName);
        ObjectName scope = new ObjectName("JEUS:" + queryString + ",*");
        Set<ObjectName> set = mbsc.queryNames(scope, null);
        idx = 0;
        for (ObjectName obj : set) {
            objectNames.add(obj);
        }
        return objectNames;
    }

    private String removeUniqueId(String oid) {
        String remainOid = null;
        String retOid = null;
        try {
            remainOid = oid.substring("1.3.6.1.4.1.14586.100".length() + 1);
        }
        catch (Exception e) {
            return null;
        }
        int dotIndex = remainOid.indexOf(46);
        if (dotIndex == -1) {
            return null;
        }
        if ((dotIndex = remainOid.indexOf(46, dotIndex + 1)) == -1) {
            return null;
        }
        try {
            retOid = oid.substring(0, "1.3.6.1.4.1.14586.100".length() + dotIndex + 1);
        }
        catch (Exception e) {
            return null;
        }
        return retOid;
    }
}

