/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.agent;

import java.io.IOException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.descriptor.jeusserver.JMXManagerDescriptor;
import jeus.management.JMXManager;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.management.snmp.adaptor.MIBTable;
import jeus.management.snmp.adaptor.ObjectNameTable;
import jeus.management.snmp.adaptor.SnmpListenerRemote;
import jeus.management.snmp.adaptor.SnmpSecurity;
import jeus.management.snmp.adaptor.SnmpSupportList;
import jeus.management.snmp.agent.SnmpAgent;
import jeus.management.snmp.agent.SnmpAgentForRMI;
import jeus.management.snmp.core.AsnInteger;
import jeus.management.snmp.core.AsnNameValuePair;
import jeus.management.snmp.core.AsnOID;
import jeus.management.snmp.core.AsnObject;
import jeus.management.snmp.core.SnmpClient;
import jeus.management.snmp.core.SnmpGetSetPdu;
import jeus.management.snmp.core.SnmpMessage;
import jeus.management.snmp.core.SnmpServer;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_SNMP;

public class SnmpAgentForRMIImpl
implements SnmpAgentForRMI,
SnmpAgent {
    public static SnmpAgentForRMIImpl snmpAgent = null;
    public static SnmpServer svr = null;
    public static MIBTable mibTable = new MIBTable();
    public static ObjectNameTable objectNameTable = new ObjectNameTable();
    static SnmpMessage snmpMessage;
    static SnmpGetSetPdu trapPdu;
    static int defaultPort;
    static long defaultSnmpVersion;
    boolean securityEnabled = false;
    static Vector trapDemonIpAddresses;
    static Vector trapDemonPorts;
    static String defaultIP;
    static String enterpriseOid;
    private boolean remote = false;
    private static boolean working;
    protected static final JeusLogger logger;
    private ObjectName mbeanName;
    private static MBeanServerConnection mbsc;

    public SnmpAgentForRMIImpl(int portNumber) throws RemoteException {
        this(portNumber, defaultSnmpVersion, AsnObject.MAX_PACKET_SIZE, false);
    }

    public SnmpAgentForRMIImpl(int portNumber, long snmpVersion, int maxPacketSize, boolean securityEnable) throws RemoteException {
        this(portNumber, snmpVersion, maxPacketSize, securityEnable, trapDemonIpAddresses, trapDemonPorts);
    }

    public SnmpAgentForRMIImpl(int portNumber, long snmpVersion, int maxPacketSize, boolean securityEnable, Vector tdIpAddresses, Vector tdPorts) throws RemoteException {
        try {
            svr = new SnmpServer("*", "SNMP Agent for JEUS", portNumber, this);
            defaultPort = portNumber;
            this.setSnmpVersion(snmpVersion);
            this.setMaxPacketSize(maxPacketSize);
            this.setSecurityEnable(securityEnable);
            this.setTrapDemonIpAddresses(tdIpAddresses);
            this.setTrapDemonPorts(tdPorts);
            this.export();
            snmpAgent = this;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SnmpAgentForRMIImpl(int portNumber, JMXManagerDescriptor desc) throws RemoteException {
        try {
            svr = new SnmpServer("*", "SNMP Agent for JEUS", portNumber, desc, this);
            defaultPort = portNumber;
            this.setSnmpVersion(desc.getSNMPVersion());
            this.setMaxPacketSize(desc.getSNMPMaxPacketSize());
            this.setSecurityEnable(desc.getSNMPSecurity());
            this.setTrapDemonIpAddresses(desc.getTrapDemonIpAddresses());
            this.setTrapDemonPorts(desc.getTrapDemonPorts());
            this.export();
            snmpAgent = this;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void putOID(String oid, String mbeanName, String attributeName) throws RemoteException {
        mibTable.put(oid, mbeanName, attributeName);
    }

    public void addEventListener(String mbeanName, String oid) throws RemoteException {
        this.getSnmpServer().addEventListener(new SnmpListenerRemote(this, mbeanName, oid));
    }

    public void putObjectName(String mbeanName, ObjectName objectName) throws RemoteException {
        objectNameTable.put(mbeanName, objectName);
    }

    public void removeObjectName(String mbeanName, ObjectName objectName) throws RemoteException {
        objectNameTable.remove(mbeanName, objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        SnmpAgentForRMIImpl snmpAgentForRMIImpl = this;
        synchronized (snmpAgentForRMIImpl) {
            block6: {
                try {
                    mbsc = MEJBUtility.getMEJBUtility();
                    svr.initialize(this.mbeanName);
                    svr.start();
                    this.registerSnmpSupport(JMXManager.getMbeanServer());
                    working = true;
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_SNMP.SNMP_1_LEVEL)) break block6;
                    logger.log(JeusMessage_SNMP.SNMP_1_LEVEL, JeusMessage_SNMP.SNMP_1, t);
                }
            }
            if (logger.isLoggable(JeusMessage_SNMP.SNMP_4_LEVEL)) {
                logger.log(JeusMessage_SNMP.SNMP_4_LEVEL, JeusMessage_SNMP.SNMP_4, (Object)String.valueOf(defaultPort));
            }
        }
    }

    public void stop() {
        block3: {
            try {
                this.unexport();
                mbsc = null;
                svr.cancel();
                working = false;
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_SNMP.SNMP_5_LEVEL)) break block3;
                logger.log(JeusMessage_SNMP.SNMP_5_LEVEL, JeusMessage_SNMP.SNMP_5, t);
            }
        }
        if (logger.isLoggable(JeusMessage_SNMP.SNMP_6_LEVEL)) {
            logger.log(JeusMessage_SNMP.SNMP_6_LEVEL, JeusMessage_SNMP.SNMP_6, (Object)String.valueOf(defaultPort));
        }
    }

    public boolean isWorking() {
        return working;
    }

    public SnmpAgentForRMI export() throws RemoteException {
        SnmpAgentForRMI stub = (SnmpAgentForRMI)((Object)UnicastRemoteObject.exportObject(this));
        this.remote = true;
        return stub;
    }

    public void unexport() throws RemoteException {
        if (this.remote) {
            UnicastRemoteObject.unexportObject(this, true);
        }
    }

    public static SnmpAgentForRMI getSnmpAgent() {
        return snmpAgent;
    }

    public SnmpServer getSnmpServer() throws RemoteException {
        return svr;
    }

    public MIBTable getMIBTable() {
        return mibTable;
    }

    public ObjectNameTable getObjectNameTable() throws RemoteException {
        return objectNameTable;
    }

    public long getSnmpVersion() {
        return defaultSnmpVersion;
    }

    public int getMaxPacketSize() {
        return AsnObject.MAX_PACKET_SIZE;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public Vector getTrapDemonIpAddress() {
        return trapDemonIpAddresses;
    }

    public Vector getTrapDemonPorts() {
        return trapDemonPorts;
    }

    public void setSnmpVersion(long snmpVersion) {
        defaultSnmpVersion = snmpVersion;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        if (maxPacketSize < 256) {
            maxPacketSize = 256;
        }
        AsnObject.setMaxPacketSize(maxPacketSize);
    }

    public void setSecurityEnable(boolean securityEnable) {
        if (securityEnable) {
            SnmpSecurity security = new SnmpSecurity();
            svr.addSnmpSecurityInterface(security);
            this.securityEnabled = true;
        } else {
            svr.addSnmpSecurityInterface(null);
            this.securityEnabled = false;
        }
    }

    public void setTrapDemonIpAddresses(Vector tdIpAddresses) {
        trapDemonIpAddresses = tdIpAddresses;
    }

    public void setTrapDemonPorts(Vector tdPorts) {
        trapDemonPorts = tdPorts;
    }

    public void sendTrap(String trapOid, AsnNameValuePair[] asnNameValuePairs) throws RemoteException {
        snmpMessage = new SnmpMessage();
        trapPdu = new SnmpGetSetPdu();
        trapPdu.setMsgType((byte)-89);
        trapPdu.setReqId(1L);
        snmpMessage.setPdu(trapPdu);
        snmpMessage.setSnmpVersion(3L);
        snmpMessage.setUserName("testuser".getBytes());
        snmpMessage.setAuthMode(true);
        snmpMessage.setAuthAlgorithm(1);
        snmpMessage.setAuthPassword("testtest".getBytes());
        snmpMessage.setContextEngineID("test engine");
        snmpMessage.setContextName("test name");
        trapPdu.addNameValuePair(new AsnNameValuePair("1.3.6.1.2.1.1.3", new AsnInteger(System.currentTimeMillis())));
        trapPdu.addNameValuePair(new AsnNameValuePair("1.3.6.1.6.3.1.1.4.1", new AsnOID(trapOid)));
        int lengthOfValues = asnNameValuePairs.length;
        if (lengthOfValues != 0) {
            if (asnNameValuePairs.length > 0) {
                for (int i = 0; i < lengthOfValues; ++i) {
                    trapPdu.addNameValuePair(asnNameValuePairs[i]);
                }
            } else {
                throw new RemoteException("message length is not propper!!");
            }
        }
        trapPdu.addNameValuePair(new AsnNameValuePair("1.3.6.1.6.3.1.1.4.3", new AsnOID(enterpriseOid)));
        SnmpClient client = new SnmpClient();
        try {
            for (int i = 0; i < trapDemonIpAddresses.size(); ++i) {
                client.sendSnmpMessage((String)trapDemonIpAddresses.get(i), (Integer)trapDemonPorts.get(i), snmpMessage);
            }
        }
        catch (IOException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return mbsc;
    }

    public void registerSnmpSupport(MBeanServerConnection server) throws IOException {
        Enumeration e = SnmpSupportList.classes.keys();
        while (e.hasMoreElements()) {
            String className = "jeus.management.snmp.adaptor." + e.nextElement() + "SnmpSupport";
            try {
                Class.forName(className).newInstance();
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_SNMP.SNMP_4_LEVEL)) continue;
                logger.log(JeusMessage_SNMP.SNMP_4_LEVEL, JeusMessage_SNMP.SNMP_4, (Object)className, t);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            defaultPort = Integer.parseInt(args[0]);
        }
        try {
            snmpAgent = new SnmpAgentForRMIImpl(defaultPort);
            System.setSecurityManager(new RMISecurityManager());
            snmpAgent.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Thread.sleep(10000L);
        System.out.println("\nClose the connection to the server");
        System.out.println("\nBye! Bye!");
    }

    public void setMbeanName(ObjectName objectName) {
        this.mbeanName = objectName;
    }

    static {
        defaultPort = 161;
        defaultSnmpVersion = 3L;
        trapDemonIpAddresses = new Vector();
        trapDemonPorts = new Vector();
        defaultIP = "127.0.0.1";
        enterpriseOid = "1.3.6.1.4.1.14586";
        working = false;
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.management");
    }
}

