/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.agent;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import jeus.descriptor.jeusserver.JMXManagerDescriptor;
import jeus.management.JMXConstants;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.management.snmp.adaptor.MIBTable;
import jeus.management.snmp.adaptor.MbeanToOidTable;
import jeus.management.snmp.adaptor.SnmpListenerRemote;
import jeus.management.snmp.adaptor.SnmpRegister;
import jeus.management.snmp.adaptor.SnmpSecurity;
import jeus.management.snmp.agent.ObjNameTableElement;
import jeus.management.snmp.agent.SnmpAgent;
import jeus.management.snmp.agent.SnmpTimerTask;
import jeus.management.snmp.core.AsnInteger;
import jeus.management.snmp.core.AsnNameValuePair;
import jeus.management.snmp.core.AsnOID;
import jeus.management.snmp.core.AsnObject;
import jeus.management.snmp.core.SnmpClient;
import jeus.management.snmp.core.SnmpGetSetPdu;
import jeus.management.snmp.core.SnmpMessage;
import jeus.management.snmp.core.SnmpServer;
import jeus.management.snmp.listener.HandbackElement;
import jeus.management.snmp.listener.SnmpFilter;
import jeus.management.snmp.listener.SnmpListener;
import jeus.management.snmp.util.SnmpConstant;
import jeus.management.snmp.util.UtilSnmpOidMaker;
import jeus.util.ScheduledExecutor;
import jeus.util.StringUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_SNMP;

public class SnmpAgentImpl
implements SnmpAgent {
    private boolean working;
    private SnmpServer svr;
    private ObjectName mbeanName;
    private static String enterpriseOid = "1.3.6.1.4.1.14586";
    private static String registerClassName = "jeus.management.snmp.adaptor.SnmpRegister";
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.management");
    private int defaultPort;
    private long defaultSnmpVersion;
    private boolean securityEnabled;
    private Vector trapDemonIpAddresses;
    private Vector trapDemonPorts;
    private SnmpRegister snmpRegister;
    private MbeanToOidTable snmpSupportMbeanTable;
    private SnmpTimerTask snmpTimerTask;
    private Hashtable objNameTablePerMserver;
    private MIBTable mibTable;
    private String managerName;
    private MEJBUtility mbsc;

    public SnmpAgentImpl(int portNumber, JMXManagerDescriptor desc, String managerName) {
        block2: {
            this.working = false;
            this.svr = null;
            this.defaultPort = 161;
            this.defaultSnmpVersion = 3L;
            this.securityEnabled = false;
            this.trapDemonIpAddresses = new Vector();
            this.trapDemonPorts = new Vector();
            this.snmpSupportMbeanTable = new MbeanToOidTable();
            this.snmpTimerTask = null;
            this.objNameTablePerMserver = new Hashtable();
            this.mibTable = new MIBTable();
            this.mbsc = null;
            try {
                this.svr = new SnmpServer("*", "SNMP Agent for JEUS", portNumber, desc, this);
                this.defaultPort = portNumber;
                this.setSnmpVersion(desc.getSNMPVersion());
                this.setMaxPacketSize(desc.getSNMPMaxPacketSize());
                this.setSecurityEnable(desc.getSNMPSecurity());
                this.setTrapDemonIpAddresses(desc.getTrapDemonIpAddresses());
                this.setTrapDemonPorts(desc.getTrapDemonPorts());
                this.managerName = managerName;
                this.registerSnmpFromMib();
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_SNMP.SNMP_7_LEVEL)) break block2;
                logger.log(JeusMessage_SNMP.SNMP_7_LEVEL, JeusMessage_SNMP.SNMP_7, (Object)"SNMP Agent", ex);
            }
        }
    }

    public void start() throws IOException {
        if (this.working) {
            if (logger.isLoggable(JeusMessage_SNMP.SNMP_1_LEVEL)) {
                logger.log(JeusMessage_SNMP.SNMP_1_LEVEL, JeusMessage_SNMP.SNMP_1);
            }
            return;
        }
        this.working = true;
        if (this.svr == null) {
            if (logger.isLoggable(JeusMessage_SNMP.SNMP_1_LEVEL)) {
                logger.log(JeusMessage_SNMP.SNMP_1_LEVEL, JeusMessage_SNMP.SNMP_1, (Throwable)new Exception("already started or snmp server is null"));
            }
            this.stop();
            return;
        }
        try {
            this.mbsc = MEJBUtility.getMEJBUtility();
            if (this.mbsc == null) {
                if (logger.isLoggable(JeusMessage_SNMP.SNMP_1_LEVEL)) {
                    logger.log(JeusMessage_SNMP.SNMP_1_LEVEL, JeusMessage_SNMP.SNMP_1, (Throwable)new Exception("MEJBUtility is null"));
                }
                this.stop();
                return;
            }
            MBeanServerConnection mserver = this.mbsc.getRemoteMBeanServer(this.managerName);
            if (mserver == null) {
                if (logger.isLoggable(JeusMessage_SNMP.SNMP_1_LEVEL)) {
                    logger.log(JeusMessage_SNMP.SNMP_1_LEVEL, JeusMessage_SNMP.SNMP_1, (Throwable)new Exception("MEJBUtility is null"));
                }
                this.stop();
                return;
            }
            this.registerSnmpFromMbeanServer(this.managerName, mserver);
            this.snmpTimerTask = new SnmpTimerTask(this.mbsc, this);
            ScheduledExecutor.getInstance().scheduleWithFixedDelay(this.snmpTimerTask, SnmpConstant.SNMP_TIMER_TASK_DELAY, SnmpConstant.SNMP_TIMER_TASK_PERIOD);
            if (logger.isLoggable(JeusMessage_SNMP.SNMP_45_LEVEL)) {
                logger.log(JeusMessage_SNMP.SNMP_45_LEVEL, JeusMessage_SNMP.SNMP_45, (Object[])new String[]{String.valueOf(SnmpConstant.SNMP_TIMER_TASK_DELAY), String.valueOf(SnmpConstant.SNMP_TIMER_TASK_PERIOD)});
            }
            this.svr.initialize(this.mbeanName);
            this.svr.start();
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_SNMP.SNMP_1_LEVEL)) {
                logger.log(JeusMessage_SNMP.SNMP_1_LEVEL, JeusMessage_SNMP.SNMP_1, t);
            }
            this.stop();
            return;
        }
        if (logger.isLoggable(JeusMessage_SNMP.SNMP_4_LEVEL)) {
            logger.log(JeusMessage_SNMP.SNMP_4_LEVEL, JeusMessage_SNMP.SNMP_4, (Object)String.valueOf(this.defaultPort));
        }
    }

    public void stop() {
        block6: {
            if (!this.working) {
                return;
            }
            if (this.snmpTimerTask != null) {
                this.snmpTimerTask.cancel();
            }
            if (this.svr != null) {
                try {
                    this.svr.cancel();
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_SNMP.SNMP_5_LEVEL)) break block6;
                    logger.log(JeusMessage_SNMP.SNMP_5_LEVEL, JeusMessage_SNMP.SNMP_5, t);
                }
            }
        }
        this.unregisterSnmpFromAllMbeanServer();
        this.unregisterSnmpFromMib();
        this.mbsc = null;
        this.working = false;
        if (logger.isLoggable(JeusMessage_SNMP.SNMP_6_LEVEL)) {
            logger.log(JeusMessage_SNMP.SNMP_6_LEVEL, JeusMessage_SNMP.SNMP_6, (Object)String.valueOf(this.defaultPort));
        }
    }

    public void putOID(String oid, String mbeanName, String attributeName) {
        this.mibTable.put(oid, mbeanName, attributeName);
        this.snmpSupportMbeanTable.putAttribute(mbeanName, attributeName, oid);
    }

    public void removeAllOID() {
        this.mibTable.clear();
        this.snmpSupportMbeanTable.clear();
    }

    public void addEventListener(String mbeanName, String oid, String uniqueId, String objName) {
        if (this.svr != null && oid != null && uniqueId != null && objName != null) {
            this.svr.addEventListener(new SnmpListenerRemote(this, mbeanName, oid, uniqueId, objName));
        }
    }

    public void removeEventListener(String oid, String uniqueId) {
        if (this.svr != null && oid != null && uniqueId != null) {
            this.svr.removeEventListener(oid, uniqueId);
        }
    }

    public SnmpServer getSnmpServer() {
        return this.svr;
    }

    public MIBTable getMIBTable() {
        return this.mibTable;
    }

    public long getSnmpVersion() {
        return this.defaultSnmpVersion;
    }

    public int getMaxPacketSize() {
        return AsnObject.MAX_PACKET_SIZE;
    }

    public Vector getTrapDemonIpAddress() {
        return this.trapDemonIpAddresses;
    }

    public Vector getTrapDemonPorts() {
        return this.trapDemonPorts;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public boolean isWorking() {
        return this.working;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.mbsc;
    }

    public void setSnmpVersion(long snmpVersion) {
        this.defaultSnmpVersion = snmpVersion;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        if (maxPacketSize < 256) {
            maxPacketSize = 256;
        }
        AsnObject.setMaxPacketSize(maxPacketSize);
    }

    public void setTrapDemonIpAddresses(Vector tdIpAddresses) {
        this.trapDemonIpAddresses = tdIpAddresses;
    }

    public void setTrapDemonPorts(Vector tdPorts) {
        this.trapDemonPorts = tdPorts;
    }

    public void setSecurityEnable(boolean securityEnable) {
        if (securityEnable) {
            SnmpSecurity security = new SnmpSecurity();
            this.svr.addSnmpSecurityInterface(security);
            this.securityEnabled = true;
        } else {
            this.svr.addSnmpSecurityInterface(null);
            this.securityEnabled = false;
        }
    }

    public void setMbeanName(ObjectName objectName) {
        this.mbeanName = objectName;
    }

    public void sendTrap(String trapOid, AsnNameValuePair[] asnNameValuePairs) throws Exception {
        SnmpMessage snmpMessage = null;
        SnmpGetSetPdu trapPdu = null;
        snmpMessage = new SnmpMessage();
        trapPdu = new SnmpGetSetPdu();
        trapPdu.setMsgType((byte)-89);
        trapPdu.setReqId(1L);
        snmpMessage.setPdu(trapPdu);
        snmpMessage.setSnmpVersion(3L);
        snmpMessage.setUserName("testuser".getBytes());
        snmpMessage.setAuthMode(true);
        snmpMessage.setAuthAlgorithm(1);
        snmpMessage.setAuthPassword("testtest".getBytes());
        snmpMessage.setContextEngineID("test engine");
        snmpMessage.setContextName("test name");
        trapPdu.addNameValuePair(new AsnNameValuePair("1.3.6.1.2.1.1.3", new AsnInteger(System.currentTimeMillis())));
        trapPdu.addNameValuePair(new AsnNameValuePair("1.3.6.1.6.3.1.1.4.1", new AsnOID(trapOid)));
        int lengthOfValues = asnNameValuePairs.length;
        if (lengthOfValues != 0) {
            if (asnNameValuePairs.length > 0) {
                for (int i = 0; i < lengthOfValues; ++i) {
                    trapPdu.addNameValuePair(asnNameValuePairs[i]);
                }
            } else {
                throw new Exception("message length is not propper!!");
            }
        }
        trapPdu.addNameValuePair(new AsnNameValuePair("1.3.6.1.6.3.1.1.4.3", new AsnOID(enterpriseOid)));
        SnmpClient client = new SnmpClient();
        for (int i = 0; i < this.trapDemonIpAddresses.size(); ++i) {
            client.sendSnmpMessage((String)this.trapDemonIpAddresses.get(i), (Integer)this.trapDemonPorts.get(i), snmpMessage);
        }
    }

    private void registerSnmpFromMib() {
        block4: {
            if (this.snmpRegister != null) {
                return;
            }
            try {
                Class<?> cls = Class.forName(registerClassName);
                Constructor<?>[] constructors = cls.getConstructors();
                Object[] params = new Object[]{this};
                this.snmpRegister = (SnmpRegister)constructors[0].newInstance(params);
                this.snmpRegister.loadMibInfomation();
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_SNMP.SNMP_33_LEVEL)) break block4;
                logger.log(JeusMessage_SNMP.SNMP_33_LEVEL, JeusMessage_SNMP.SNMP_33, t);
            }
        }
        if (logger.isLoggable(JeusMessage_SNMP.SNMP_34_LEVEL)) {
            logger.log(JeusMessage_SNMP.SNMP_34_LEVEL, JeusMessage_SNMP.SNMP_34);
        }
    }

    private void unregisterSnmpFromMib() {
        if (this.snmpRegister == null) {
            return;
        }
        this.snmpRegister.unloadMibInformation();
        this.snmpRegister = null;
        if (logger.isLoggable(JeusMessage_SNMP.SNMP_35_LEVEL)) {
            logger.log(JeusMessage_SNMP.SNMP_35_LEVEL, JeusMessage_SNMP.SNMP_35);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSnmpFromMbeanServer(String mbeanServerName, MBeanServerConnection mbeanServer) {
        if (this.mbsc == null || mbeanServerName == null || mbeanServer == null) {
            return;
        }
        ObjectName scope = null;
        try {
            scope = new ObjectName("JEUS:*");
        }
        catch (MalformedObjectNameException e) {
            if (logger.isLoggable(JeusMessage_SNMP.SNMP_38_LEVEL)) {
                logger.log(JeusMessage_SNMP.SNMP_38_LEVEL, JeusMessage_SNMP.SNMP_38, (Object[])new String[]{mbeanServerName, mbeanServer.toString()}, (Throwable)e);
            }
            return;
        }
        Hashtable<String, ObjNameTableElement> allObjNames = null;
        Set<ObjectInstance> allObjSet = null;
        try {
            HandbackElement handback = new HandbackElement(mbeanServer, mbeanServerName);
            try {
                mbeanServer.addNotificationListener(JMXConstants.MBEAN_SERVER_DELEGATE_MBEAN, new SnmpListener(this, this.objNameTablePerMserver, this.snmpSupportMbeanTable), (NotificationFilter)new SnmpFilter(), (Object)handback);
            }
            catch (InstanceNotFoundException e) {
                if (logger.isLoggable(JeusMessage_SNMP.SNMP_36_LEVEL)) {
                    logger.log(JeusMessage_SNMP.SNMP_36_LEVEL, JeusMessage_SNMP.SNMP_36, (Object[])new String[]{mbeanServerName, mbeanServer.toString()}, (Throwable)e);
                }
                return;
            }
            catch (IOException e) {
                if (logger.isLoggable(JeusMessage_SNMP.SNMP_36_LEVEL)) {
                    logger.log(JeusMessage_SNMP.SNMP_36_LEVEL, JeusMessage_SNMP.SNMP_36, (Object[])new String[]{mbeanServerName, mbeanServer.toString()}, (Throwable)e);
                }
                return;
            }
            if (logger.isLoggable(JeusMessage_SNMP.SNMP_37_LEVEL)) {
                logger.log(JeusMessage_SNMP.SNMP_37_LEVEL, JeusMessage_SNMP.SNMP_37, (Object[])new String[]{mbeanServerName, mbeanServer.toString()});
            }
            allObjSet = mbeanServer.queryMBeans(scope, null);
        }
        catch (IOException e) {
            if (logger.isLoggable(JeusMessage_SNMP.SNMP_38_LEVEL)) {
                logger.log(JeusMessage_SNMP.SNMP_38_LEVEL, JeusMessage_SNMP.SNMP_38, (Object[])new String[]{mbeanServerName, mbeanServer.toString()}, (Throwable)e);
            }
            return;
        }
        Hashtable hashtable = this.objNameTablePerMserver;
        synchronized (hashtable) {
            allObjNames = (Hashtable<String, ObjNameTableElement>)this.objNameTablePerMserver.get(mbeanServer);
            for (ObjectInstance objInstance : allObjSet) {
                ArrayList attrs;
                ObjectName objName = objInstance.getObjectName();
                if (objName == null) continue;
                String mbeanName = objInstance.getClassName();
                if (mbeanName != null) {
                    mbeanName = StringUtil.getClassName((String)mbeanName);
                }
                if ((attrs = this.snmpSupportMbeanTable.getAttributes(mbeanName)) == null) continue;
                String objStringName = objName.getCanonicalName();
                if (allObjNames != null && allObjNames.get(objStringName) != null) continue;
                String shortOid = System.getProperty("jeus.management.snmp.dynamic.shortoid");
                String uniqueId = shortOid != null && shortOid.equals("true") ? UtilSnmpOidMaker.getShortSnmpOidByObjectName(objName) : UtilSnmpOidMaker.getSnmpOidByObjectName(objStringName);
                for (int i = 0; i < attrs.size(); ++i) {
                    this.addEventListener(mbeanName, (String)attrs.get(i), uniqueId, objStringName);
                }
                if (allObjNames == null) {
                    allObjNames = new Hashtable<String, ObjNameTableElement>();
                }
                ObjNameTableElement objNameElm = new ObjNameTableElement(objName, mbeanName);
                allObjNames.put(objStringName, objNameElm);
            }
            if (allObjNames != null) {
                this.objNameTablePerMserver.put(mbeanServer, allObjNames);
            }
        }
        if (logger.isLoggable(JeusMessage_SNMP.SNMP_39_LEVEL)) {
            logger.log(JeusMessage_SNMP.SNMP_39_LEVEL, JeusMessage_SNMP.SNMP_39, (Object[])new String[]{mbeanServerName, mbeanServer.toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSnmpFromMbeanServer(String mbeanServerName, MBeanServerConnection mbeanServer) {
        if (mbeanServerName == null || mbeanServer == null) {
            return;
        }
        Hashtable hashtable = this.objNameTablePerMserver;
        synchronized (hashtable) {
            if (this.objNameTablePerMserver.isEmpty()) {
                return;
            }
            Hashtable allObjNames = (Hashtable)this.objNameTablePerMserver.remove(mbeanServer);
            if (allObjNames == null) {
                return;
            }
            for (ObjNameTableElement objNameElm : allObjNames.values()) {
                ObjectName objName = objNameElm.getObjectName();
                String objStringName = objName.getCanonicalName();
                String mbeanName = objNameElm.getMbeanName();
                ArrayList attrs = this.snmpSupportMbeanTable.getAttributes(mbeanName);
                if (attrs == null) continue;
                String shortOid = System.getProperty("jeus.management.snmp.dynamic.shortoid");
                String uniqueId = shortOid != null && shortOid.equals("true") ? UtilSnmpOidMaker.getShortSnmpOidByObjectName(objName) : UtilSnmpOidMaker.getSnmpOidByObjectName(objStringName);
                for (int j = 0; j < attrs.size(); ++j) {
                    this.removeEventListener((String)attrs.get(j), uniqueId);
                }
            }
            allObjNames.clear();
        }
        if (logger.isLoggable(JeusMessage_SNMP.SNMP_49_LEVEL)) {
            logger.log(JeusMessage_SNMP.SNMP_49_LEVEL, JeusMessage_SNMP.SNMP_49, (Object[])new String[]{mbeanServerName, mbeanServer.toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterSnmpFromAllMbeanServer() {
        Hashtable hashtable = this.objNameTablePerMserver;
        synchronized (hashtable) {
            if (this.objNameTablePerMserver.isEmpty()) {
                return;
            }
            for (Hashtable allObjNames : this.objNameTablePerMserver.values()) {
                for (ObjNameTableElement objNameElm : allObjNames.values()) {
                    ObjectName objName = objNameElm.getObjectName();
                    String objStringName = objName.getCanonicalName();
                    String mbeanName = objNameElm.getMbeanName();
                    ArrayList attrs = this.snmpSupportMbeanTable.getAttributes(mbeanName);
                    if (attrs == null) continue;
                    String shortOid = System.getProperty("jeus.management.snmp.dynamic.shortoid");
                    String uniqueId = shortOid != null && shortOid.equals("true") ? UtilSnmpOidMaker.getShortSnmpOidByObjectName(objName) : UtilSnmpOidMaker.getSnmpOidByObjectName(objStringName);
                    for (int i = 0; i < attrs.size(); ++i) {
                        this.removeEventListener((String)attrs.get(i), uniqueId);
                    }
                }
                allObjNames.clear();
            }
            this.objNameTablePerMserver.clear();
        }
        if (logger.isLoggable(JeusMessage_SNMP.SNMP_40_LEVEL)) {
            logger.log(JeusMessage_SNMP.SNMP_40_LEVEL, JeusMessage_SNMP.SNMP_40);
        }
    }

    public String getManagerName() {
        return this.managerName;
    }
}

