/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import jeus.management.snmp.core.AsnInteger;
import jeus.management.snmp.core.AsnNull;
import jeus.management.snmp.core.AsnOID;
import jeus.management.snmp.core.AsnObject;
import jeus.management.snmp.core.AsnOctets;
import jeus.management.snmp.core.AsnSequence;
import jeus.management.snmp.core.AsnUnsignedInteger;

public abstract class AsnFactory {
    protected static final char[] hex_v = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String asnType2String(byte byte0) {
        switch (byte0) {
            case 1: {
                return "ASN_BOOLEAN(" + AsnFactory.toHex(byte0) + ")";
            }
            case 2: {
                return "ASN_INTEGER(" + AsnFactory.toHex(byte0) + ")";
            }
            case 3: {
                return "ASN_BIT_STR(" + AsnFactory.toHex(byte0) + ")";
            }
            case 4: {
                return "ASN_OCTET_STR(" + AsnFactory.toHex(byte0) + ")";
            }
            case 5: {
                return "ASN_NULL(" + AsnFactory.toHex(byte0) + ")";
            }
            case 6: {
                return "ASN_OBJECT_ID(" + AsnFactory.toHex(byte0) + ")";
            }
            case 16: {
                return "ASN_SEQUENCE(" + AsnFactory.toHex(byte0) + ")";
            }
            case 17: {
                return "ASN_SET(" + AsnFactory.toHex(byte0) + ")";
            }
            case 0: {
                return "ASN_UNIVERSAL(" + AsnFactory.toHex(byte0) + ")";
            }
            case -128: {
                return "ASN_CONTEXT(" + AsnFactory.toHex(byte0) + ")";
            }
            case -64: {
                return "ASN_PRIVATE(" + AsnFactory.toHex(byte0) + ")";
            }
            case 32: {
                return "ASN_CONSTRUCTOR(" + AsnFactory.toHex(byte0) + ")";
            }
            case 31: {
                return "ASN_EXTENSION_ID(" + AsnFactory.toHex(byte0) + ")";
            }
            case 64: {
                return "IPADDRESS(" + AsnFactory.toHex(byte0) + ")";
            }
            case 65: {
                return "COUNTER(" + AsnFactory.toHex(byte0) + ")";
            }
            case 66: {
                return "GAUGE(" + AsnFactory.toHex(byte0) + ")";
            }
            case 67: {
                return "TIMETICKS(" + AsnFactory.toHex(byte0) + ")";
            }
            case 68: {
                return "OPAQUE(" + AsnFactory.toHex(byte0) + ")";
            }
            case -96: {
                return "GET_REQ_MSG(" + AsnFactory.toHex(byte0) + ")";
            }
            case -95: {
                return "GETNEXT_REQ_MSG(" + AsnFactory.toHex(byte0) + ")";
            }
            case -94: {
                return "GET_RSP_MSG(" + AsnFactory.toHex(byte0) + ")";
            }
            case -93: {
                return "SET_REQ_MSG(" + AsnFactory.toHex(byte0) + ")";
            }
            case -92: {
                return "TRP_REQ_MSG(" + AsnFactory.toHex(byte0) + ")";
            }
            case -91: {
                return "GET_BULK_MSG(" + AsnFactory.toHex(byte0) + ")";
            }
            case 48: {
                return "CONS_SEQ(" + AsnFactory.toHex(byte0) + ")";
            }
        }
        return "Unknown ASN type '" + byte0 + "'";
    }

    public static String bytes2String(byte[] abyte0) {
        StringBuffer stringbuffer = new StringBuffer();
        for (int i = 0; i < abyte0.length; ++i) {
            if (!Character.isWhitespace((char)abyte0[i])) {
                stringbuffer.append((char)abyte0[i] + ",");
                continue;
            }
            stringbuffer.append(" ,");
        }
        return stringbuffer.toString();
    }

    protected static AsnObject createAsnObjectInstance(InputStream inputstream, byte byte0, int i) throws IOException {
        AsnObject obj = null;
        switch (byte0) {
            case -96: 
            case -95: 
            case -94: 
            case -93: 
            case -92: 
            case -91: 
            case -89: 
            case -88: 
            case 48: {
                obj = new AsnSequence(inputstream, i);
                break;
            }
            case 2: {
                obj = new AsnInteger(inputstream, i);
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 70: {
                obj = new AsnUnsignedInteger(inputstream, i);
                break;
            }
            case 6: {
                obj = new AsnOID(inputstream, i);
                break;
            }
            case 4: 
            case 64: {
                obj = new AsnOctets(inputstream, i);
                break;
            }
            case 5: {
                obj = new AsnNull(inputstream, i);
                break;
            }
            case -128: {
                obj = new AsnNull(-128);
                break;
            }
            case -126: {
                obj = new AsnNull(-126);
                break;
            }
            default: {
                obj = new AsnNull(inputstream, i);
            }
        }
        if (obj != null) {
            ((AsnObject)obj).setType(byte0);
        }
        return obj;
    }

    public static AsnObject extractAsnObject(InputStream inputstream) throws IOException {
        int j = 0;
        AsnObject obj = new AsnNull();
        if (inputstream.available() == 0) {
            return null;
        }
        byte byte0 = (byte)inputstream.read();
        int i = AsnObject.readLength(inputstream);
        if (i != 0) {
            byte[] abyte0 = new byte[i];
            if (i > 0) {
                j = inputstream.read(abyte0, 0, i);
            }
            if (j == i) {
                ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(abyte0);
                obj = AsnFactory.createAsnObjectInstance(bytearrayinputstream, byte0, i);
            }
        }
        return obj;
    }

    public static String toHex(byte byte0) {
        int i = byte0 & 0xF;
        int j = (byte0 & 0xF0) >> 4;
        return "" + hex_v[j] + hex_v[i];
    }

    public static String toHex(byte[] abyte0) {
        StringBuffer stringbuffer = new StringBuffer();
        for (int i = 0; i < abyte0.length; ++i) {
            stringbuffer.append(AsnFactory.toHex(abyte0[i]) + ",");
        }
        return stringbuffer.toString();
    }
}

