/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.core;

public class Encryptor {
    static final int ENCRYPTION = 0;
    static final int DECRYPTION = 1;
    static final int BLOCK_SIZE = 8;
    static final byte[] initialPermutationTab = new byte[]{58, 50, 42, 34, 26, 18, 10, 2, 60, 52, 44, 36, 28, 20, 12, 4, 62, 54, 46, 38, 30, 22, 14, 6, 64, 56, 48, 40, 32, 24, 16, 8, 57, 49, 41, 33, 25, 17, 9, 1, 59, 51, 43, 35, 27, 19, 11, 3, 61, 53, 45, 37, 29, 21, 13, 5, 63, 55, 47, 39, 31, 23, 15, 7};
    static final byte[] keyPermutationTab = new byte[]{57, 49, 41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 26, 18, 10, 2, 59, 51, 43, 35, 27, 19, 11, 3, 60, 52, 44, 36, 63, 55, 47, 39, 31, 23, 15, 7, 62, 54, 46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 29, 21, 13, 5, 28, 20, 12, 4};
    static final byte[] keyShiftTab = new byte[]{1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1};
    static final byte[] keyShiftTab2 = new byte[]{0, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1};
    static final byte[] keyCompressionPermutationTab = new byte[]{14, 17, 11, 24, 1, 5, 3, 28, 15, 6, 21, 10, 23, 19, 12, 4, 26, 8, 16, 7, 27, 20, 13, 2, 41, 52, 31, 37, 47, 55, 30, 40, 51, 45, 33, 48, 44, 49, 39, 56, 34, 53, 46, 42, 50, 36, 29, 32};
    static final byte[] expansionPermutationTab = new byte[]{32, 1, 2, 3, 4, 5, 4, 5, 6, 7, 8, 9, 8, 9, 10, 11, 12, 13, 12, 13, 14, 15, 16, 17, 16, 17, 18, 19, 20, 21, 20, 21, 22, 23, 24, 25, 24, 25, 26, 27, 28, 29, 28, 29, 30, 31, 32, 1};
    static final byte[][] sBoxTab = new byte[][]{{14, 4, 13, 1, 2, 15, 11, 8, 3, 10, 6, 12, 5, 9, 0, 7, 0, 15, 7, 4, 14, 2, 13, 1, 10, 6, 12, 11, 9, 5, 3, 8, 4, 1, 14, 8, 13, 6, 2, 11, 15, 12, 9, 7, 3, 10, 5, 0, 15, 12, 8, 2, 4, 9, 1, 7, 5, 11, 3, 14, 10, 0, 6, 13}, {15, 1, 8, 14, 6, 11, 3, 4, 9, 7, 2, 13, 12, 0, 5, 10, 3, 13, 4, 7, 15, 2, 8, 14, 12, 0, 1, 10, 6, 9, 11, 5, 0, 14, 7, 11, 10, 4, 13, 1, 5, 8, 12, 6, 9, 3, 2, 15, 13, 8, 10, 1, 3, 15, 4, 2, 11, 6, 7, 12, 0, 5, 14, 9}, {10, 0, 9, 14, 6, 3, 15, 5, 1, 13, 12, 7, 11, 4, 2, 8, 13, 7, 0, 9, 3, 4, 6, 10, 2, 8, 5, 14, 12, 11, 15, 1, 13, 6, 4, 9, 8, 15, 3, 0, 11, 1, 2, 12, 5, 10, 14, 7, 1, 10, 13, 0, 6, 9, 8, 7, 4, 15, 14, 3, 11, 5, 2, 12}, {7, 13, 14, 3, 0, 6, 9, 10, 1, 2, 8, 5, 11, 12, 4, 15, 13, 8, 11, 5, 6, 15, 0, 3, 4, 7, 2, 12, 1, 10, 14, 9, 10, 6, 9, 0, 12, 11, 7, 13, 15, 1, 3, 14, 5, 2, 8, 4, 3, 15, 0, 6, 10, 1, 13, 8, 9, 4, 5, 11, 12, 7, 2, 14}, {2, 12, 4, 1, 7, 10, 11, 6, 8, 5, 3, 15, 13, 0, 14, 9, 14, 11, 2, 12, 4, 7, 13, 1, 5, 0, 15, 10, 3, 9, 8, 6, 4, 2, 1, 11, 10, 13, 7, 8, 15, 9, 12, 5, 6, 3, 0, 14, 11, 8, 12, 7, 1, 14, 2, 13, 6, 15, 0, 9, 10, 4, 5, 3}, {12, 1, 10, 15, 9, 2, 6, 8, 0, 13, 3, 4, 14, 7, 5, 11, 10, 15, 4, 2, 7, 12, 9, 5, 6, 1, 13, 14, 0, 11, 3, 8, 9, 14, 15, 5, 2, 8, 12, 3, 7, 0, 4, 10, 1, 13, 11, 6, 4, 3, 2, 12, 9, 5, 15, 10, 11, 14, 1, 7, 6, 0, 8, 13}, {4, 11, 2, 14, 15, 0, 8, 13, 3, 12, 9, 7, 5, 10, 6, 1, 13, 0, 11, 7, 4, 9, 1, 10, 14, 3, 5, 12, 2, 15, 8, 6, 1, 4, 11, 13, 12, 3, 7, 14, 10, 15, 6, 8, 0, 5, 9, 2, 6, 11, 13, 8, 1, 4, 10, 7, 9, 5, 0, 15, 14, 2, 3, 12}, {13, 2, 8, 4, 6, 15, 11, 1, 10, 9, 3, 14, 5, 0, 12, 7, 1, 15, 13, 8, 10, 3, 7, 4, 12, 5, 6, 11, 0, 14, 9, 2, 7, 11, 4, 1, 9, 12, 14, 2, 0, 6, 10, 13, 15, 3, 5, 8, 2, 1, 14, 7, 4, 10, 8, 13, 15, 12, 9, 0, 3, 5, 6, 11}};
    static final byte[] pBoxTab = new byte[]{16, 7, 20, 21, 29, 12, 28, 17, 1, 15, 23, 26, 5, 18, 31, 10, 2, 8, 24, 14, 32, 27, 3, 9, 19, 13, 30, 6, 22, 11, 4, 25};
    static final byte[] finalPermutationTab = new byte[]{40, 8, 48, 16, 56, 24, 64, 32, 39, 7, 47, 15, 55, 23, 63, 31, 38, 6, 46, 14, 54, 22, 62, 30, 37, 5, 45, 13, 53, 21, 61, 29, 36, 4, 44, 12, 52, 20, 60, 28, 35, 3, 43, 11, 51, 19, 59, 27, 34, 2, 42, 10, 50, 18, 58, 26, 33, 1, 41, 9, 49, 17, 57, 25};
    long plainText;
    long key;
    byte[] plainTextBytes;
    byte padding = 0;
    long IV = 0L;
    boolean CBCMode = false;
    int mode;

    public Encryptor(byte[] abyte0, byte[] abyte1) {
        if (abyte0.length % 8 == 0) {
            this.plainTextBytes = abyte0;
        } else {
            this.plainTextBytes = new byte[((abyte0.length - 1) / 8 + 1) * 8];
            for (int i = 0; i < this.plainTextBytes.length; ++i) {
                this.plainTextBytes[i] = i < abyte0.length ? abyte0[i] : (byte)0;
            }
        }
        if (abyte1.length != 8) {
            System.err.println("The key must have a size of 8 bytes.");
            return;
        }
        for (int j = 0; j < 8; ++j) {
            this.key <<= 8;
            this.key = abyte1[j];
        }
    }

    byte[] doFinal() {
        return this.plainTextBytes;
    }

    public long doPartialFinal() {
        long l = this.permutation(this.plainText, initialPermutationTab, 64);
        long l1 = l >> 32 & 0xFFFFFFFFL;
        long l2 = l & 0xFFFFFFFFL;
        long l4 = this.permutation(this.key, keyPermutationTab, 64);
        for (int i = 0; i < 16; ++i) {
            long l3 = l2;
            l4 = this.keyShift(l4, i);
            long l6 = this.permutation(l4, keyCompressionPermutationTab, 56);
            long l7 = this.permutation(l2, expansionPermutationTab, 32);
            l2 = this.sBox(l7 ^= l6);
            l2 = this.permutation(l2, pBoxTab, 32);
            l2 ^= l1;
            l1 = l3;
        }
        long l5 = l1 | l2 << 32;
        l5 = this.permutation(l5, finalPermutationTab, 64);
        return l5;
    }

    public void init(int i, byte[] abyte0) {
        this.mode = i;
        if (abyte0 != null) {
            for (int j = 0; j < 8; ++j) {
                this.IV <<= 8;
                this.IV = abyte0[j];
            }
            this.CBCMode = true;
        }
    }

    private long keyShift(long l, int i) {
        long l3 = l >> 28 & 0xFFFFFFFL;
        long l4 = l & 0xFFFFFFFL;
        if (this.mode == 0) {
            long l1 = (l3 <<= keyShiftTab[i]) & 0xF0000000L;
            l3 &= 0xFFFFFFFL;
            l3 |= (l1 >>= 28);
            l1 = (l4 <<= keyShiftTab[i]) & 0xF0000000L;
            l4 &= 0xFFFFFFFL;
            l4 |= (l1 >>= 28);
        } else {
            long l5 = 0L;
            for (int j = 0; j < keyShiftTab2[i]; ++j) {
                l5 <<= 1;
                l5 |= 1L;
            }
            long l2 = l3 & l5;
            l3 >>= keyShiftTab2[i];
            l3 |= (l2 <<= 28 - keyShiftTab2[i]);
            l2 = l4 & l5;
            l4 >>= keyShiftTab2[i];
            l4 |= (l2 <<= 28 - keyShiftTab2[i]);
        }
        return l3 << 28 | l4;
    }

    public static void main(String[] args) {
        byte[] abyte0 = new byte[]{0, -1, 0, -1, 15, 15, -16, 15};
        String s = "test1234TEST1234WENG";
        byte[] abyte1 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        if (args.length > 0) {
            abyte0 = args[0].getBytes();
        }
        if (args.length > 1) {
            s = args[1];
        }
        if (args.length > 2) {
            abyte1 = args[2].getBytes();
        }
        long l = System.currentTimeMillis();
        byte[] abyte2 = null;
        for (int i = 0; i < 600; ++i) {
            Encryptor encryptor = new Encryptor(s.getBytes(), abyte0);
            encryptor.init(0, abyte1);
            abyte2 = encryptor.doFinal();
            Encryptor encryptor1 = new Encryptor(abyte2, abyte0);
            encryptor1.init(1, abyte1);
            abyte2 = encryptor1.doFinal();
        }
        System.out.println("Time for 600 iterations : " + (System.currentTimeMillis() - l));
        String s1 = new String(abyte2);
    }

    private long permutation(long l, byte[] abyte0, int i) {
        long l1 = 0L;
        int k = abyte0.length;
        for (int j = 0; j < k; ++j) {
            long l3 = 0L;
            long l2 = 1L << k - j - 1;
            int i1 = i - abyte0[j];
            int j1 = k - j - 1;
            l3 = i1 - j1 > 0 ? l >> i1 - j1 : l << -i1 + j1;
            l1 |= (l3 &= l2);
        }
        return l1;
    }

    void printBytes(int i) {
        for (int j = 0; j < 4; ++j) {
            System.out.print(" " + (i >> j * 8 & 0xFF));
        }
        System.out.println("");
    }

    void printBytes(long l) {
        for (int i = 0; i < 8; ++i) {
            System.out.print(" " + (l >> i * 8 & 0xFFL));
        }
        System.out.println("");
    }

    private long sBox(long l) {
        long l1 = 0L;
        for (int i = 0; i < 8; ++i) {
            int j = 42 - i * 6;
            int k = (int)(l >> j & 0x3FL);
            int i1 = (k & 0x20) >> 4 | k & 1;
            int j1 = (k & 0x1E) >> 1;
            l1 <<= 4;
            l1 |= (long)sBoxTab[i][i1 * 16 + j1];
        }
        return l1;
    }
}

