/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.core;

import jeus.management.snmp.core.AsnObject;
import jeus.management.snmp.core.SnmpException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_SNMP;

public abstract class LeafOIDListener {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.management");
    protected String uniqueId;
    public static final String ROWSTATUS_ACTIVE = "active";
    public static final String ROWSTATUS_NOT_IN_SERVICE = "notInService";
    public static final String ROWSTATUS_NOT_READY = "notReady";
    public static final String ROWSTATUS_CREATE_AND_GO = "createAndGo";
    public static final String ROWSTATUS_CREATE_AND_WAIT = "createAndWait";
    public static final String ROWSTATUS_DESTROY = "destroy";
    protected String contextEngineID;
    protected String contextName;
    protected String leafOID;

    public LeafOIDListener() {
    }

    public LeafOIDListener(String s) {
        this.leafOID = s;
    }

    public LeafOIDListener(String oid, String uniqueId) {
        this.leafOID = oid + "." + uniqueId;
        this.uniqueId = uniqueId;
    }

    public void commit() throws SnmpException {
    }

    public static String createStringIndex(String s) {
        String s1 = "";
        s1 = s1 + "." + s.length();
        for (int i = 0; i < s.length(); ++i) {
            s1 = s1 + ".";
            char c = s.charAt(i);
            if (c <= 'z' && c >= 'A') {
                s1 = s1 + Integer.toString(c - 65 + 65);
                continue;
            }
            if (c >= '0' && c <= '9') {
                s1 = s1 + Integer.toString(c - 48 + 48);
                continue;
            }
            if (!logger.isLoggable(JeusMessage_SNMP.SNMP_9_LEVEL)) continue;
            logger.log(JeusMessage_SNMP.SNMP_9_LEVEL, JeusMessage_SNMP.SNMP_9, (Object)String.valueOf(c));
        }
        return s1;
    }

    public static String extractIndex(String s) throws SnmpException {
        int i = s.lastIndexOf(46);
        if (i < 0) {
            throw new SnmpException(18);
        }
        return s.substring(i + 1);
    }

    public static String extractIndex(String s, String s1) throws SnmpException {
        int k;
        int i = s1.indexOf(s);
        if (i < 0) {
            throw new SnmpException(18);
        }
        if (i >= s1.length() - s.length() - 1) {
            return "";
        }
        String s2 = s1.substring(i + 1 + s.length());
        int j = 0;
        char[] ac = new char[s2.length()];
        i = 0;
        do {
            String s3;
            if ((k = s2.indexOf(46, i)) == -1) {
                s3 = s2.substring(i, s2.length());
                k = s2.length();
            } else {
                s3 = s2.substring(i, k);
            }
            if (i != 0) {
                int l = Integer.valueOf(s3);
                if (l >= 65) {
                    ac[j++] = (char)(l - 65 + 65);
                } else if (l >= 48) {
                    ac[j++] = (char)(l - 48 + 48);
                } else {
                    if (logger.isLoggable(JeusMessage_SNMP.SNMP_10_LEVEL)) {
                        logger.log(JeusMessage_SNMP.SNMP_10_LEVEL, JeusMessage_SNMP.SNMP_10, (Object)String.valueOf(l));
                    }
                    ac[j++] = 48;
                }
            }
            i = k + 1;
        } while (k < s2.length());
        String s4 = new String(ac, 0, j);
        return s4;
    }

    protected static String extractOID(String s) throws SnmpException {
        int i = s.lastIndexOf(46);
        if (i < 0) {
            throw new SnmpException(18);
        }
        String s1 = s.substring(0, i);
        return s1;
    }

    public String getFirstIndex() {
        return ".0";
    }

    public String getNextInstanceID(String s) throws SnmpException {
        if (s.equals(this.getOID())) {
            return s + ".0";
        }
        return null;
    }

    public String getOID() {
        return this.leafOID;
    }

    public AsnObject getValue(String s) throws SnmpException {
        throw new SnmpException(6);
    }

    public boolean isJustCommit() {
        return false;
    }

    void setCName(byte[] abyte0, byte[] abyte1) {
        this.contextEngineID = abyte0 != null ? new String(abyte0) : null;
        this.contextName = abyte1 != null ? new String(abyte1) : null;
    }

    public void setValue(String s, AsnObject asnobject) throws SnmpException {
        throw new SnmpException(7);
    }

    public void undo() throws SnmpException {
    }

    public String getUniqueID() {
        return this.uniqueId;
    }
}

