/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.core;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Random;
import jeus.management.snmp.core.AsnFactory;
import jeus.management.snmp.core.AsnObject;
import jeus.management.snmp.core.AsnSequence;
import jeus.management.snmp.core.Authenticator;
import jeus.management.snmp.core.SnmpGetSetPdu;
import jeus.management.snmp.core.SnmpMessage;
import jeus.management.snmp.core.SnmpPdu;
import jeus.management.snmp.core.SnmpSecurityParameters;
import jeus.util.properties.JeusNetPropertyValues;

public class SnmpClient {
    protected DatagramSocket receive_socket = null;
    protected DatagramSocket send_socket = null;
    protected BufferedReader in = null;
    protected boolean responde = false;
    SnmpSecurityParameters sec = null;
    InetAddress address = null;
    int port;
    long startTime;
    Random random = new Random();
    SnmpMessage snmpMessage;

    public SnmpClient() {
        try {
            this.receive_socket = new DatagramSocket();
            this.receive_socket.setSoTimeout(3000);
            this.send_socket = this.receive_socket;
        }
        catch (SocketException socketexception) {
            System.err.println("SnmpClient exception : " + socketexception);
        }
    }

    private void discoverRemoteEngineID() throws IOException {
        this.snmpMessage = new SnmpMessage();
        SnmpGetSetPdu snmpgetsetpdu = new SnmpGetSetPdu();
        snmpgetsetpdu.setMsgType((byte)-96);
        snmpgetsetpdu.setReqId(1L);
        this.snmpMessage.setPdu(snmpgetsetpdu);
        this.snmpMessage.isReportRequired(true);
        this.snmpMessage.setSnmpVersion(3L);
        this.sec = new SnmpSecurityParameters();
        this.sec.setMsgUserName("initial".getBytes());
        this.snmpMessage.setSecurityParameters(this.sec);
        this.send(this.snmpMessage);
        this.sec = ((SnmpGetSetPdu)this.snmpMessage.getPdu()).getErrorStatus() != 0L ? null : this.snmpMessage.getSecurityParameters();
        this.startTime = System.currentTimeMillis();
    }

    private void discoverRemoteEngineTime(byte[] abyte0, byte[] abyte1, int i, boolean flag) throws IOException {
        this.snmpMessage = new SnmpMessage();
        SnmpGetSetPdu snmpgetsetpdu = new SnmpGetSetPdu();
        snmpgetsetpdu.setMsgType((byte)-96);
        snmpgetsetpdu.setReqId(1L);
        this.snmpMessage.setPdu(snmpgetsetpdu);
        this.snmpMessage.isReportRequired(true);
        this.snmpMessage.setSnmpVersion(3L);
        this.sec.setMsgUserName(abyte0);
        this.snmpMessage.setSecurityParameters(this.sec);
        this.snmpMessage.setAuthMode(flag);
        this.snmpMessage.setAuthAlgorithm(i);
        this.snmpMessage.setAuthPassword(abyte1);
        this.send(this.snmpMessage);
        this.sec = ((SnmpGetSetPdu)this.snmpMessage.getPdu()).getErrorStatus() != 0L ? null : this.snmpMessage.getSecurityParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(SnmpMessage snmpmessage) throws IOException {
        snmpmessage.isAgent = false;
        AsnSequence asnsequence = snmpmessage.createAsnSequence(null);
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        asnsequence.write(bytearrayoutputstream);
        bytearrayoutputstream.close();
        byte[] abyte0 = bytearrayoutputstream.toByteArray();
        int i = snmpmessage.getAuthAlgorithm();
        Authenticator.doSnmpAuthentication(abyte0, true, i, snmpmessage.getAuthPassword(), null);
        DatagramPacket datagrampacket = new DatagramPacket(abyte0, abyte0.length, this.address, this.port);
        this.send_socket.send(datagrampacket);
        SnmpPdu snmppdu = snmpmessage.getPdu();
        if (snmppdu.getMsgType() == -92 || snmppdu.getMsgType() == -89) {
            return;
        }
        byte[] abyte1 = new byte[AsnObject.MAX_PACKET_SIZE + 1];
        DatagramPacket datagrampacket1 = new DatagramPacket(abyte1, abyte1.length);
        SnmpClient snmpClient = this;
        synchronized (snmpClient) {
            this.receive_socket.receive(datagrampacket1);
        }
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(datagrampacket1.getData(), 0, datagrampacket1.getLength());
        if (datagrampacket1.getLength() > AsnObject.MAX_PACKET_SIZE) {
            System.err.println("packet is too large.");
            return;
        }
        AsnObject asnobject = AsnFactory.extractAsnObject(bytearrayinputstream);
        if (asnobject == null) {
            System.out.println("Unsupported PDU...");
        } else {
            snmpmessage.init((AsnSequence)asnobject, null);
        }
    }

    public void sendSnmpMessage(String s, int i, SnmpMessage snmpmessage) throws IOException {
        this.address = JeusNetPropertyValues.getByName((String)s);
        this.port = i;
        if (snmpmessage.getSnmpVersion() == 3L) {
            if (snmpmessage.getPdu().getMsgType() != -89 && this.sec == null) {
                this.discoverRemoteEngineID();
                if (this.sec == null) {
                    snmpmessage.setPdu(this.snmpMessage.getPdu());
                    return;
                }
                this.discoverRemoteEngineTime(snmpmessage.getUserName(), snmpmessage.getAuthPassword(), snmpmessage.getAuthAlgorithm(), snmpmessage.getAuthMode());
                if (this.sec == null) {
                    snmpmessage.setPdu(this.snmpMessage.getPdu());
                    return;
                }
            }
            if (this.sec == null) {
                this.sec = new SnmpSecurityParameters();
                this.sec.setMsgUserName(snmpmessage.getUserName());
            }
            if (snmpmessage.getEncryptionMode()) {
                byte[] abyte0 = new byte[8];
                this.random.nextBytes(abyte0);
                this.sec.setMsgPrivacyParameters(abyte0);
            }
            if (snmpmessage.getPdu().getMsgType() != -89) {
                snmpmessage.isReportRequired(true);
            }
            long l = (System.currentTimeMillis() - this.startTime) / 1000L;
            this.sec.setMsgAuthoritativeEngineTime(this.sec.getMsgAuthoritativeEngineTime() + (int)l);
            snmpmessage.setSecurityParameters(this.sec);
        }
        this.send(snmpmessage);
    }
}

