/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.core;

import java.util.Enumeration;
import java.util.Vector;
import jeus.management.snmp.core.AsnFactory;
import jeus.management.snmp.core.AsnInteger;
import jeus.management.snmp.core.AsnNameValuePair;
import jeus.management.snmp.core.AsnNull;
import jeus.management.snmp.core.AsnOID;
import jeus.management.snmp.core.AsnObject;
import jeus.management.snmp.core.AsnSequence;
import jeus.management.snmp.core.SnmpPdu;

public class SnmpGetSetPdu
extends SnmpPdu {
    long req_id = 0L;
    long errstat = 0L;
    long errind = 0L;
    long nonRepeaters;
    long maxRepetitions;
    protected Vector varbinds = new Vector();

    public SnmpGetSetPdu() {
    }

    public SnmpGetSetPdu(AsnSequence asnsequence) {
        this.init(asnsequence);
    }

    public void addNameValuePair(AsnNameValuePair asnnamevaluepair) {
        this.varbinds.addElement(asnnamevaluepair);
    }

    public void addNameValuePair(String s) {
        AsnNameValuePair asnnamevaluepair = new AsnNameValuePair(s);
        this.varbinds.addElement(asnnamevaluepair);
    }

    public AsnSequence createAsnSequence() {
        AsnSequence asnsequence = new AsnSequence();
        asnsequence.setType(this.getMsgType());
        asnsequence.add(new AsnInteger(this.req_id));
        if (this.getMsgType() != -91) {
            asnsequence.add(new AsnInteger(this.getErrorStatus()));
            asnsequence.add(new AsnInteger(this.getErrorIndex()));
        } else {
            asnsequence.add(new AsnInteger(this.getNonRepeaters()));
            asnsequence.add(new AsnInteger(this.getMaxRepetitions()));
        }
        AsnSequence asnsequence1 = new AsnSequence();
        asnsequence.add(asnsequence1);
        Enumeration enumeration = this.varbinds.elements();
        while (enumeration.hasMoreElements()) {
            AsnNameValuePair asnnamevaluepair = (AsnNameValuePair)enumeration.nextElement();
            AsnSequence asnsequence2 = new AsnSequence();
            asnsequence2.add(asnnamevaluepair.getName());
            asnsequence2.add(asnnamevaluepair.getValue());
            asnsequence1.add(asnsequence2);
        }
        return asnsequence;
    }

    public long getErrorIndex() {
        return this.errind;
    }

    public long getErrorStatus() {
        return this.errstat;
    }

    public long getMaxRepetitions() {
        return this.maxRepetitions;
    }

    public AsnNameValuePair getNameValuePair(int i) {
        return (AsnNameValuePair)this.varbinds.elementAt(i);
    }

    public long getNonRepeaters() {
        return this.nonRepeaters;
    }

    public long getReqId() {
        return this.req_id;
    }

    public AsnObject getValue(int i) {
        AsnNameValuePair asnnamevaluepair = (AsnNameValuePair)this.varbinds.elementAt(i);
        return asnnamevaluepair.getValue();
    }

    public AsnObject getValue(AsnOID asnoid) {
        Enumeration enumeration = this.varbinds.elements();
        while (enumeration.hasMoreElements()) {
            AsnNameValuePair asnnamevaluepair = (AsnNameValuePair)enumeration.nextElement();
            if (!asnnamevaluepair.getName().same(asnoid)) continue;
            return asnnamevaluepair.getValue();
        }
        return new AsnNull();
    }

    public AsnObject getValue(String s) {
        return this.getValue(new AsnOID(s));
    }

    public int getValueSize() {
        return this.varbinds.size();
    }

    public Vector getVarBinds() {
        return this.varbinds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(AsnSequence asnsequence) {
        this.setMsgType(asnsequence.getType());
        this.req_id = ((AsnInteger)asnsequence.getObj(0)).getValue();
        if (this.getMsgType() != -91) {
            AsnInteger asninteger = (AsnInteger)asnsequence.getObj(1);
            this.setErrorStatus(asninteger.getValue());
            AsnInteger asninteger2 = (AsnInteger)asnsequence.getObj(2);
            this.setErrorIndex(asninteger2.getValue());
        } else {
            AsnInteger asninteger1 = (AsnInteger)asnsequence.getObj(1);
            this.setNonRepeaters(asninteger1.getValue());
            AsnInteger asninteger3 = (AsnInteger)asnsequence.getObj(2);
            this.setMaxRepetitions(asninteger3.getValue());
        }
        AsnObject asnobject = asnsequence.getObj(3);
        if (asnobject instanceof AsnSequence) {
            AsnSequence asnsequence1 = (AsnSequence)asnobject;
            int i = asnsequence1.size();
            this.varbinds = new Vector(i, i / 2);
            for (int j = 0; j < asnsequence1.size(); ++j) {
                AsnObject asnobject1 = asnsequence1.getObj(j);
                if (!(asnobject1 instanceof AsnSequence)) continue;
                AsnSequence asnsequence2 = (AsnSequence)asnobject1;
                AsnNameValuePair asnnamevaluepair = new AsnNameValuePair();
                AsnObject asnobject2 = (AsnObject)asnnamevaluepair.setData(asnsequence2);
                this.varbinds.addElement(asnnamevaluepair);
                this.setChanged();
            }
        }
        this.clearChanged();
        SnmpGetSetPdu snmpGetSetPdu = this;
        synchronized (snmpGetSetPdu) {
            this.notify();
        }
    }

    public void removeNameValuePair(AsnNameValuePair asnnamevaluepair) {
        this.removeNameValuePair(asnnamevaluepair.getName());
    }

    public void removeNameValuePair(AsnOID asnoid) {
        Enumeration enumeration = this.varbinds.elements();
        while (enumeration.hasMoreElements()) {
            AsnNameValuePair asnnamevaluepair = (AsnNameValuePair)enumeration.nextElement();
            if (!asnnamevaluepair.getName().same(asnoid)) continue;
            this.varbinds.removeElement(asnnamevaluepair);
            break;
        }
    }

    public void removeVarBinds() {
        this.varbinds.removeAllElements();
    }

    public void setErrorIndex(long l) {
        this.errind = l;
    }

    public void setErrorStatus(long l) {
        this.errstat = l;
    }

    public void setMaxRepetitions(long l) {
        this.maxRepetitions = l;
    }

    public void setNonRepeaters(long l) {
        this.nonRepeaters = l;
    }

    public void setReqId(long l) {
        this.req_id = l;
    }

    public void setValue(AsnOID asnoid, AsnObject asnobject) {
        Enumeration enumeration = this.varbinds.elements();
        while (enumeration.hasMoreElements()) {
            AsnNameValuePair asnnamevaluepair = (AsnNameValuePair)enumeration.nextElement();
            if (!asnnamevaluepair.getName().same(asnoid)) continue;
            asnnamevaluepair.setValue(asnobject);
        }
    }

    public void setValue(String s, AsnObject asnobject) {
        this.setValue(new AsnOID(s), asnobject);
    }

    public void setVarBinds(Vector vector) {
        this.varbinds = vector;
    }

    public String toString() {
        return this.getClass().getName() + "{" + "msg_type=" + AsnFactory.asnType2String(this.getMsgType()) + ", req_id=" + this.req_id + ", varbinds=" + this.varbinds + "}";
    }
}

