/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Observable;
import java.util.Vector;
import jeus.management.snmp.core.AsnFactory;
import jeus.management.snmp.core.AsnInteger;
import jeus.management.snmp.core.AsnNull;
import jeus.management.snmp.core.AsnObject;
import jeus.management.snmp.core.AsnOctets;
import jeus.management.snmp.core.AsnSequence;
import jeus.management.snmp.core.Encryptor;
import jeus.management.snmp.core.SecurityInterface;
import jeus.management.snmp.core.SnmpGetSetPdu;
import jeus.management.snmp.core.SnmpPdu;
import jeus.management.snmp.core.SnmpSecurityParameters;
import jeus.management.snmp.core.SnmpTrapPdu;
import jeus.management.snmp.core.SnmpV3Header;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_SNMP;

public class SnmpMessage
extends Observable {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.management");
    long snmp_version = 1L;
    String community = "public";
    protected SnmpPdu pdu = null;
    SnmpV3Header v3header = null;
    SnmpSecurityParameters securityParameters = null;
    byte[] contextEngineID = null;
    byte[] contextName = null;
    byte[] authPassword = null;
    byte[] encryptPassword = null;
    byte[] userName = null;
    int authAlgorithm = 0;
    boolean isAgent = true;
    boolean discoveryPhase = false;
    String secFailureReason = null;
    int errorStatus = 0;

    public SnmpMessage() {
    }

    public SnmpMessage(AsnSequence asnsequence, SecurityInterface securityinterface) {
        this.init(asnsequence, securityinterface);
    }

    public AsnSequence createAsnSequence(SecurityInterface securityinterface) {
        AsnSequence asnsequence = null;
        if (this.snmp_version == 3L) {
            if (this.v3header == null) {
                this.v3header = new SnmpV3Header();
            }
            if ((this.v3header.getMsgFlags()[0] & 1) != 0) {
                byte[] abyte0 = new byte[12];
                this.securityParameters.setMsgAuthenticationParameters(abyte0);
            }
            if (this.isAgent) {
                this.securityParameters.setMsgAuthoritativeEngineID(securityinterface.getEngineID());
                if (!"initial".equals(new String(this.securityParameters.getMsgUserName()))) {
                    this.securityParameters.setMsgAuthoritativeEngineBoots((int)securityinterface.getEngineBoots());
                    this.securityParameters.setMsgAuthoritativeEngineTime((int)securityinterface.getEngineTime());
                }
            }
            this.v3header.setMsgSecurityParameters(this.securityParameters.createByteArray());
            asnsequence = this.v3header.createAsnSequence();
        } else {
            asnsequence = new AsnSequence();
            asnsequence.add(new AsnInteger(this.snmp_version));
            asnsequence.add(new AsnOctets(this.community));
        }
        if (this.pdu != null) {
            if (this.snmp_version == 3L) {
                AsnSequence asnsequence1 = new AsnSequence();
                if (this.contextEngineID != null) {
                    asnsequence1.add(new AsnOctets(this.contextEngineID));
                } else {
                    asnsequence1.add(new AsnNull());
                }
                if (this.contextName != null) {
                    asnsequence1.add(new AsnOctets(this.contextName));
                } else {
                    asnsequence1.add(new AsnNull());
                }
                AsnSequence asnsequence2 = this.pdu.createAsnSequence();
                asnsequence1.add(asnsequence2);
                if ((this.v3header.getMsgFlags()[0] & 2) != 0) {
                    byte[] abyte1 = this.securityParameters.getMsgPrivacyParameters();
                    ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                    try {
                        asnsequence1.write(bytearrayoutputstream);
                        bytearrayoutputstream.close();
                    }
                    catch (Exception _ex) {
                        // empty catch block
                    }
                    byte[] abyte2 = bytearrayoutputstream.toByteArray();
                    if (this.encryptPassword == null) {
                        this.encryptPassword = securityinterface.getEncryptionPassword(this.securityParameters.getMsgUserName());
                    }
                    Encryptor encryptor = new Encryptor(abyte2, this.encryptPassword);
                    encryptor.init(0, abyte1);
                    byte[] abyte3 = encryptor.doFinal();
                    asnsequence.add(new AsnOctets(abyte3));
                } else {
                    asnsequence.add(asnsequence1);
                }
            } else {
                asnsequence.add(this.pdu.createAsnSequence());
            }
        }
        return asnsequence;
    }

    public int getAuthAlgorithm() {
        return this.authAlgorithm;
    }

    public boolean getAuthMode() {
        if (this.v3header == null) {
            return false;
        }
        byte[] abyte0 = this.v3header.getMsgFlags();
        return (abyte0[0] & 1) != 0;
    }

    public byte[] getAuthPassword() {
        return this.authPassword;
    }

    public String getCommunity() {
        return this.community;
    }

    public byte[] getContextEngineID() {
        return this.contextEngineID;
    }

    public byte[] getContextName() {
        return this.contextName;
    }

    public boolean getEncryptionMode() {
        if (this.v3header == null) {
            return false;
        }
        byte[] abyte0 = this.v3header.getMsgFlags();
        return (abyte0[0] & 2) != 0;
    }

    public SnmpPdu getPdu() {
        return this.pdu;
    }

    public SnmpSecurityParameters getSecurityParameters() {
        return this.securityParameters;
    }

    public long getSnmpVersion() {
        return this.snmp_version;
    }

    public byte[] getUserName() {
        return this.userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(AsnSequence asnsequence, SecurityInterface securityinterface) {
        AsnObject obj = null;
        AsnObject asnobject = asnsequence.getObj(0);
        if (asnobject == null || !(asnobject instanceof AsnInteger)) {
            if (logger.isLoggable(JeusMessage_SNMP.SNMP_16_LEVEL)) {
                logger.log(JeusMessage_SNMP.SNMP_16_LEVEL, JeusMessage_SNMP.SNMP_16);
            }
            this.errorStatus = 5;
            return;
        }
        this.snmp_version = ((AsnInteger)asnsequence.getObj(0)).getValue();
        if (this.snmp_version == 3L) {
            this.v3header = new SnmpV3Header();
            this.v3header.init(asnsequence);
            this.securityParameters = new SnmpSecurityParameters();
            this.securityParameters.init(this.v3header.getMsgSecurityParameters());
            if (this.isAgent) {
                if (securityinterface == null) {
                    System.err.println("Security interface implementation is missing.");
                    return;
                }
                int i = 0;
                i = "initial".equals(new String(this.securityParameters.getMsgUserName())) && this.securityParameters.getMsgAuthoritativeEngineID() == null ? 4 : securityinterface.getUserProfile(this.securityParameters.getMsgUserName());
                if ((i & 4) == 0) {
                    System.err.println("Unknown user name " + new String(this.securityParameters.getMsgUserName()));
                    this.secFailureReason = "1.3.6.1.6.3.15.1.1.3";
                    this.errorStatus = 16;
                    return;
                }
                if ((i & 1) == 0 != ((this.v3header.getMsgFlags()[0] & 1) == 0)) {
                    System.err.println("Authentication is required for user " + new String(this.securityParameters.getMsgUserName()));
                    this.secFailureReason = "1.3.6.1.6.3.15.1.1.1";
                    this.errorStatus = 16;
                    return;
                }
                if (this.securityParameters.getMsgAuthoritativeEngineBoots() != 0 || this.securityParameters.getMsgAuthoritativeEngineTime() != 0) {
                    if ((i & 2) == 0 != ((this.v3header.getMsgFlags()[0] & 2) == 0)) {
                        System.err.println("Encryption is required for user " + new String(this.securityParameters.getMsgUserName()));
                        this.secFailureReason = "1.3.6.1.6.3.15.1.1.1";
                        this.errorStatus = 16;
                        return;
                    }
                    if ((i & 2) != 0) {
                        this.encryptPassword = securityinterface.getEncryptionPassword(this.securityParameters.getMsgUserName());
                    }
                }
            }
            AsnObject asnobject2 = asnsequence.getObj(3);
            if ((this.v3header.getMsgFlags()[0] & 2) != 0) {
                byte[] abyte0 = this.securityParameters.getMsgPrivacyParameters();
                if (this.encryptPassword == null) {
                    System.err.println("encryption password for user " + new String(this.securityParameters.getMsgUserName()) + " is missing.");
                    this.secFailureReason = "1.3.6.1.6.3.15.1.1.1";
                    this.errorStatus = 16;
                    return;
                }
                Encryptor encryptor = new Encryptor(((AsnOctets)asnobject2).getValue(), this.encryptPassword);
                encryptor.init(1, abyte0);
                byte[] abyte1 = encryptor.doFinal();
                ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(abyte1, 0, abyte1.length);
                try {
                    asnobject2 = AsnFactory.extractAsnObject(bytearrayinputstream);
                }
                catch (Exception _ex) {
                    this.secFailureReason = "1.3.6.1.6.3.15.1.1.6";
                    this.errorStatus = 16;
                    return;
                }
            }
            AsnSequence asnsequence2 = null;
            if (asnobject2 == null || !(asnobject2 instanceof AsnSequence)) {
                if (logger.isLoggable(JeusMessage_SNMP.SNMP_17_LEVEL)) {
                    logger.log(JeusMessage_SNMP.SNMP_17_LEVEL, JeusMessage_SNMP.SNMP_17);
                }
                this.secFailureReason = "1.3.6.1.6.3.15.1.1.6";
                this.errorStatus = 16;
                return;
            }
            asnsequence2 = (AsnSequence)asnobject2;
            AsnObject asnobject1 = asnsequence2.getObj(0);
            this.contextEngineID = (byte[])(asnobject1 instanceof AsnNull ? null : ((AsnOctets)asnobject1).getValue());
            asnobject1 = asnsequence2.getObj(1);
            this.contextName = (byte[])(asnobject1 instanceof AsnNull ? null : ((AsnOctets)asnobject1).getValue());
            asnobject1 = asnsequence2.getObj(2);
            obj = asnobject1 instanceof AsnNull ? null : (AsnSequence)asnobject1;
        } else {
            AsnOctets asnoctets = (AsnOctets)asnsequence.getObj(1);
            this.community = asnoctets.toString();
            obj = asnsequence.getObj(2);
        }
        if (obj instanceof AsnSequence) {
            AsnSequence asnsequence1 = (AsnSequence)obj;
            switch (asnsequence1.getType()) {
                case -92: {
                    this.pdu = new SnmpTrapPdu(asnsequence1);
                    break;
                }
                default: {
                    this.pdu = new SnmpGetSetPdu(asnsequence1);
                }
            }
            SnmpMessage snmpMessage = this;
            synchronized (snmpMessage) {
                this.notify();
            }
        }
        if (!this.isAgent || !this.getAuthMode() || this.snmp_version != 3L || this.pdu.getMsgType() == -89) {
            return;
        }
        if (this.securityParameters.getMsgAuthoritativeEngineID() == null) {
            System.err.println("Authoritative EngineID is mandatory.");
            this.secFailureReason = "1.3.6.1.6.3.15.1.1.4";
            this.errorStatus = 16;
            return;
        }
        if (!new String(this.securityParameters.getMsgAuthoritativeEngineID()).equals(new String(securityinterface.getEngineID()))) {
            System.err.println("EngineID " + new String(this.securityParameters.getMsgAuthoritativeEngineID()) + " is invalid.");
            this.secFailureReason = "1.3.6.1.6.3.15.1.1.4";
            this.errorStatus = 16;
            return;
        }
        if ("initial".equals(new String(this.securityParameters.getMsgUserName()))) {
            Vector vector = ((SnmpGetSetPdu)this.pdu).getVarBinds();
            if (vector.size() != 0) {
                System.err.println("Discovery phase requests should not have name value pairs.");
                this.pdu = null;
                this.errorStatus = 16;
            }
            this.discoveryPhase = true;
        } else if (this.securityParameters.getMsgAuthoritativeEngineBoots() == 0 && this.securityParameters.getMsgAuthoritativeEngineTime() == 0) {
            Vector vector1 = ((SnmpGetSetPdu)this.pdu).getVarBinds();
            if (vector1.size() != 0) {
                System.err.println("Discovery phase requests should not have name value pairs.");
                this.pdu = null;
                this.errorStatus = 16;
            }
            this.discoveryPhase = true;
        } else {
            boolean flag;
            long l = (int)securityinterface.getEngineTime() - this.securityParameters.getMsgAuthoritativeEngineTime();
            if (l < 0L) {
                l = -l;
            }
            boolean bl = flag = (int)securityinterface.getEngineBoots() == this.securityParameters.getMsgAuthoritativeEngineBoots();
            if (!flag || l > 150L) {
                System.err.println("Timing isn't synchronized.");
                this.secFailureReason = "1.3.6.1.6.3.15.1.1.2";
                this.errorStatus = 16;
                this.pdu = null;
            }
        }
    }

    public boolean isReportRequired() {
        if (this.v3header == null) {
            return false;
        }
        byte[] abyte0 = this.v3header.getMsgFlags();
        return (abyte0[0] & 4) != 0;
    }

    public void isReportRequired(boolean flag) {
        if (this.v3header == null) {
            this.v3header = new SnmpV3Header();
        }
        byte[] abyte0 = this.v3header.getMsgFlags();
        abyte0[0] = flag ? (byte)(abyte0[0] | 4) : (byte)(abyte0[0] & 0xFB);
        this.v3header.setMsgFlags(abyte0);
    }

    public void setAuthAlgorithm(int i) {
        this.authAlgorithm = i;
    }

    public void setAuthMode(boolean flag) {
        if (this.v3header == null) {
            this.v3header = new SnmpV3Header();
        }
        byte[] abyte0 = this.v3header.getMsgFlags();
        abyte0[0] = flag ? (byte)(abyte0[0] | 1) : (byte)(abyte0[0] & 0xFE);
        this.v3header.setMsgFlags(abyte0);
    }

    public void setAuthPassword(byte[] abyte0) {
        this.authPassword = abyte0;
    }

    public void setCommunity(String s) {
        this.community = s;
    }

    public void setContextEngineID(String s) {
        this.contextEngineID = s.getBytes();
    }

    public void setContextName(String s) {
        this.contextName = s.getBytes();
    }

    public void setEncryptPassword(byte[] abyte0) {
        this.encryptPassword = abyte0;
    }

    public void setEncryptionMode(boolean flag) {
        if (this.v3header == null) {
            this.v3header = new SnmpV3Header();
        }
        byte[] abyte0 = this.v3header.getMsgFlags();
        abyte0[0] = flag ? (byte)(abyte0[0] | 2) : (byte)(abyte0[0] & 0xFD);
        this.v3header.setMsgFlags(abyte0);
    }

    public void setPdu(SnmpPdu snmppdu) {
        this.pdu = snmppdu;
    }

    public void setSecurityParameters(SnmpSecurityParameters snmpsecurityparameters) {
        this.securityParameters = snmpsecurityparameters;
    }

    public void setSnmpVersion(long l) {
        this.snmp_version = l;
    }

    public void setUserName(byte[] abyte0) {
        this.userName = abyte0;
    }

    public String toString() {
        return this.getClass().getName() + "{" + "snmp version=" + this.snmp_version + ", community=" + this.community + ", pdu=" + this.pdu + "}";
    }
}

