/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import jeus.management.snmp.core.AsnInteger;
import jeus.management.snmp.core.AsnNull;
import jeus.management.snmp.core.AsnObject;
import jeus.management.snmp.core.AsnOctets;
import jeus.management.snmp.core.AsnSequence;

public class SnmpSecurityParameters {
    private byte[] msgAuthoritativeEngineID = null;
    private int msgAuthoritativeEngineBoots = 0;
    private int msgAuthoritativeEngineTime = 0;
    private byte[] msgUserName = null;
    private byte[] msgAuthenticationParameters = null;
    private byte[] msgPrivacyParameters = null;

    public byte[] createByteArray() {
        AsnSequence asnsequence = new AsnSequence();
        if (this.msgAuthoritativeEngineID != null) {
            asnsequence.add(new AsnOctets(this.msgAuthoritativeEngineID));
        } else {
            asnsequence.add(new AsnOctets(new byte[0]));
        }
        asnsequence.add(new AsnInteger(this.msgAuthoritativeEngineBoots));
        asnsequence.add(new AsnInteger(this.msgAuthoritativeEngineTime));
        if (this.msgUserName != null) {
            asnsequence.add(new AsnOctets(this.msgUserName));
        } else {
            asnsequence.add(new AsnOctets(new byte[0]));
        }
        if (this.msgAuthenticationParameters != null) {
            asnsequence.add(new AsnOctets(this.msgAuthenticationParameters));
        } else {
            asnsequence.add(new AsnOctets(new byte[0]));
        }
        if (this.msgPrivacyParameters != null) {
            asnsequence.add(new AsnOctets(this.msgPrivacyParameters));
        } else {
            asnsequence.add(new AsnOctets(new byte[0]));
        }
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        try {
            asnsequence.write(bytearrayoutputstream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bytearrayoutputstream.toByteArray();
    }

    public byte[] getMsgAuthenticationParameters() {
        return this.msgAuthenticationParameters;
    }

    public int getMsgAuthoritativeEngineBoots() {
        return this.msgAuthoritativeEngineBoots;
    }

    public byte[] getMsgAuthoritativeEngineID() {
        return this.msgAuthoritativeEngineID;
    }

    public int getMsgAuthoritativeEngineTime() {
        return this.msgAuthoritativeEngineTime;
    }

    public byte[] getMsgPrivacyParameters() {
        return this.msgPrivacyParameters;
    }

    public byte[] getMsgUserName() {
        return this.msgUserName;
    }

    public void init(byte[] abyte0) {
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(abyte0, 0, abyte0.length);
        AsnSequence asnsequence = null;
        try {
            asnsequence = new AsnSequence(bytearrayinputstream, abyte0.length);
        }
        catch (IOException _ex) {
            // empty catch block
        }
        AsnObject asnobject = asnsequence.getObj(0);
        if (asnobject instanceof AsnSequence) {
            asnsequence = (AsnSequence)asnobject;
        }
        this.msgAuthoritativeEngineID = (byte[])((asnobject = asnsequence.getObj(0)) instanceof AsnNull ? null : ((AsnOctets)asnobject).getValue());
        asnobject = asnsequence.getObj(1);
        this.msgAuthoritativeEngineBoots = asnobject instanceof AsnNull ? 0 : (int)((AsnInteger)asnobject).getValue();
        asnobject = asnsequence.getObj(2);
        this.msgAuthoritativeEngineTime = asnobject instanceof AsnNull ? 0 : (int)((AsnInteger)asnobject).getValue();
        asnobject = asnsequence.getObj(3);
        this.msgUserName = (byte[])(asnobject instanceof AsnNull ? null : ((AsnOctets)asnobject).getValue());
        asnobject = asnsequence.getObj(4);
        this.msgAuthenticationParameters = (byte[])(asnobject instanceof AsnNull ? null : ((AsnOctets)asnobject).getValue());
        asnobject = asnsequence.getObj(5);
        this.msgPrivacyParameters = (byte[])(asnobject instanceof AsnNull ? null : ((AsnOctets)asnobject).getValue());
    }

    public void setMsgAuthenticationParameters(byte[] abyte0) {
        this.msgAuthenticationParameters = abyte0;
    }

    public void setMsgAuthoritativeEngineBoots(int i) {
        this.msgAuthoritativeEngineBoots = i;
    }

    public void setMsgAuthoritativeEngineID(byte[] abyte0) {
        this.msgAuthoritativeEngineID = abyte0;
    }

    public void setMsgAuthoritativeEngineTime(int i) {
        this.msgAuthoritativeEngineTime = i;
    }

    public void setMsgPrivacyParameters(byte[] abyte0) {
        this.msgPrivacyParameters = abyte0;
    }

    public void setMsgUserName(byte[] abyte0) {
        this.msgUserName = abyte0;
    }
}

