/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.listener;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import jeus.management.snmp.adaptor.MbeanToOidTable;
import jeus.management.snmp.agent.ObjNameTableElement;
import jeus.management.snmp.agent.SnmpAgentImpl;
import jeus.management.snmp.listener.HandbackElement;
import jeus.management.snmp.util.UtilSnmpOidMaker;
import jeus.util.StringUtil;

public class SnmpListener
implements NotificationListener {
    private SnmpAgentImpl snmpAgent;
    private Hashtable objNameTablePerMserver;
    private MbeanToOidTable snmpSupportMbeanTable;

    public SnmpListener(SnmpAgentImpl snmpAgent, Hashtable objNameTablePerMserver, MbeanToOidTable snmpSupportMbeanTable) {
        this.snmpAgent = snmpAgent;
        this.objNameTablePerMserver = objNameTablePerMserver;
        this.snmpSupportMbeanTable = snmpSupportMbeanTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notif, Object handback) {
        if (this.snmpAgent == null || this.objNameTablePerMserver == null || this.snmpSupportMbeanTable == null || handback == null || !(handback instanceof HandbackElement)) {
            return;
        }
        HandbackElement handbackElm = (HandbackElement)handback;
        String mbeanServerName = handbackElm.getMbeanServerName();
        MBeanServerConnection msc = handbackElm.getMbeanServerConnection();
        if (mbeanServerName == null || msc == null) {
            return;
        }
        MBeanServerNotification mbsNotification = (MBeanServerNotification)notif;
        String type = mbsNotification.getType();
        ObjectName objName = mbsNotification.getMBeanName();
        if (objName == null) {
            return;
        }
        String objStringName = objName.getCanonicalName();
        String uniqueId = UtilSnmpOidMaker.getSnmpOidByObjectName(objStringName);
        if (type.equals("JMX.mbean.registered")) {
            ArrayList attrs;
            ObjectInstance objInstance = null;
            try {
                objInstance = msc.getObjectInstance(objName);
            }
            catch (InstanceNotFoundException e) {
                return;
            }
            catch (IOException e) {
                return;
            }
            if (objInstance == null) {
                return;
            }
            String mbeanName = objInstance.getClassName();
            if (mbeanName != null) {
                mbeanName = StringUtil.getClassName((String)mbeanName);
            }
            if ((attrs = this.snmpSupportMbeanTable.getAttributes(mbeanName)) == null) {
                return;
            }
            Hashtable hashtable = this.objNameTablePerMserver;
            synchronized (hashtable) {
                Hashtable<String, ObjNameTableElement> allObjNames = (Hashtable<String, ObjNameTableElement>)this.objNameTablePerMserver.get(msc);
                if (allObjNames != null && allObjNames.get(objStringName) != null) {
                    return;
                }
                for (int i = 0; i < attrs.size(); ++i) {
                    this.snmpAgent.addEventListener(mbeanName, (String)attrs.get(i), uniqueId, objStringName);
                }
                if (allObjNames == null) {
                    allObjNames = new Hashtable<String, ObjNameTableElement>();
                }
                ObjNameTableElement objNameElm = new ObjNameTableElement(objName, mbeanName);
                allObjNames.put(objStringName, objNameElm);
                this.objNameTablePerMserver.put(msc, allObjNames);
            }
        }
        if (type.equals("JMX.mbean.unregistered")) {
            Hashtable hashtable = this.objNameTablePerMserver;
            synchronized (hashtable) {
                Hashtable allObjNames = (Hashtable)this.objNameTablePerMserver.get(msc);
                if (allObjNames == null) {
                    return;
                }
                ObjNameTableElement objNameElm = (ObjNameTableElement)allObjNames.remove(objStringName);
                if (objNameElm == null) {
                    return;
                }
                String mbeanName = objNameElm.getMbeanName();
                ArrayList attrs = this.snmpSupportMbeanTable.getAttributes(mbeanName);
                if (attrs == null) {
                    return;
                }
                for (int i = 0; i < attrs.size(); ++i) {
                    this.snmpAgent.removeEventListener((String)attrs.get(i), uniqueId);
                }
            }
        }
    }
}

