/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.util;

import javax.management.ObjectName;
import jeus.management.snmp.util.MD5;
import jeus.util.cnet.NetUtil;

public class UtilSnmpOidMaker {
    public static String getSnmpOidByObjectName(String objectName) {
        String uniqueOid = "";
        String uniqueDumpBytes = null;
        MD5 md5 = new MD5();
        byte[] abyte0 = new byte[16];
        md5.update(objectName.getBytes());
        md5.md5final(abyte0);
        uniqueDumpBytes = MD5.dumpBytes(abyte0);
        int[] intOidArray = null;
        intOidArray = UtilSnmpOidMaker.getTableEntryIndexValue(uniqueDumpBytes);
        for (int j = 0; j < intOidArray.length; ++j) {
            uniqueOid = uniqueOid + intOidArray[j];
            if (j >= intOidArray.length - 1) continue;
            uniqueOid = uniqueOid + ".";
        }
        return uniqueOid;
    }

    private static int[] getTableEntryIndexValue(String s) {
        int i = s.length();
        int[] ai = new int[i + 1];
        int j = 0;
        ai[j++] = i;
        for (int k = 0; k < i; ++k) {
            ai[j++] = s.charAt(k);
        }
        return ai;
    }

    public static String getShortSnmpOidByObjectName(ObjectName objName) {
        String objectName = objName.getCanonicalName();
        String containerName = UtilSnmpOidMaker.getContainerName(objName);
        String oidFromContainerName = UtilSnmpOidMaker.getOid(containerName);
        String oidFromObjectName = UtilSnmpOidMaker.getOid(objectName);
        return oidFromContainerName + "." + oidFromObjectName;
    }

    private static String getOid(String string) {
        int source = string.hashCode();
        byte[] src = new byte[4];
        NetUtil.writeInt((byte[])src, (int)0, (int)source, (boolean)true);
        StringBuffer sb = new StringBuffer();
        String temp = null;
        int id = 0;
        for (int i = 0; i < 4; ++i) {
            id = src[i] + 128;
            temp = Integer.toString(id);
            sb.append(temp);
            if (i >= 3) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    private static String getContainerName(ObjectName objName) {
        String containerName = objName.getKeyProperty("JMXManager");
        if (containerName == null) {
            return "null";
        }
        return containerName;
    }
}

