/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.util;

import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    private static final String DOUBLE_QUOTATION = "\"";
    private static final String COMMA = ",";
    private static final String COLON = ":";
    private static final String SEMI_COLON = ";";
    private static final String SPACE = " ";
    private static final String WHITE_SPACE = " \t\n\r\f";
    private static final String DELIMITERS = "\",:; \t\n\r\f";

    public static String getEngineJeusType(String engineName) {
        String temp = engineName.substring(0, engineName.lastIndexOf(95));
        temp = temp.substring(temp.lastIndexOf(95) + 1);
        if (engineName.indexOf("ejb") >= 0) {
            return "EJBEngine";
        }
        if (engineName.indexOf("servlet") >= 0) {
            return "WebEngine";
        }
        if (engineName.indexOf("jms") >= 0) {
            return "JMSEngine";
        }
        if (engineName.indexOf("ws") >= 0) {
            return "WSEngine";
        }
        throw new RuntimeException("The engine type does not exist : " + temp);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Vector<String> parseClasspathInManifest(String classpath) {
        Vector<String> path = new Vector<String>();
        boolean withinQuotation = false;
        String pathWithinQuotation = null;
        StringTokenizer parser = new StringTokenizer(classpath, DELIMITERS, true);
        block0: while (true) {
            String token;
            block15: {
                if (!parser.hasMoreTokens()) {
                    return path;
                }
                token = parser.nextToken();
                if (token.equals(SPACE)) {
                    if (!withinQuotation) continue;
                    pathWithinQuotation = pathWithinQuotation + token;
                    continue;
                }
                int index = token.indexOf(DOUBLE_QUOTATION);
                if (withinQuotation) {
                    if (index > -1) {
                        withinQuotation = false;
                        pathWithinQuotation = pathWithinQuotation + token.substring(0, index);
                        break block15;
                    } else {
                        pathWithinQuotation = pathWithinQuotation + token;
                        continue;
                    }
                }
                if (index > -1) {
                    withinQuotation = true;
                    pathWithinQuotation = token.substring(index + 1);
                    continue;
                }
                StringTokenizer subParser = null;
                if (token.indexOf(COMMA) > -1) {
                    subParser = new StringTokenizer(token, COMMA);
                } else if (token.indexOf(COLON) > -1) {
                    subParser = new StringTokenizer(token, COLON);
                } else if (token.indexOf(SEMI_COLON) > -1) {
                    subParser = new StringTokenizer(token, SEMI_COLON);
                } else if (token.equals("\t") || token.equals("\r") || token.equals("\n") || token.equals("\f")) continue;
                if (subParser != null) {
                    while (true) {
                        if (!subParser.hasMoreTokens()) continue block0;
                        token = subParser.nextToken();
                        path.add(token);
                    }
                }
            }
            String result = pathWithinQuotation != null ? pathWithinQuotation : token;
            pathWithinQuotation = null;
            path.add(result);
        }
    }
}

