/*
 * Decompiled with CFR 0.152.
 */
package jeus.net;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.helper.JeusIOComponentCreator;
import jeus.jndi.jns.server.repository.ListenerProxy;
import jeus.net.ConnectionListenerFactory;
import jeus.net.ConnectorException;
import jeus.net.Endpoint;
import jeus.net.SocketID;
import jeus.net.impl.ClusterInfo;
import jeus.net.impl.ManagerConnectionManager;
import jeus.net.impl.NodeInfo;
import jeus.server.JeusServer;
import jeus.server.ResurrectionEventListener;
import jeus.util.JeusPort;
import jeus.util.VirtualDNS;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JNSServer;

public class ManagerEndpoint
extends Endpoint
implements ResurrectionEventListener {
    private static final ClusterInfo clusterInfo = JeusServer.clusterInfo;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.net.star");
    private Object piggybackDataForConnect;

    public ManagerEndpoint(String name, boolean isNonblocking, SocketID mySocketID, StreamContentHandlerCreator contentHandlerCreator, ConnectionListenerFactory listenerFactory, SSLContext sslContext, Object piggybackDataForConnect) {
        super(name, isNonblocking ? JeusIOComponentCreator.DEFAULT_CREATOR : JeusIOComponentCreator.createBlockingCreator((String)("IO-" + name), (int)0), mySocketID, contentHandlerCreator, listenerFactory, (Object)sslContext);
        this.piggybackDataForConnect = piggybackDataForConnect;
    }

    public void export() throws IOException, ConnectorException {
        super.export();
        JeusServer.resurrectEventListeners.add(this);
        if (logger.isLoggable(JeusMessage_JNSServer._22_LEVEL)) {
            logger.log(JeusMessage_JNSServer._22_LEVEL, JeusMessage_JNSServer._22);
        }
    }

    protected void createConnectionManager(SocketID mySocketID) {
        this.connectionManager = new ManagerConnectionManager(mySocketID);
    }

    public void unexport() {
        if (logger.isLoggable(JeusMessage_JNSServer._23_LEVEL)) {
            logger.log(JeusMessage_JNSServer._23_LEVEL, JeusMessage_JNSServer._23);
        }
        JeusServer.resurrectEventListeners.remove(this);
        if (logger.isLoggable(JeusMessage_JNSServer._24_LEVEL)) {
            logger.log(JeusMessage_JNSServer._24_LEVEL, JeusMessage_JNSServer._24);
        }
        super.unexport();
    }

    public void resurrectionEventOccurred(String nodeName) {
        block7: {
            int port;
            String node;
            String realnode;
            int idx;
            if (logger.isLoggable(JeusMessage_JNSServer._205_LEVEL)) {
                logger.log(JeusMessage_JNSServer._205_LEVEL, JeusMessage_JNSServer._205, (Object)nodeName);
            }
            if ((idx = (realnode = VirtualDNS.getRealNodeName(nodeName)).indexOf(":")) == -1) {
                node = realnode;
                port = JeusPort.JeusBase;
            } else {
                node = realnode.substring(0, idx);
                port = Integer.parseInt(realnode.substring(idx + 1));
            }
            NodeInfo nodeInfo = this.sslContext != null ? new NodeInfo(node, port, this.mySocketID.getConnectionType()) : new NodeInfo(node, port, this.mySocketID.getVirtualID(), this.mySocketID.getConnectionType());
            if (clusterInfo.getLocalNode().needConnect((SocketID)nodeInfo)) {
                if (logger.isLoggable(JeusMessage_JNSServer._31_LEVEL)) {
                    logger.log(JeusMessage_JNSServer._31_LEVEL, JeusMessage_JNSServer._31, (Object)nodeInfo.toString());
                }
                try {
                    this.connector.tryToConnect((SocketID)nodeInfo, 5, this.piggybackDataForConnect, 0, 0);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(JeusMessage_JNSServer._32_LEVEL)) break block7;
                    logger.log(JeusMessage_JNSServer._32_LEVEL, JeusMessage_JNSServer._32, (Object)nodeInfo.toString());
                }
            }
        }
    }

    public void addListener(ListenerProxy listener) {
        ((ManagerConnectionManager)this.connectionManager).addListener(listener);
    }

    public void removeListener(SocketID socketID, String id) {
        ((ManagerConnectionManager)this.connectionManager).removeListener(socketID, id);
    }
}

