/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import jeus.rmi.spec.server.RMIClassLoader;
import jeus.util.properties.JeusRMIProperties;

public final class MarshalInputStream
extends ObjectInputStream {
    private static final boolean useCodebaseOnlyProperty = JeusRMIProperties.USE_CODE_BASE_ONLY;
    protected static Map permittedSunClasses = new HashMap(3);
    private boolean skipDefaultResolveClass = false;
    private boolean useCodebaseOnly = useCodebaseOnlyProperty;
    private static final Class[] NO_ARGS = new Class[0];
    private static Method lastestUserLoaderMethod = null;
    private ClassLoader firstClassLoader;

    public MarshalInputStream(InputStream in, ClassLoader _cl) throws IOException, StreamCorruptedException {
        super(in);
        this.firstClassLoader = _cl;
        this.enableResolveObject(true);
    }

    public MarshalInputStream(InputStream in) throws IOException, StreamCorruptedException {
        super(in);
        this.enableResolveObject(true);
    }

    public void setFirstClassLoader(ClassLoader _cl) {
        this.firstClassLoader = _cl;
    }

    public final void close() throws IOException {
        super.close();
    }

    protected final Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        Object annotation = this.readLocation();
        String className = classDesc.getName();
        ClassLoader defaultLoader = null;
        try {
            defaultLoader = (ClassLoader)lastestUserLoaderMethod.invoke(null, (Object[])null);
        }
        catch (IllegalAccessException e) {
            throw new ClassNotFoundException("Cannot find the latest user classloader", e);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException("Cannot find the latest user classloader", e);
        }
        catch (InvocationTargetException e) {
            throw new ClassNotFoundException("Cannot find the latest user classloader", e);
        }
        String codebase = null;
        if (!this.useCodebaseOnly && annotation instanceof String) {
            codebase = (String)annotation;
        }
        try {
            return RMIClassLoader.loadClass(codebase, className, defaultLoader);
        }
        catch (AccessControlException e) {
            return this.checkSunClass(className, e);
        }
        catch (ClassNotFoundException e) {
            try {
                if (Character.isLowerCase(className.charAt(0)) && className.indexOf(46) == -1) {
                    return super.resolveClass(classDesc);
                }
            }
            catch (ClassNotFoundException e2) {
                // empty catch block
            }
            throw e;
        }
    }

    protected final Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Object annotation = this.readLocation();
        ClassLoader defaultLoader = null;
        try {
            defaultLoader = (ClassLoader)lastestUserLoaderMethod.invoke(null, (Object[])null);
        }
        catch (IllegalAccessException e) {
            throw new ClassNotFoundException("Cannot find the latest user classloader", e);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException("Cannot find the latest user classloader", e);
        }
        catch (InvocationTargetException e) {
            throw new ClassNotFoundException("Cannot find the latest user classloader", e);
        }
        String codebase = null;
        if (!this.useCodebaseOnly && annotation instanceof String) {
            codebase = (String)annotation;
        }
        return RMIClassLoader.loadProxyClass(codebase, interfaces, defaultLoader);
    }

    private Class checkSunClass(String className, AccessControlException e) throws AccessControlException {
        Permission perm = e.getPermission();
        String name = null;
        if (perm != null) {
            name = perm.getName();
        }
        Class resolvedClass = (Class)permittedSunClasses.get(className);
        if (name == null || resolvedClass == null || !name.equals("accessClassInPackage.jeus.rmi.impl.server") && !name.equals("accessClassInPackage.jeus.rmi.impl.registry")) {
            throw e;
        }
        return resolvedClass;
    }

    protected final Object readLocation() throws IOException, ClassNotFoundException {
        byte isNull = this.readByte();
        if (isNull == 0) {
            return null;
        }
        return this.readUTF();
    }

    final void skipDefaultResolveClass() {
        this.skipDefaultResolveClass = true;
    }

    final void useCodebaseOnly() {
        this.useCodebaseOnly = true;
    }

    protected Object resolveObject(Object obj) throws IOException {
        return obj;
    }

    static {
        try {
            String registry = "jeus.rmi.impl.registry.RegistryImpl_Stub";
            permittedSunClasses.put(registry, Class.forName(registry));
            lastestUserLoaderMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Method result = null;
                    try {
                        Class<ObjectInputStream> io = ObjectInputStream.class;
                        result = io.getDeclaredMethod("latestUserDefinedLoader", NO_ARGS);
                        result.setAccessible(true);
                    }
                    catch (NoSuchMethodException nsme) {
                        throw new Error("java.io.ObjectInputStream latestUserDefinedLoader " + nsme);
                    }
                    return result;
                }
            });
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError("Missing system class: " + e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new NoClassDefFoundError("java.io.ObjectInputStream dose not allow to use latestUserDefinedLoader method for security reason");
        }
    }
}

